-- Create a new schema, to make it easier to cleanup afterwards.
CREATE USER Item55Example
IDENTIFIED BY example
DEFAULT TABLESPACE USERS
TEMPORARY TABLESPACE TEMP
QUOTA 20M on USERS;

ALTER SESSION SET CURRENT_SCHEMA = ITEM55EXAMPLE;

CREATE TABLE DimDate (
  DateKey int NOT NULL,
  DateValue date NOT NULL PRIMARY KEY,
  NextDayValue date NOT NULL,
  YearValue smallint NOT NULL,
  YearQuarter int NOT NULL,
  YearMonth int NOT NULL,
  YearDayOfYear int NOT NULL,
  QuarterValue smallint NOT NULL,
  MonthValue smallint NOT NULL,
  DayOfYear smallint NOT NULL,
  DayOfMonth smallint NOT NULL,
  DayOfWeek smallint NOT NULL,
  YearName varchar(4) NOT NULL,
  YearQuarterName varchar(7) NOT NULL,
  QuarterName varchar(8) NOT NULL,
  MonthName varchar(3) NOT NULL,
  MonthNameLong varchar(9) NOT NULL,
  WeekdayName varchar(3) NOT NULL,
  WeekDayNameLong varchar(9) NOT NULL,
  StartOfYearDate date NOT NULL,
  EndOfYearDate date NOT NULL,
  StartOfQuarterDate date NOT NULL,
  EndOfQuarterDate date NOT NULL,
  StartOfMonthDate date NOT NULL,
  EndOfMonthDate date NOT NULL,
  StartOfWeekStartingSunDate date NOT NULL,
  EndOfWeekStartingSunDate date NOT NULL,
  StartOfWeekStartingMonDate date NOT NULL,
  EndOfWeekStartingMonDate date NOT NULL,
  StartOfWeekStartingTueDate date NOT NULL,
  EndOfWeekStartingTueDate date NOT NULL,
  StartOfWeekStartingWedDate date NOT NULL,
  EndOfWeekStartingWedDate date NOT NULL,
  StartOfWeekStartingThuDate date NOT NULL,
  EndOfWeekStartingThuDate date NOT NULL,
  StartOfWeekStartingFriDate date NOT NULL,
  EndOfWeekStartingFriDate date NOT NULL,
  StartOfWeekStartingSatDate date NOT NULL,
  EndOfWeekStartingSatDate date NOT NULL,
  QuarterSeqNo int NOT NULL,
  MonthSeqNo int NOT NULL,
  WeekStartingSunSeq int NOT NULL,
  WeekStartingMonSeq int NOT NULL,
  WeekStartingTueSeq int NOT NULL,
  WeekStartingWedSeq int NOT NULL,
  WeekStartingThuSeq int NOT NULL,
  WeekStartingFriSeq int NOT NULL,
  WeekStartingSatSeq int NOT NULL,
  JulianDate int NOT NULL,
  ModifiedJulianDate int NOT NULL,
  ISODate varchar(10) NOT NULL,
  ISOYearWeekNo int NOT NULL,
  ISOWeekNo smallint NOT NULL,
  ISODayOfWeek smallint NOT NULL,
  ISOYearWeekName varchar(8) NOT NULL,
  ISOYearWeekDayOfWeekName varchar(10) NOT NULL
);

INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93867, DATE '2010-01-01', DATE '2010-01-02', 2010, 20101, 201001, 2010001, 1, 1, 1, 1, 6, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2009-12-27', DATE '2010-01-02', DATE '2009-12-28', DATE '2010-01-03', DATE '2009-12-29', DATE '2010-01-04', DATE '2009-12-30', DATE '2010-01-05', DATE '2009-12-31', DATE '2010-01-06', DATE '2010-01-01', DATE '2010-01-07', DATE '2009-12-26', DATE '2010-01-01', 1028, 3084, 13408, 13409, 13409, 13409, 13409, 13409, 13408, 2455198, 55197, N'2010-01-01', 200953, 53, 5, N'2009-W53', N'2009-W53-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93868, DATE '2010-01-02', DATE '2010-01-03', 2010, 20101, 201001, 2010002, 1, 1, 2, 2, 7, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2009-12-27', DATE '2010-01-02', DATE '2009-12-28', DATE '2010-01-03', DATE '2009-12-29', DATE '2010-01-04', DATE '2009-12-30', DATE '2010-01-05', DATE '2009-12-31', DATE '2010-01-06', DATE '2010-01-01', DATE '2010-01-07', DATE '2010-01-02', DATE '2010-01-08', 1028, 3084, 13408, 13409, 13409, 13409, 13409, 13409, 13409, 2455199, 55198, N'2010-01-02', 200953, 53, 6, N'2009-W53', N'2009-W53-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93869, DATE '2010-01-03', DATE '2010-01-04', 2010, 20101, 201001, 2010003, 1, 1, 3, 3, 1, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-03', DATE '2010-01-09', DATE '2009-12-28', DATE '2010-01-03', DATE '2009-12-29', DATE '2010-01-04', DATE '2009-12-30', DATE '2010-01-05', DATE '2009-12-31', DATE '2010-01-06', DATE '2010-01-01', DATE '2010-01-07', DATE '2010-01-02', DATE '2010-01-08', 1028, 3084, 13409, 13409, 13409, 13409, 13409, 13409, 13409, 2455200, 55199, N'2010-01-03', 200953, 53, 7, N'2009-W53', N'2009-W53-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93870, DATE '2010-01-04', DATE '2010-01-05', 2010, 20101, 201001, 2010004, 1, 1, 4, 4, 2, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-03', DATE '2010-01-09', DATE '2010-01-04', DATE '2010-01-10', DATE '2009-12-29', DATE '2010-01-04', DATE '2009-12-30', DATE '2010-01-05', DATE '2009-12-31', DATE '2010-01-06', DATE '2010-01-01', DATE '2010-01-07', DATE '2010-01-02', DATE '2010-01-08', 1028, 3084, 13409, 13410, 13409, 13409, 13409, 13409, 13409, 2455201, 55200, N'2010-01-04', 201001, 1, 1, N'2010-W01', N'2010-W01-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93871, DATE '2010-01-05', DATE '2010-01-06', 2010, 20101, 201001, 2010005, 1, 1, 5, 5, 3, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-03', DATE '2010-01-09', DATE '2010-01-04', DATE '2010-01-10', DATE '2010-01-05', DATE '2010-01-11', DATE '2009-12-30', DATE '2010-01-05', DATE '2009-12-31', DATE '2010-01-06', DATE '2010-01-01', DATE '2010-01-07', DATE '2010-01-02', DATE '2010-01-08', 1028, 3084, 13409, 13410, 13410, 13409, 13409, 13409, 13409, 2455202, 55201, N'2010-01-05', 201001, 1, 2, N'2010-W01', N'2010-W01-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93872, DATE '2010-01-06', DATE '2010-01-07', 2010, 20101, 201001, 2010006, 1, 1, 6, 6, 4, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-03', DATE '2010-01-09', DATE '2010-01-04', DATE '2010-01-10', DATE '2010-01-05', DATE '2010-01-11', DATE '2010-01-06', DATE '2010-01-12', DATE '2009-12-31', DATE '2010-01-06', DATE '2010-01-01', DATE '2010-01-07', DATE '2010-01-02', DATE '2010-01-08', 1028, 3084, 13409, 13410, 13410, 13410, 13409, 13409, 13409, 2455203, 55202, N'2010-01-06', 201001, 1, 3, N'2010-W01', N'2010-W01-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93873, DATE '2010-01-07', DATE '2010-01-08', 2010, 20101, 201001, 2010007, 1, 1, 7, 7, 5, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-03', DATE '2010-01-09', DATE '2010-01-04', DATE '2010-01-10', DATE '2010-01-05', DATE '2010-01-11', DATE '2010-01-06', DATE '2010-01-12', DATE '2010-01-07', DATE '2010-01-13', DATE '2010-01-01', DATE '2010-01-07', DATE '2010-01-02', DATE '2010-01-08', 1028, 3084, 13409, 13410, 13410, 13410, 13410, 13409, 13409, 2455204, 55203, N'2010-01-07', 201001, 1, 4, N'2010-W01', N'2010-W01-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93874, DATE '2010-01-08', DATE '2010-01-09', 2010, 20101, 201001, 2010008, 1, 1, 8, 8, 6, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-03', DATE '2010-01-09', DATE '2010-01-04', DATE '2010-01-10', DATE '2010-01-05', DATE '2010-01-11', DATE '2010-01-06', DATE '2010-01-12', DATE '2010-01-07', DATE '2010-01-13', DATE '2010-01-08', DATE '2010-01-14', DATE '2010-01-02', DATE '2010-01-08', 1028, 3084, 13409, 13410, 13410, 13410, 13410, 13410, 13409, 2455205, 55204, N'2010-01-08', 201001, 1, 5, N'2010-W01', N'2010-W01-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93875, DATE '2010-01-09', DATE '2010-01-10', 2010, 20101, 201001, 2010009, 1, 1, 9, 9, 7, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-03', DATE '2010-01-09', DATE '2010-01-04', DATE '2010-01-10', DATE '2010-01-05', DATE '2010-01-11', DATE '2010-01-06', DATE '2010-01-12', DATE '2010-01-07', DATE '2010-01-13', DATE '2010-01-08', DATE '2010-01-14', DATE '2010-01-09', DATE '2010-01-15', 1028, 3084, 13409, 13410, 13410, 13410, 13410, 13410, 13410, 2455206, 55205, N'2010-01-09', 201001, 1, 6, N'2010-W01', N'2010-W01-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93876, DATE '2010-01-10', DATE '2010-01-11', 2010, 20101, 201001, 2010010, 1, 1, 10, 10, 1, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-10', DATE '2010-01-16', DATE '2010-01-04', DATE '2010-01-10', DATE '2010-01-05', DATE '2010-01-11', DATE '2010-01-06', DATE '2010-01-12', DATE '2010-01-07', DATE '2010-01-13', DATE '2010-01-08', DATE '2010-01-14', DATE '2010-01-09', DATE '2010-01-15', 1028, 3084, 13410, 13410, 13410, 13410, 13410, 13410, 13410, 2455207, 55206, N'2010-01-10', 201001, 1, 7, N'2010-W01', N'2010-W01-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93877, DATE '2010-01-11', DATE '2010-01-12', 2010, 20101, 201001, 2010011, 1, 1, 11, 11, 2, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-10', DATE '2010-01-16', DATE '2010-01-11', DATE '2010-01-17', DATE '2010-01-05', DATE '2010-01-11', DATE '2010-01-06', DATE '2010-01-12', DATE '2010-01-07', DATE '2010-01-13', DATE '2010-01-08', DATE '2010-01-14', DATE '2010-01-09', DATE '2010-01-15', 1028, 3084, 13410, 13411, 13410, 13410, 13410, 13410, 13410, 2455208, 55207, N'2010-01-11', 201002, 2, 1, N'2010-W02', N'2010-W02-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93878, DATE '2010-01-12', DATE '2010-01-13', 2010, 20101, 201001, 2010012, 1, 1, 12, 12, 3, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-10', DATE '2010-01-16', DATE '2010-01-11', DATE '2010-01-17', DATE '2010-01-12', DATE '2010-01-18', DATE '2010-01-06', DATE '2010-01-12', DATE '2010-01-07', DATE '2010-01-13', DATE '2010-01-08', DATE '2010-01-14', DATE '2010-01-09', DATE '2010-01-15', 1028, 3084, 13410, 13411, 13411, 13410, 13410, 13410, 13410, 2455209, 55208, N'2010-01-12', 201002, 2, 2, N'2010-W02', N'2010-W02-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93879, DATE '2010-01-13', DATE '2010-01-14', 2010, 20101, 201001, 2010013, 1, 1, 13, 13, 4, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-10', DATE '2010-01-16', DATE '2010-01-11', DATE '2010-01-17', DATE '2010-01-12', DATE '2010-01-18', DATE '2010-01-13', DATE '2010-01-19', DATE '2010-01-07', DATE '2010-01-13', DATE '2010-01-08', DATE '2010-01-14', DATE '2010-01-09', DATE '2010-01-15', 1028, 3084, 13410, 13411, 13411, 13411, 13410, 13410, 13410, 2455210, 55209, N'2010-01-13', 201002, 2, 3, N'2010-W02', N'2010-W02-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93880, DATE '2010-01-14', DATE '2010-01-15', 2010, 20101, 201001, 2010014, 1, 1, 14, 14, 5, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-10', DATE '2010-01-16', DATE '2010-01-11', DATE '2010-01-17', DATE '2010-01-12', DATE '2010-01-18', DATE '2010-01-13', DATE '2010-01-19', DATE '2010-01-14', DATE '2010-01-20', DATE '2010-01-08', DATE '2010-01-14', DATE '2010-01-09', DATE '2010-01-15', 1028, 3084, 13410, 13411, 13411, 13411, 13411, 13410, 13410, 2455211, 55210, N'2010-01-14', 201002, 2, 4, N'2010-W02', N'2010-W02-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93881, DATE '2010-01-15', DATE '2010-01-16', 2010, 20101, 201001, 2010015, 1, 1, 15, 15, 6, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-10', DATE '2010-01-16', DATE '2010-01-11', DATE '2010-01-17', DATE '2010-01-12', DATE '2010-01-18', DATE '2010-01-13', DATE '2010-01-19', DATE '2010-01-14', DATE '2010-01-20', DATE '2010-01-15', DATE '2010-01-21', DATE '2010-01-09', DATE '2010-01-15', 1028, 3084, 13410, 13411, 13411, 13411, 13411, 13411, 13410, 2455212, 55211, N'2010-01-15', 201002, 2, 5, N'2010-W02', N'2010-W02-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93882, DATE '2010-01-16', DATE '2010-01-17', 2010, 20101, 201001, 2010016, 1, 1, 16, 16, 7, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-10', DATE '2010-01-16', DATE '2010-01-11', DATE '2010-01-17', DATE '2010-01-12', DATE '2010-01-18', DATE '2010-01-13', DATE '2010-01-19', DATE '2010-01-14', DATE '2010-01-20', DATE '2010-01-15', DATE '2010-01-21', DATE '2010-01-16', DATE '2010-01-22', 1028, 3084, 13410, 13411, 13411, 13411, 13411, 13411, 13411, 2455213, 55212, N'2010-01-16', 201002, 2, 6, N'2010-W02', N'2010-W02-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93883, DATE '2010-01-17', DATE '2010-01-18', 2010, 20101, 201001, 2010017, 1, 1, 17, 17, 1, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-17', DATE '2010-01-23', DATE '2010-01-11', DATE '2010-01-17', DATE '2010-01-12', DATE '2010-01-18', DATE '2010-01-13', DATE '2010-01-19', DATE '2010-01-14', DATE '2010-01-20', DATE '2010-01-15', DATE '2010-01-21', DATE '2010-01-16', DATE '2010-01-22', 1028, 3084, 13411, 13411, 13411, 13411, 13411, 13411, 13411, 2455214, 55213, N'2010-01-17', 201002, 2, 7, N'2010-W02', N'2010-W02-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93884, DATE '2010-01-18', DATE '2010-01-19', 2010, 20101, 201001, 2010018, 1, 1, 18, 18, 2, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-17', DATE '2010-01-23', DATE '2010-01-18', DATE '2010-01-24', DATE '2010-01-12', DATE '2010-01-18', DATE '2010-01-13', DATE '2010-01-19', DATE '2010-01-14', DATE '2010-01-20', DATE '2010-01-15', DATE '2010-01-21', DATE '2010-01-16', DATE '2010-01-22', 1028, 3084, 13411, 13412, 13411, 13411, 13411, 13411, 13411, 2455215, 55214, N'2010-01-18', 201003, 3, 1, N'2010-W03', N'2010-W03-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93885, DATE '2010-01-19', DATE '2010-01-20', 2010, 20101, 201001, 2010019, 1, 1, 19, 19, 3, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-17', DATE '2010-01-23', DATE '2010-01-18', DATE '2010-01-24', DATE '2010-01-19', DATE '2010-01-25', DATE '2010-01-13', DATE '2010-01-19', DATE '2010-01-14', DATE '2010-01-20', DATE '2010-01-15', DATE '2010-01-21', DATE '2010-01-16', DATE '2010-01-22', 1028, 3084, 13411, 13412, 13412, 13411, 13411, 13411, 13411, 2455216, 55215, N'2010-01-19', 201003, 3, 2, N'2010-W03', N'2010-W03-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93886, DATE '2010-01-20', DATE '2010-01-21', 2010, 20101, 201001, 2010020, 1, 1, 20, 20, 4, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-17', DATE '2010-01-23', DATE '2010-01-18', DATE '2010-01-24', DATE '2010-01-19', DATE '2010-01-25', DATE '2010-01-20', DATE '2010-01-26', DATE '2010-01-14', DATE '2010-01-20', DATE '2010-01-15', DATE '2010-01-21', DATE '2010-01-16', DATE '2010-01-22', 1028, 3084, 13411, 13412, 13412, 13412, 13411, 13411, 13411, 2455217, 55216, N'2010-01-20', 201003, 3, 3, N'2010-W03', N'2010-W03-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93887, DATE '2010-01-21', DATE '2010-01-22', 2010, 20101, 201001, 2010021, 1, 1, 21, 21, 5, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-17', DATE '2010-01-23', DATE '2010-01-18', DATE '2010-01-24', DATE '2010-01-19', DATE '2010-01-25', DATE '2010-01-20', DATE '2010-01-26', DATE '2010-01-21', DATE '2010-01-27', DATE '2010-01-15', DATE '2010-01-21', DATE '2010-01-16', DATE '2010-01-22', 1028, 3084, 13411, 13412, 13412, 13412, 13412, 13411, 13411, 2455218, 55217, N'2010-01-21', 201003, 3, 4, N'2010-W03', N'2010-W03-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93888, DATE '2010-01-22', DATE '2010-01-23', 2010, 20101, 201001, 2010022, 1, 1, 22, 22, 6, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-17', DATE '2010-01-23', DATE '2010-01-18', DATE '2010-01-24', DATE '2010-01-19', DATE '2010-01-25', DATE '2010-01-20', DATE '2010-01-26', DATE '2010-01-21', DATE '2010-01-27', DATE '2010-01-22', DATE '2010-01-28', DATE '2010-01-16', DATE '2010-01-22', 1028, 3084, 13411, 13412, 13412, 13412, 13412, 13412, 13411, 2455219, 55218, N'2010-01-22', 201003, 3, 5, N'2010-W03', N'2010-W03-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93889, DATE '2010-01-23', DATE '2010-01-24', 2010, 20101, 201001, 2010023, 1, 1, 23, 23, 7, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-17', DATE '2010-01-23', DATE '2010-01-18', DATE '2010-01-24', DATE '2010-01-19', DATE '2010-01-25', DATE '2010-01-20', DATE '2010-01-26', DATE '2010-01-21', DATE '2010-01-27', DATE '2010-01-22', DATE '2010-01-28', DATE '2010-01-23', DATE '2010-01-29', 1028, 3084, 13411, 13412, 13412, 13412, 13412, 13412, 13412, 2455220, 55219, N'2010-01-23', 201003, 3, 6, N'2010-W03', N'2010-W03-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93890, DATE '2010-01-24', DATE '2010-01-25', 2010, 20101, 201001, 2010024, 1, 1, 24, 24, 1, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-24', DATE '2010-01-30', DATE '2010-01-18', DATE '2010-01-24', DATE '2010-01-19', DATE '2010-01-25', DATE '2010-01-20', DATE '2010-01-26', DATE '2010-01-21', DATE '2010-01-27', DATE '2010-01-22', DATE '2010-01-28', DATE '2010-01-23', DATE '2010-01-29', 1028, 3084, 13412, 13412, 13412, 13412, 13412, 13412, 13412, 2455221, 55220, N'2010-01-24', 201003, 3, 7, N'2010-W03', N'2010-W03-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93891, DATE '2010-01-25', DATE '2010-01-26', 2010, 20101, 201001, 2010025, 1, 1, 25, 25, 2, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-24', DATE '2010-01-30', DATE '2010-01-25', DATE '2010-01-31', DATE '2010-01-19', DATE '2010-01-25', DATE '2010-01-20', DATE '2010-01-26', DATE '2010-01-21', DATE '2010-01-27', DATE '2010-01-22', DATE '2010-01-28', DATE '2010-01-23', DATE '2010-01-29', 1028, 3084, 13412, 13413, 13412, 13412, 13412, 13412, 13412, 2455222, 55221, N'2010-01-25', 201004, 4, 1, N'2010-W04', N'2010-W04-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93892, DATE '2010-01-26', DATE '2010-01-27', 2010, 20101, 201001, 2010026, 1, 1, 26, 26, 3, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-24', DATE '2010-01-30', DATE '2010-01-25', DATE '2010-01-31', DATE '2010-01-26', DATE '2010-02-01', DATE '2010-01-20', DATE '2010-01-26', DATE '2010-01-21', DATE '2010-01-27', DATE '2010-01-22', DATE '2010-01-28', DATE '2010-01-23', DATE '2010-01-29', 1028, 3084, 13412, 13413, 13413, 13412, 13412, 13412, 13412, 2455223, 55222, N'2010-01-26', 201004, 4, 2, N'2010-W04', N'2010-W04-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93893, DATE '2010-01-27', DATE '2010-01-28', 2010, 20101, 201001, 2010027, 1, 1, 27, 27, 4, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-24', DATE '2010-01-30', DATE '2010-01-25', DATE '2010-01-31', DATE '2010-01-26', DATE '2010-02-01', DATE '2010-01-27', DATE '2010-02-02', DATE '2010-01-21', DATE '2010-01-27', DATE '2010-01-22', DATE '2010-01-28', DATE '2010-01-23', DATE '2010-01-29', 1028, 3084, 13412, 13413, 13413, 13413, 13412, 13412, 13412, 2455224, 55223, N'2010-01-27', 201004, 4, 3, N'2010-W04', N'2010-W04-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93894, DATE '2010-01-28', DATE '2010-01-29', 2010, 20101, 201001, 2010028, 1, 1, 28, 28, 5, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-24', DATE '2010-01-30', DATE '2010-01-25', DATE '2010-01-31', DATE '2010-01-26', DATE '2010-02-01', DATE '2010-01-27', DATE '2010-02-02', DATE '2010-01-28', DATE '2010-02-03', DATE '2010-01-22', DATE '2010-01-28', DATE '2010-01-23', DATE '2010-01-29', 1028, 3084, 13412, 13413, 13413, 13413, 13413, 13412, 13412, 2455225, 55224, N'2010-01-28', 201004, 4, 4, N'2010-W04', N'2010-W04-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93895, DATE '2010-01-29', DATE '2010-01-30', 2010, 20101, 201001, 2010029, 1, 1, 29, 29, 6, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-24', DATE '2010-01-30', DATE '2010-01-25', DATE '2010-01-31', DATE '2010-01-26', DATE '2010-02-01', DATE '2010-01-27', DATE '2010-02-02', DATE '2010-01-28', DATE '2010-02-03', DATE '2010-01-29', DATE '2010-02-04', DATE '2010-01-23', DATE '2010-01-29', 1028, 3084, 13412, 13413, 13413, 13413, 13413, 13413, 13412, 2455226, 55225, N'2010-01-29', 201004, 4, 5, N'2010-W04', N'2010-W04-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93896, DATE '2010-01-30', DATE '2010-01-31', 2010, 20101, 201001, 2010030, 1, 1, 30, 30, 7, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-24', DATE '2010-01-30', DATE '2010-01-25', DATE '2010-01-31', DATE '2010-01-26', DATE '2010-02-01', DATE '2010-01-27', DATE '2010-02-02', DATE '2010-01-28', DATE '2010-02-03', DATE '2010-01-29', DATE '2010-02-04', DATE '2010-01-30', DATE '2010-02-05', 1028, 3084, 13412, 13413, 13413, 13413, 13413, 13413, 13413, 2455227, 55226, N'2010-01-30', 201004, 4, 6, N'2010-W04', N'2010-W04-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93897, DATE '2010-01-31', DATE '2010-02-01', 2010, 20101, 201001, 2010031, 1, 1, 31, 31, 1, N'2010', N'2010 Q1', N'2010 Jan', N'Jan', N'January', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-01-01', DATE '2010-01-31', DATE '2010-01-31', DATE '2010-02-06', DATE '2010-01-25', DATE '2010-01-31', DATE '2010-01-26', DATE '2010-02-01', DATE '2010-01-27', DATE '2010-02-02', DATE '2010-01-28', DATE '2010-02-03', DATE '2010-01-29', DATE '2010-02-04', DATE '2010-01-30', DATE '2010-02-05', 1028, 3084, 13413, 13413, 13413, 13413, 13413, 13413, 13413, 2455228, 55227, N'2010-01-31', 201004, 4, 7, N'2010-W04', N'2010-W04-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93898, DATE '2010-02-01', DATE '2010-02-02', 2010, 20101, 201002, 2010032, 1, 2, 32, 1, 2, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-01-31', DATE '2010-02-06', DATE '2010-02-01', DATE '2010-02-07', DATE '2010-01-26', DATE '2010-02-01', DATE '2010-01-27', DATE '2010-02-02', DATE '2010-01-28', DATE '2010-02-03', DATE '2010-01-29', DATE '2010-02-04', DATE '2010-01-30', DATE '2010-02-05', 1028, 3085, 13413, 13414, 13413, 13413, 13413, 13413, 13413, 2455229, 55228, N'2010-02-01', 201005, 5, 1, N'2010-W05', N'2010-W05-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93899, DATE '2010-02-02', DATE '2010-02-03', 2010, 20101, 201002, 2010033, 1, 2, 33, 2, 3, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-01-31', DATE '2010-02-06', DATE '2010-02-01', DATE '2010-02-07', DATE '2010-02-02', DATE '2010-02-08', DATE '2010-01-27', DATE '2010-02-02', DATE '2010-01-28', DATE '2010-02-03', DATE '2010-01-29', DATE '2010-02-04', DATE '2010-01-30', DATE '2010-02-05', 1028, 3085, 13413, 13414, 13414, 13413, 13413, 13413, 13413, 2455230, 55229, N'2010-02-02', 201005, 5, 2, N'2010-W05', N'2010-W05-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93900, DATE '2010-02-03', DATE '2010-02-04', 2010, 20101, 201002, 2010034, 1, 2, 34, 3, 4, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-01-31', DATE '2010-02-06', DATE '2010-02-01', DATE '2010-02-07', DATE '2010-02-02', DATE '2010-02-08', DATE '2010-02-03', DATE '2010-02-09', DATE '2010-01-28', DATE '2010-02-03', DATE '2010-01-29', DATE '2010-02-04', DATE '2010-01-30', DATE '2010-02-05', 1028, 3085, 13413, 13414, 13414, 13414, 13413, 13413, 13413, 2455231, 55230, N'2010-02-03', 201005, 5, 3, N'2010-W05', N'2010-W05-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93901, DATE '2010-02-04', DATE '2010-02-05', 2010, 20101, 201002, 2010035, 1, 2, 35, 4, 5, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-01-31', DATE '2010-02-06', DATE '2010-02-01', DATE '2010-02-07', DATE '2010-02-02', DATE '2010-02-08', DATE '2010-02-03', DATE '2010-02-09', DATE '2010-02-04', DATE '2010-02-10', DATE '2010-01-29', DATE '2010-02-04', DATE '2010-01-30', DATE '2010-02-05', 1028, 3085, 13413, 13414, 13414, 13414, 13414, 13413, 13413, 2455232, 55231, N'2010-02-04', 201005, 5, 4, N'2010-W05', N'2010-W05-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93902, DATE '2010-02-05', DATE '2010-02-06', 2010, 20101, 201002, 2010036, 1, 2, 36, 5, 6, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-01-31', DATE '2010-02-06', DATE '2010-02-01', DATE '2010-02-07', DATE '2010-02-02', DATE '2010-02-08', DATE '2010-02-03', DATE '2010-02-09', DATE '2010-02-04', DATE '2010-02-10', DATE '2010-02-05', DATE '2010-02-11', DATE '2010-01-30', DATE '2010-02-05', 1028, 3085, 13413, 13414, 13414, 13414, 13414, 13414, 13413, 2455233, 55232, N'2010-02-05', 201005, 5, 5, N'2010-W05', N'2010-W05-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93903, DATE '2010-02-06', DATE '2010-02-07', 2010, 20101, 201002, 2010037, 1, 2, 37, 6, 7, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-01-31', DATE '2010-02-06', DATE '2010-02-01', DATE '2010-02-07', DATE '2010-02-02', DATE '2010-02-08', DATE '2010-02-03', DATE '2010-02-09', DATE '2010-02-04', DATE '2010-02-10', DATE '2010-02-05', DATE '2010-02-11', DATE '2010-02-06', DATE '2010-02-12', 1028, 3085, 13413, 13414, 13414, 13414, 13414, 13414, 13414, 2455234, 55233, N'2010-02-06', 201005, 5, 6, N'2010-W05', N'2010-W05-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93904, DATE '2010-02-07', DATE '2010-02-08', 2010, 20101, 201002, 2010038, 1, 2, 38, 7, 1, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-07', DATE '2010-02-13', DATE '2010-02-01', DATE '2010-02-07', DATE '2010-02-02', DATE '2010-02-08', DATE '2010-02-03', DATE '2010-02-09', DATE '2010-02-04', DATE '2010-02-10', DATE '2010-02-05', DATE '2010-02-11', DATE '2010-02-06', DATE '2010-02-12', 1028, 3085, 13414, 13414, 13414, 13414, 13414, 13414, 13414, 2455235, 55234, N'2010-02-07', 201005, 5, 7, N'2010-W05', N'2010-W05-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93905, DATE '2010-02-08', DATE '2010-02-09', 2010, 20101, 201002, 2010039, 1, 2, 39, 8, 2, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-07', DATE '2010-02-13', DATE '2010-02-08', DATE '2010-02-14', DATE '2010-02-02', DATE '2010-02-08', DATE '2010-02-03', DATE '2010-02-09', DATE '2010-02-04', DATE '2010-02-10', DATE '2010-02-05', DATE '2010-02-11', DATE '2010-02-06', DATE '2010-02-12', 1028, 3085, 13414, 13415, 13414, 13414, 13414, 13414, 13414, 2455236, 55235, N'2010-02-08', 201006, 6, 1, N'2010-W06', N'2010-W06-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93906, DATE '2010-02-09', DATE '2010-02-10', 2010, 20101, 201002, 2010040, 1, 2, 40, 9, 3, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-07', DATE '2010-02-13', DATE '2010-02-08', DATE '2010-02-14', DATE '2010-02-09', DATE '2010-02-15', DATE '2010-02-03', DATE '2010-02-09', DATE '2010-02-04', DATE '2010-02-10', DATE '2010-02-05', DATE '2010-02-11', DATE '2010-02-06', DATE '2010-02-12', 1028, 3085, 13414, 13415, 13415, 13414, 13414, 13414, 13414, 2455237, 55236, N'2010-02-09', 201006, 6, 2, N'2010-W06', N'2010-W06-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93907, DATE '2010-02-10', DATE '2010-02-11', 2010, 20101, 201002, 2010041, 1, 2, 41, 10, 4, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-07', DATE '2010-02-13', DATE '2010-02-08', DATE '2010-02-14', DATE '2010-02-09', DATE '2010-02-15', DATE '2010-02-10', DATE '2010-02-16', DATE '2010-02-04', DATE '2010-02-10', DATE '2010-02-05', DATE '2010-02-11', DATE '2010-02-06', DATE '2010-02-12', 1028, 3085, 13414, 13415, 13415, 13415, 13414, 13414, 13414, 2455238, 55237, N'2010-02-10', 201006, 6, 3, N'2010-W06', N'2010-W06-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93908, DATE '2010-02-11', DATE '2010-02-12', 2010, 20101, 201002, 2010042, 1, 2, 42, 11, 5, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-07', DATE '2010-02-13', DATE '2010-02-08', DATE '2010-02-14', DATE '2010-02-09', DATE '2010-02-15', DATE '2010-02-10', DATE '2010-02-16', DATE '2010-02-11', DATE '2010-02-17', DATE '2010-02-05', DATE '2010-02-11', DATE '2010-02-06', DATE '2010-02-12', 1028, 3085, 13414, 13415, 13415, 13415, 13415, 13414, 13414, 2455239, 55238, N'2010-02-11', 201006, 6, 4, N'2010-W06', N'2010-W06-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93909, DATE '2010-02-12', DATE '2010-02-13', 2010, 20101, 201002, 2010043, 1, 2, 43, 12, 6, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-07', DATE '2010-02-13', DATE '2010-02-08', DATE '2010-02-14', DATE '2010-02-09', DATE '2010-02-15', DATE '2010-02-10', DATE '2010-02-16', DATE '2010-02-11', DATE '2010-02-17', DATE '2010-02-12', DATE '2010-02-18', DATE '2010-02-06', DATE '2010-02-12', 1028, 3085, 13414, 13415, 13415, 13415, 13415, 13415, 13414, 2455240, 55239, N'2010-02-12', 201006, 6, 5, N'2010-W06', N'2010-W06-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93910, DATE '2010-02-13', DATE '2010-02-14', 2010, 20101, 201002, 2010044, 1, 2, 44, 13, 7, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-07', DATE '2010-02-13', DATE '2010-02-08', DATE '2010-02-14', DATE '2010-02-09', DATE '2010-02-15', DATE '2010-02-10', DATE '2010-02-16', DATE '2010-02-11', DATE '2010-02-17', DATE '2010-02-12', DATE '2010-02-18', DATE '2010-02-13', DATE '2010-02-19', 1028, 3085, 13414, 13415, 13415, 13415, 13415, 13415, 13415, 2455241, 55240, N'2010-02-13', 201006, 6, 6, N'2010-W06', N'2010-W06-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93911, DATE '2010-02-14', DATE '2010-02-15', 2010, 20101, 201002, 2010045, 1, 2, 45, 14, 1, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-14', DATE '2010-02-20', DATE '2010-02-08', DATE '2010-02-14', DATE '2010-02-09', DATE '2010-02-15', DATE '2010-02-10', DATE '2010-02-16', DATE '2010-02-11', DATE '2010-02-17', DATE '2010-02-12', DATE '2010-02-18', DATE '2010-02-13', DATE '2010-02-19', 1028, 3085, 13415, 13415, 13415, 13415, 13415, 13415, 13415, 2455242, 55241, N'2010-02-14', 201006, 6, 7, N'2010-W06', N'2010-W06-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93912, DATE '2010-02-15', DATE '2010-02-16', 2010, 20101, 201002, 2010046, 1, 2, 46, 15, 2, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-14', DATE '2010-02-20', DATE '2010-02-15', DATE '2010-02-21', DATE '2010-02-09', DATE '2010-02-15', DATE '2010-02-10', DATE '2010-02-16', DATE '2010-02-11', DATE '2010-02-17', DATE '2010-02-12', DATE '2010-02-18', DATE '2010-02-13', DATE '2010-02-19', 1028, 3085, 13415, 13416, 13415, 13415, 13415, 13415, 13415, 2455243, 55242, N'2010-02-15', 201007, 7, 1, N'2010-W07', N'2010-W07-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93913, DATE '2010-02-16', DATE '2010-02-17', 2010, 20101, 201002, 2010047, 1, 2, 47, 16, 3, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-14', DATE '2010-02-20', DATE '2010-02-15', DATE '2010-02-21', DATE '2010-02-16', DATE '2010-02-22', DATE '2010-02-10', DATE '2010-02-16', DATE '2010-02-11', DATE '2010-02-17', DATE '2010-02-12', DATE '2010-02-18', DATE '2010-02-13', DATE '2010-02-19', 1028, 3085, 13415, 13416, 13416, 13415, 13415, 13415, 13415, 2455244, 55243, N'2010-02-16', 201007, 7, 2, N'2010-W07', N'2010-W07-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93914, DATE '2010-02-17', DATE '2010-02-18', 2010, 20101, 201002, 2010048, 1, 2, 48, 17, 4, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-14', DATE '2010-02-20', DATE '2010-02-15', DATE '2010-02-21', DATE '2010-02-16', DATE '2010-02-22', DATE '2010-02-17', DATE '2010-02-23', DATE '2010-02-11', DATE '2010-02-17', DATE '2010-02-12', DATE '2010-02-18', DATE '2010-02-13', DATE '2010-02-19', 1028, 3085, 13415, 13416, 13416, 13416, 13415, 13415, 13415, 2455245, 55244, N'2010-02-17', 201007, 7, 3, N'2010-W07', N'2010-W07-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93915, DATE '2010-02-18', DATE '2010-02-19', 2010, 20101, 201002, 2010049, 1, 2, 49, 18, 5, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-14', DATE '2010-02-20', DATE '2010-02-15', DATE '2010-02-21', DATE '2010-02-16', DATE '2010-02-22', DATE '2010-02-17', DATE '2010-02-23', DATE '2010-02-18', DATE '2010-02-24', DATE '2010-02-12', DATE '2010-02-18', DATE '2010-02-13', DATE '2010-02-19', 1028, 3085, 13415, 13416, 13416, 13416, 13416, 13415, 13415, 2455246, 55245, N'2010-02-18', 201007, 7, 4, N'2010-W07', N'2010-W07-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93916, DATE '2010-02-19', DATE '2010-02-20', 2010, 20101, 201002, 2010050, 1, 2, 50, 19, 6, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-14', DATE '2010-02-20', DATE '2010-02-15', DATE '2010-02-21', DATE '2010-02-16', DATE '2010-02-22', DATE '2010-02-17', DATE '2010-02-23', DATE '2010-02-18', DATE '2010-02-24', DATE '2010-02-19', DATE '2010-02-25', DATE '2010-02-13', DATE '2010-02-19', 1028, 3085, 13415, 13416, 13416, 13416, 13416, 13416, 13415, 2455247, 55246, N'2010-02-19', 201007, 7, 5, N'2010-W07', N'2010-W07-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93917, DATE '2010-02-20', DATE '2010-02-21', 2010, 20101, 201002, 2010051, 1, 2, 51, 20, 7, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-14', DATE '2010-02-20', DATE '2010-02-15', DATE '2010-02-21', DATE '2010-02-16', DATE '2010-02-22', DATE '2010-02-17', DATE '2010-02-23', DATE '2010-02-18', DATE '2010-02-24', DATE '2010-02-19', DATE '2010-02-25', DATE '2010-02-20', DATE '2010-02-26', 1028, 3085, 13415, 13416, 13416, 13416, 13416, 13416, 13416, 2455248, 55247, N'2010-02-20', 201007, 7, 6, N'2010-W07', N'2010-W07-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93918, DATE '2010-02-21', DATE '2010-02-22', 2010, 20101, 201002, 2010052, 1, 2, 52, 21, 1, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-21', DATE '2010-02-27', DATE '2010-02-15', DATE '2010-02-21', DATE '2010-02-16', DATE '2010-02-22', DATE '2010-02-17', DATE '2010-02-23', DATE '2010-02-18', DATE '2010-02-24', DATE '2010-02-19', DATE '2010-02-25', DATE '2010-02-20', DATE '2010-02-26', 1028, 3085, 13416, 13416, 13416, 13416, 13416, 13416, 13416, 2455249, 55248, N'2010-02-21', 201007, 7, 7, N'2010-W07', N'2010-W07-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93919, DATE '2010-02-22', DATE '2010-02-23', 2010, 20101, 201002, 2010053, 1, 2, 53, 22, 2, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-21', DATE '2010-02-27', DATE '2010-02-22', DATE '2010-02-28', DATE '2010-02-16', DATE '2010-02-22', DATE '2010-02-17', DATE '2010-02-23', DATE '2010-02-18', DATE '2010-02-24', DATE '2010-02-19', DATE '2010-02-25', DATE '2010-02-20', DATE '2010-02-26', 1028, 3085, 13416, 13417, 13416, 13416, 13416, 13416, 13416, 2455250, 55249, N'2010-02-22', 201008, 8, 1, N'2010-W08', N'2010-W08-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93920, DATE '2010-02-23', DATE '2010-02-24', 2010, 20101, 201002, 2010054, 1, 2, 54, 23, 3, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-21', DATE '2010-02-27', DATE '2010-02-22', DATE '2010-02-28', DATE '2010-02-23', DATE '2010-03-01', DATE '2010-02-17', DATE '2010-02-23', DATE '2010-02-18', DATE '2010-02-24', DATE '2010-02-19', DATE '2010-02-25', DATE '2010-02-20', DATE '2010-02-26', 1028, 3085, 13416, 13417, 13417, 13416, 13416, 13416, 13416, 2455251, 55250, N'2010-02-23', 201008, 8, 2, N'2010-W08', N'2010-W08-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93921, DATE '2010-02-24', DATE '2010-02-25', 2010, 20101, 201002, 2010055, 1, 2, 55, 24, 4, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-21', DATE '2010-02-27', DATE '2010-02-22', DATE '2010-02-28', DATE '2010-02-23', DATE '2010-03-01', DATE '2010-02-24', DATE '2010-03-02', DATE '2010-02-18', DATE '2010-02-24', DATE '2010-02-19', DATE '2010-02-25', DATE '2010-02-20', DATE '2010-02-26', 1028, 3085, 13416, 13417, 13417, 13417, 13416, 13416, 13416, 2455252, 55251, N'2010-02-24', 201008, 8, 3, N'2010-W08', N'2010-W08-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93922, DATE '2010-02-25', DATE '2010-02-26', 2010, 20101, 201002, 2010056, 1, 2, 56, 25, 5, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-21', DATE '2010-02-27', DATE '2010-02-22', DATE '2010-02-28', DATE '2010-02-23', DATE '2010-03-01', DATE '2010-02-24', DATE '2010-03-02', DATE '2010-02-25', DATE '2010-03-03', DATE '2010-02-19', DATE '2010-02-25', DATE '2010-02-20', DATE '2010-02-26', 1028, 3085, 13416, 13417, 13417, 13417, 13417, 13416, 13416, 2455253, 55252, N'2010-02-25', 201008, 8, 4, N'2010-W08', N'2010-W08-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93923, DATE '2010-02-26', DATE '2010-02-27', 2010, 20101, 201002, 2010057, 1, 2, 57, 26, 6, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-21', DATE '2010-02-27', DATE '2010-02-22', DATE '2010-02-28', DATE '2010-02-23', DATE '2010-03-01', DATE '2010-02-24', DATE '2010-03-02', DATE '2010-02-25', DATE '2010-03-03', DATE '2010-02-26', DATE '2010-03-04', DATE '2010-02-20', DATE '2010-02-26', 1028, 3085, 13416, 13417, 13417, 13417, 13417, 13417, 13416, 2455254, 55253, N'2010-02-26', 201008, 8, 5, N'2010-W08', N'2010-W08-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93924, DATE '2010-02-27', DATE '2010-02-28', 2010, 20101, 201002, 2010058, 1, 2, 58, 27, 7, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-21', DATE '2010-02-27', DATE '2010-02-22', DATE '2010-02-28', DATE '2010-02-23', DATE '2010-03-01', DATE '2010-02-24', DATE '2010-03-02', DATE '2010-02-25', DATE '2010-03-03', DATE '2010-02-26', DATE '2010-03-04', DATE '2010-02-27', DATE '2010-03-05', 1028, 3085, 13416, 13417, 13417, 13417, 13417, 13417, 13417, 2455255, 55254, N'2010-02-27', 201008, 8, 6, N'2010-W08', N'2010-W08-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93925, DATE '2010-02-28', DATE '2010-03-01', 2010, 20101, 201002, 2010059, 1, 2, 59, 28, 1, N'2010', N'2010 Q1', N'2010 Feb', N'Feb', N'February', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-02-01', DATE '2010-02-28', DATE '2010-02-28', DATE '2010-03-06', DATE '2010-02-22', DATE '2010-02-28', DATE '2010-02-23', DATE '2010-03-01', DATE '2010-02-24', DATE '2010-03-02', DATE '2010-02-25', DATE '2010-03-03', DATE '2010-02-26', DATE '2010-03-04', DATE '2010-02-27', DATE '2010-03-05', 1028, 3085, 13417, 13417, 13417, 13417, 13417, 13417, 13417, 2455256, 55255, N'2010-02-28', 201008, 8, 7, N'2010-W08', N'2010-W08-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93926, DATE '2010-03-01', DATE '2010-03-02', 2010, 20101, 201003, 2010060, 1, 3, 60, 1, 2, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-02-28', DATE '2010-03-06', DATE '2010-03-01', DATE '2010-03-07', DATE '2010-02-23', DATE '2010-03-01', DATE '2010-02-24', DATE '2010-03-02', DATE '2010-02-25', DATE '2010-03-03', DATE '2010-02-26', DATE '2010-03-04', DATE '2010-02-27', DATE '2010-03-05', 1028, 3086, 13417, 13418, 13417, 13417, 13417, 13417, 13417, 2455257, 55256, N'2010-03-01', 201009, 9, 1, N'2010-W09', N'2010-W09-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93927, DATE '2010-03-02', DATE '2010-03-03', 2010, 20101, 201003, 2010061, 1, 3, 61, 2, 3, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-02-28', DATE '2010-03-06', DATE '2010-03-01', DATE '2010-03-07', DATE '2010-03-02', DATE '2010-03-08', DATE '2010-02-24', DATE '2010-03-02', DATE '2010-02-25', DATE '2010-03-03', DATE '2010-02-26', DATE '2010-03-04', DATE '2010-02-27', DATE '2010-03-05', 1028, 3086, 13417, 13418, 13418, 13417, 13417, 13417, 13417, 2455258, 55257, N'2010-03-02', 201009, 9, 2, N'2010-W09', N'2010-W09-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93928, DATE '2010-03-03', DATE '2010-03-04', 2010, 20101, 201003, 2010062, 1, 3, 62, 3, 4, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-02-28', DATE '2010-03-06', DATE '2010-03-01', DATE '2010-03-07', DATE '2010-03-02', DATE '2010-03-08', DATE '2010-03-03', DATE '2010-03-09', DATE '2010-02-25', DATE '2010-03-03', DATE '2010-02-26', DATE '2010-03-04', DATE '2010-02-27', DATE '2010-03-05', 1028, 3086, 13417, 13418, 13418, 13418, 13417, 13417, 13417, 2455259, 55258, N'2010-03-03', 201009, 9, 3, N'2010-W09', N'2010-W09-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93929, DATE '2010-03-04', DATE '2010-03-05', 2010, 20101, 201003, 2010063, 1, 3, 63, 4, 5, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-02-28', DATE '2010-03-06', DATE '2010-03-01', DATE '2010-03-07', DATE '2010-03-02', DATE '2010-03-08', DATE '2010-03-03', DATE '2010-03-09', DATE '2010-03-04', DATE '2010-03-10', DATE '2010-02-26', DATE '2010-03-04', DATE '2010-02-27', DATE '2010-03-05', 1028, 3086, 13417, 13418, 13418, 13418, 13418, 13417, 13417, 2455260, 55259, N'2010-03-04', 201009, 9, 4, N'2010-W09', N'2010-W09-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93930, DATE '2010-03-05', DATE '2010-03-06', 2010, 20101, 201003, 2010064, 1, 3, 64, 5, 6, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-02-28', DATE '2010-03-06', DATE '2010-03-01', DATE '2010-03-07', DATE '2010-03-02', DATE '2010-03-08', DATE '2010-03-03', DATE '2010-03-09', DATE '2010-03-04', DATE '2010-03-10', DATE '2010-03-05', DATE '2010-03-11', DATE '2010-02-27', DATE '2010-03-05', 1028, 3086, 13417, 13418, 13418, 13418, 13418, 13418, 13417, 2455261, 55260, N'2010-03-05', 201009, 9, 5, N'2010-W09', N'2010-W09-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93931, DATE '2010-03-06', DATE '2010-03-07', 2010, 20101, 201003, 2010065, 1, 3, 65, 6, 7, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-02-28', DATE '2010-03-06', DATE '2010-03-01', DATE '2010-03-07', DATE '2010-03-02', DATE '2010-03-08', DATE '2010-03-03', DATE '2010-03-09', DATE '2010-03-04', DATE '2010-03-10', DATE '2010-03-05', DATE '2010-03-11', DATE '2010-03-06', DATE '2010-03-12', 1028, 3086, 13417, 13418, 13418, 13418, 13418, 13418, 13418, 2455262, 55261, N'2010-03-06', 201009, 9, 6, N'2010-W09', N'2010-W09-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93932, DATE '2010-03-07', DATE '2010-03-08', 2010, 20101, 201003, 2010066, 1, 3, 66, 7, 1, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-07', DATE '2010-03-13', DATE '2010-03-01', DATE '2010-03-07', DATE '2010-03-02', DATE '2010-03-08', DATE '2010-03-03', DATE '2010-03-09', DATE '2010-03-04', DATE '2010-03-10', DATE '2010-03-05', DATE '2010-03-11', DATE '2010-03-06', DATE '2010-03-12', 1028, 3086, 13418, 13418, 13418, 13418, 13418, 13418, 13418, 2455263, 55262, N'2010-03-07', 201009, 9, 7, N'2010-W09', N'2010-W09-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93933, DATE '2010-03-08', DATE '2010-03-09', 2010, 20101, 201003, 2010067, 1, 3, 67, 8, 2, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-07', DATE '2010-03-13', DATE '2010-03-08', DATE '2010-03-14', DATE '2010-03-02', DATE '2010-03-08', DATE '2010-03-03', DATE '2010-03-09', DATE '2010-03-04', DATE '2010-03-10', DATE '2010-03-05', DATE '2010-03-11', DATE '2010-03-06', DATE '2010-03-12', 1028, 3086, 13418, 13419, 13418, 13418, 13418, 13418, 13418, 2455264, 55263, N'2010-03-08', 201010, 10, 1, N'2010-W10', N'2010-W10-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93934, DATE '2010-03-09', DATE '2010-03-10', 2010, 20101, 201003, 2010068, 1, 3, 68, 9, 3, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-07', DATE '2010-03-13', DATE '2010-03-08', DATE '2010-03-14', DATE '2010-03-09', DATE '2010-03-15', DATE '2010-03-03', DATE '2010-03-09', DATE '2010-03-04', DATE '2010-03-10', DATE '2010-03-05', DATE '2010-03-11', DATE '2010-03-06', DATE '2010-03-12', 1028, 3086, 13418, 13419, 13419, 13418, 13418, 13418, 13418, 2455265, 55264, N'2010-03-09', 201010, 10, 2, N'2010-W10', N'2010-W10-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93935, DATE '2010-03-10', DATE '2010-03-11', 2010, 20101, 201003, 2010069, 1, 3, 69, 10, 4, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-07', DATE '2010-03-13', DATE '2010-03-08', DATE '2010-03-14', DATE '2010-03-09', DATE '2010-03-15', DATE '2010-03-10', DATE '2010-03-16', DATE '2010-03-04', DATE '2010-03-10', DATE '2010-03-05', DATE '2010-03-11', DATE '2010-03-06', DATE '2010-03-12', 1028, 3086, 13418, 13419, 13419, 13419, 13418, 13418, 13418, 2455266, 55265, N'2010-03-10', 201010, 10, 3, N'2010-W10', N'2010-W10-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93936, DATE '2010-03-11', DATE '2010-03-12', 2010, 20101, 201003, 2010070, 1, 3, 70, 11, 5, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-07', DATE '2010-03-13', DATE '2010-03-08', DATE '2010-03-14', DATE '2010-03-09', DATE '2010-03-15', DATE '2010-03-10', DATE '2010-03-16', DATE '2010-03-11', DATE '2010-03-17', DATE '2010-03-05', DATE '2010-03-11', DATE '2010-03-06', DATE '2010-03-12', 1028, 3086, 13418, 13419, 13419, 13419, 13419, 13418, 13418, 2455267, 55266, N'2010-03-11', 201010, 10, 4, N'2010-W10', N'2010-W10-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93937, DATE '2010-03-12', DATE '2010-03-13', 2010, 20101, 201003, 2010071, 1, 3, 71, 12, 6, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-07', DATE '2010-03-13', DATE '2010-03-08', DATE '2010-03-14', DATE '2010-03-09', DATE '2010-03-15', DATE '2010-03-10', DATE '2010-03-16', DATE '2010-03-11', DATE '2010-03-17', DATE '2010-03-12', DATE '2010-03-18', DATE '2010-03-06', DATE '2010-03-12', 1028, 3086, 13418, 13419, 13419, 13419, 13419, 13419, 13418, 2455268, 55267, N'2010-03-12', 201010, 10, 5, N'2010-W10', N'2010-W10-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93938, DATE '2010-03-13', DATE '2010-03-14', 2010, 20101, 201003, 2010072, 1, 3, 72, 13, 7, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-07', DATE '2010-03-13', DATE '2010-03-08', DATE '2010-03-14', DATE '2010-03-09', DATE '2010-03-15', DATE '2010-03-10', DATE '2010-03-16', DATE '2010-03-11', DATE '2010-03-17', DATE '2010-03-12', DATE '2010-03-18', DATE '2010-03-13', DATE '2010-03-19', 1028, 3086, 13418, 13419, 13419, 13419, 13419, 13419, 13419, 2455269, 55268, N'2010-03-13', 201010, 10, 6, N'2010-W10', N'2010-W10-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93939, DATE '2010-03-14', DATE '2010-03-15', 2010, 20101, 201003, 2010073, 1, 3, 73, 14, 1, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-14', DATE '2010-03-20', DATE '2010-03-08', DATE '2010-03-14', DATE '2010-03-09', DATE '2010-03-15', DATE '2010-03-10', DATE '2010-03-16', DATE '2010-03-11', DATE '2010-03-17', DATE '2010-03-12', DATE '2010-03-18', DATE '2010-03-13', DATE '2010-03-19', 1028, 3086, 13419, 13419, 13419, 13419, 13419, 13419, 13419, 2455270, 55269, N'2010-03-14', 201010, 10, 7, N'2010-W10', N'2010-W10-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93940, DATE '2010-03-15', DATE '2010-03-16', 2010, 20101, 201003, 2010074, 1, 3, 74, 15, 2, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-14', DATE '2010-03-20', DATE '2010-03-15', DATE '2010-03-21', DATE '2010-03-09', DATE '2010-03-15', DATE '2010-03-10', DATE '2010-03-16', DATE '2010-03-11', DATE '2010-03-17', DATE '2010-03-12', DATE '2010-03-18', DATE '2010-03-13', DATE '2010-03-19', 1028, 3086, 13419, 13420, 13419, 13419, 13419, 13419, 13419, 2455271, 55270, N'2010-03-15', 201011, 11, 1, N'2010-W11', N'2010-W11-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93941, DATE '2010-03-16', DATE '2010-03-17', 2010, 20101, 201003, 2010075, 1, 3, 75, 16, 3, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-14', DATE '2010-03-20', DATE '2010-03-15', DATE '2010-03-21', DATE '2010-03-16', DATE '2010-03-22', DATE '2010-03-10', DATE '2010-03-16', DATE '2010-03-11', DATE '2010-03-17', DATE '2010-03-12', DATE '2010-03-18', DATE '2010-03-13', DATE '2010-03-19', 1028, 3086, 13419, 13420, 13420, 13419, 13419, 13419, 13419, 2455272, 55271, N'2010-03-16', 201011, 11, 2, N'2010-W11', N'2010-W11-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93942, DATE '2010-03-17', DATE '2010-03-18', 2010, 20101, 201003, 2010076, 1, 3, 76, 17, 4, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-14', DATE '2010-03-20', DATE '2010-03-15', DATE '2010-03-21', DATE '2010-03-16', DATE '2010-03-22', DATE '2010-03-17', DATE '2010-03-23', DATE '2010-03-11', DATE '2010-03-17', DATE '2010-03-12', DATE '2010-03-18', DATE '2010-03-13', DATE '2010-03-19', 1028, 3086, 13419, 13420, 13420, 13420, 13419, 13419, 13419, 2455273, 55272, N'2010-03-17', 201011, 11, 3, N'2010-W11', N'2010-W11-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93943, DATE '2010-03-18', DATE '2010-03-19', 2010, 20101, 201003, 2010077, 1, 3, 77, 18, 5, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-14', DATE '2010-03-20', DATE '2010-03-15', DATE '2010-03-21', DATE '2010-03-16', DATE '2010-03-22', DATE '2010-03-17', DATE '2010-03-23', DATE '2010-03-18', DATE '2010-03-24', DATE '2010-03-12', DATE '2010-03-18', DATE '2010-03-13', DATE '2010-03-19', 1028, 3086, 13419, 13420, 13420, 13420, 13420, 13419, 13419, 2455274, 55273, N'2010-03-18', 201011, 11, 4, N'2010-W11', N'2010-W11-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93944, DATE '2010-03-19', DATE '2010-03-20', 2010, 20101, 201003, 2010078, 1, 3, 78, 19, 6, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-14', DATE '2010-03-20', DATE '2010-03-15', DATE '2010-03-21', DATE '2010-03-16', DATE '2010-03-22', DATE '2010-03-17', DATE '2010-03-23', DATE '2010-03-18', DATE '2010-03-24', DATE '2010-03-19', DATE '2010-03-25', DATE '2010-03-13', DATE '2010-03-19', 1028, 3086, 13419, 13420, 13420, 13420, 13420, 13420, 13419, 2455275, 55274, N'2010-03-19', 201011, 11, 5, N'2010-W11', N'2010-W11-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93945, DATE '2010-03-20', DATE '2010-03-21', 2010, 20101, 201003, 2010079, 1, 3, 79, 20, 7, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-14', DATE '2010-03-20', DATE '2010-03-15', DATE '2010-03-21', DATE '2010-03-16', DATE '2010-03-22', DATE '2010-03-17', DATE '2010-03-23', DATE '2010-03-18', DATE '2010-03-24', DATE '2010-03-19', DATE '2010-03-25', DATE '2010-03-20', DATE '2010-03-26', 1028, 3086, 13419, 13420, 13420, 13420, 13420, 13420, 13420, 2455276, 55275, N'2010-03-20', 201011, 11, 6, N'2010-W11', N'2010-W11-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93946, DATE '2010-03-21', DATE '2010-03-22', 2010, 20101, 201003, 2010080, 1, 3, 80, 21, 1, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-21', DATE '2010-03-27', DATE '2010-03-15', DATE '2010-03-21', DATE '2010-03-16', DATE '2010-03-22', DATE '2010-03-17', DATE '2010-03-23', DATE '2010-03-18', DATE '2010-03-24', DATE '2010-03-19', DATE '2010-03-25', DATE '2010-03-20', DATE '2010-03-26', 1028, 3086, 13420, 13420, 13420, 13420, 13420, 13420, 13420, 2455277, 55276, N'2010-03-21', 201011, 11, 7, N'2010-W11', N'2010-W11-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93947, DATE '2010-03-22', DATE '2010-03-23', 2010, 20101, 201003, 2010081, 1, 3, 81, 22, 2, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-21', DATE '2010-03-27', DATE '2010-03-22', DATE '2010-03-28', DATE '2010-03-16', DATE '2010-03-22', DATE '2010-03-17', DATE '2010-03-23', DATE '2010-03-18', DATE '2010-03-24', DATE '2010-03-19', DATE '2010-03-25', DATE '2010-03-20', DATE '2010-03-26', 1028, 3086, 13420, 13421, 13420, 13420, 13420, 13420, 13420, 2455278, 55277, N'2010-03-22', 201012, 12, 1, N'2010-W12', N'2010-W12-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93948, DATE '2010-03-23', DATE '2010-03-24', 2010, 20101, 201003, 2010082, 1, 3, 82, 23, 3, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-21', DATE '2010-03-27', DATE '2010-03-22', DATE '2010-03-28', DATE '2010-03-23', DATE '2010-03-29', DATE '2010-03-17', DATE '2010-03-23', DATE '2010-03-18', DATE '2010-03-24', DATE '2010-03-19', DATE '2010-03-25', DATE '2010-03-20', DATE '2010-03-26', 1028, 3086, 13420, 13421, 13421, 13420, 13420, 13420, 13420, 2455279, 55278, N'2010-03-23', 201012, 12, 2, N'2010-W12', N'2010-W12-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93949, DATE '2010-03-24', DATE '2010-03-25', 2010, 20101, 201003, 2010083, 1, 3, 83, 24, 4, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-21', DATE '2010-03-27', DATE '2010-03-22', DATE '2010-03-28', DATE '2010-03-23', DATE '2010-03-29', DATE '2010-03-24', DATE '2010-03-30', DATE '2010-03-18', DATE '2010-03-24', DATE '2010-03-19', DATE '2010-03-25', DATE '2010-03-20', DATE '2010-03-26', 1028, 3086, 13420, 13421, 13421, 13421, 13420, 13420, 13420, 2455280, 55279, N'2010-03-24', 201012, 12, 3, N'2010-W12', N'2010-W12-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93950, DATE '2010-03-25', DATE '2010-03-26', 2010, 20101, 201003, 2010084, 1, 3, 84, 25, 5, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-21', DATE '2010-03-27', DATE '2010-03-22', DATE '2010-03-28', DATE '2010-03-23', DATE '2010-03-29', DATE '2010-03-24', DATE '2010-03-30', DATE '2010-03-25', DATE '2010-03-31', DATE '2010-03-19', DATE '2010-03-25', DATE '2010-03-20', DATE '2010-03-26', 1028, 3086, 13420, 13421, 13421, 13421, 13421, 13420, 13420, 2455281, 55280, N'2010-03-25', 201012, 12, 4, N'2010-W12', N'2010-W12-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93951, DATE '2010-03-26', DATE '2010-03-27', 2010, 20101, 201003, 2010085, 1, 3, 85, 26, 6, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-21', DATE '2010-03-27', DATE '2010-03-22', DATE '2010-03-28', DATE '2010-03-23', DATE '2010-03-29', DATE '2010-03-24', DATE '2010-03-30', DATE '2010-03-25', DATE '2010-03-31', DATE '2010-03-26', DATE '2010-04-01', DATE '2010-03-20', DATE '2010-03-26', 1028, 3086, 13420, 13421, 13421, 13421, 13421, 13421, 13420, 2455282, 55281, N'2010-03-26', 201012, 12, 5, N'2010-W12', N'2010-W12-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93952, DATE '2010-03-27', DATE '2010-03-28', 2010, 20101, 201003, 2010086, 1, 3, 86, 27, 7, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-21', DATE '2010-03-27', DATE '2010-03-22', DATE '2010-03-28', DATE '2010-03-23', DATE '2010-03-29', DATE '2010-03-24', DATE '2010-03-30', DATE '2010-03-25', DATE '2010-03-31', DATE '2010-03-26', DATE '2010-04-01', DATE '2010-03-27', DATE '2010-04-02', 1028, 3086, 13420, 13421, 13421, 13421, 13421, 13421, 13421, 2455283, 55282, N'2010-03-27', 201012, 12, 6, N'2010-W12', N'2010-W12-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93953, DATE '2010-03-28', DATE '2010-03-29', 2010, 20101, 201003, 2010087, 1, 3, 87, 28, 1, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-28', DATE '2010-04-03', DATE '2010-03-22', DATE '2010-03-28', DATE '2010-03-23', DATE '2010-03-29', DATE '2010-03-24', DATE '2010-03-30', DATE '2010-03-25', DATE '2010-03-31', DATE '2010-03-26', DATE '2010-04-01', DATE '2010-03-27', DATE '2010-04-02', 1028, 3086, 13421, 13421, 13421, 13421, 13421, 13421, 13421, 2455284, 55283, N'2010-03-28', 201012, 12, 7, N'2010-W12', N'2010-W12-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93954, DATE '2010-03-29', DATE '2010-03-30', 2010, 20101, 201003, 2010088, 1, 3, 88, 29, 2, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-28', DATE '2010-04-03', DATE '2010-03-29', DATE '2010-04-04', DATE '2010-03-23', DATE '2010-03-29', DATE '2010-03-24', DATE '2010-03-30', DATE '2010-03-25', DATE '2010-03-31', DATE '2010-03-26', DATE '2010-04-01', DATE '2010-03-27', DATE '2010-04-02', 1028, 3086, 13421, 13422, 13421, 13421, 13421, 13421, 13421, 2455285, 55284, N'2010-03-29', 201013, 13, 1, N'2010-W13', N'2010-W13-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93955, DATE '2010-03-30', DATE '2010-03-31', 2010, 20101, 201003, 2010089, 1, 3, 89, 30, 3, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-28', DATE '2010-04-03', DATE '2010-03-29', DATE '2010-04-04', DATE '2010-03-30', DATE '2010-04-05', DATE '2010-03-24', DATE '2010-03-30', DATE '2010-03-25', DATE '2010-03-31', DATE '2010-03-26', DATE '2010-04-01', DATE '2010-03-27', DATE '2010-04-02', 1028, 3086, 13421, 13422, 13422, 13421, 13421, 13421, 13421, 2455286, 55285, N'2010-03-30', 201013, 13, 2, N'2010-W13', N'2010-W13-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93956, DATE '2010-03-31', DATE '2010-04-01', 2010, 20101, 201003, 2010090, 1, 3, 90, 31, 4, N'2010', N'2010 Q1', N'2010 Mar', N'Mar', N'March', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-01-01', DATE '2010-03-31', DATE '2010-03-01', DATE '2010-03-31', DATE '2010-03-28', DATE '2010-04-03', DATE '2010-03-29', DATE '2010-04-04', DATE '2010-03-30', DATE '2010-04-05', DATE '2010-03-31', DATE '2010-04-06', DATE '2010-03-25', DATE '2010-03-31', DATE '2010-03-26', DATE '2010-04-01', DATE '2010-03-27', DATE '2010-04-02', 1028, 3086, 13421, 13422, 13422, 13422, 13421, 13421, 13421, 2455287, 55286, N'2010-03-31', 201013, 13, 3, N'2010-W13', N'2010-W13-3');

INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93957, DATE '2010-04-01', DATE '2010-04-02', 2010, 20102, 201004, 2010091, 2, 4, 91, 1, 5, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-03-28', DATE '2010-04-03', DATE '2010-03-29', DATE '2010-04-04', DATE '2010-03-30', DATE '2010-04-05', DATE '2010-03-31', DATE '2010-04-06', DATE '2010-04-01', DATE '2010-04-07', DATE '2010-03-26', DATE '2010-04-01', DATE '2010-03-27', DATE '2010-04-02', 1029, 3087, 13421, 13422, 13422, 13422, 13422, 13421, 13421, 2455288, 55287, N'2010-04-01', 201013, 13, 4, N'2010-W13', N'2010-W13-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93958, DATE '2010-04-02', DATE '2010-04-03', 2010, 20102, 201004, 2010092, 2, 4, 92, 2, 6, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-03-28', DATE '2010-04-03', DATE '2010-03-29', DATE '2010-04-04', DATE '2010-03-30', DATE '2010-04-05', DATE '2010-03-31', DATE '2010-04-06', DATE '2010-04-01', DATE '2010-04-07', DATE '2010-04-02', DATE '2010-04-08', DATE '2010-03-27', DATE '2010-04-02', 1029, 3087, 13421, 13422, 13422, 13422, 13422, 13422, 13421, 2455289, 55288, N'2010-04-02', 201013, 13, 5, N'2010-W13', N'2010-W13-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93959, DATE '2010-04-03', DATE '2010-04-04', 2010, 20102, 201004, 2010093, 2, 4, 93, 3, 7, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-03-28', DATE '2010-04-03', DATE '2010-03-29', DATE '2010-04-04', DATE '2010-03-30', DATE '2010-04-05', DATE '2010-03-31', DATE '2010-04-06', DATE '2010-04-01', DATE '2010-04-07', DATE '2010-04-02', DATE '2010-04-08', DATE '2010-04-03', DATE '2010-04-09', 1029, 3087, 13421, 13422, 13422, 13422, 13422, 13422, 13422, 2455290, 55289, N'2010-04-03', 201013, 13, 6, N'2010-W13', N'2010-W13-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93960, DATE '2010-04-04', DATE '2010-04-05', 2010, 20102, 201004, 2010094, 2, 4, 94, 4, 1, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-04', DATE '2010-04-10', DATE '2010-03-29', DATE '2010-04-04', DATE '2010-03-30', DATE '2010-04-05', DATE '2010-03-31', DATE '2010-04-06', DATE '2010-04-01', DATE '2010-04-07', DATE '2010-04-02', DATE '2010-04-08', DATE '2010-04-03', DATE '2010-04-09', 1029, 3087, 13422, 13422, 13422, 13422, 13422, 13422, 13422, 2455291, 55290, N'2010-04-04', 201013, 13, 7, N'2010-W13', N'2010-W13-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93961, DATE '2010-04-05', DATE '2010-04-06', 2010, 20102, 201004, 2010095, 2, 4, 95, 5, 2, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-04', DATE '2010-04-10', DATE '2010-04-05', DATE '2010-04-11', DATE '2010-03-30', DATE '2010-04-05', DATE '2010-03-31', DATE '2010-04-06', DATE '2010-04-01', DATE '2010-04-07', DATE '2010-04-02', DATE '2010-04-08', DATE '2010-04-03', DATE '2010-04-09', 1029, 3087, 13422, 13423, 13422, 13422, 13422, 13422, 13422, 2455292, 55291, N'2010-04-05', 201014, 14, 1, N'2010-W14', N'2010-W14-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93962, DATE '2010-04-06', DATE '2010-04-07', 2010, 20102, 201004, 2010096, 2, 4, 96, 6, 3, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-04', DATE '2010-04-10', DATE '2010-04-05', DATE '2010-04-11', DATE '2010-04-06', DATE '2010-04-12', DATE '2010-03-31', DATE '2010-04-06', DATE '2010-04-01', DATE '2010-04-07', DATE '2010-04-02', DATE '2010-04-08', DATE '2010-04-03', DATE '2010-04-09', 1029, 3087, 13422, 13423, 13423, 13422, 13422, 13422, 13422, 2455293, 55292, N'2010-04-06', 201014, 14, 2, N'2010-W14', N'2010-W14-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93963, DATE '2010-04-07', DATE '2010-04-08', 2010, 20102, 201004, 2010097, 2, 4, 97, 7, 4, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-04', DATE '2010-04-10', DATE '2010-04-05', DATE '2010-04-11', DATE '2010-04-06', DATE '2010-04-12', DATE '2010-04-07', DATE '2010-04-13', DATE '2010-04-01', DATE '2010-04-07', DATE '2010-04-02', DATE '2010-04-08', DATE '2010-04-03', DATE '2010-04-09', 1029, 3087, 13422, 13423, 13423, 13423, 13422, 13422, 13422, 2455294, 55293, N'2010-04-07', 201014, 14, 3, N'2010-W14', N'2010-W14-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93964, DATE '2010-04-08', DATE '2010-04-09', 2010, 20102, 201004, 2010098, 2, 4, 98, 8, 5, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-04', DATE '2010-04-10', DATE '2010-04-05', DATE '2010-04-11', DATE '2010-04-06', DATE '2010-04-12', DATE '2010-04-07', DATE '2010-04-13', DATE '2010-04-08', DATE '2010-04-14', DATE '2010-04-02', DATE '2010-04-08', DATE '2010-04-03', DATE '2010-04-09', 1029, 3087, 13422, 13423, 13423, 13423, 13423, 13422, 13422, 2455295, 55294, N'2010-04-08', 201014, 14, 4, N'2010-W14', N'2010-W14-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93965, DATE '2010-04-09', DATE '2010-04-10', 2010, 20102, 201004, 2010099, 2, 4, 99, 9, 6, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-04', DATE '2010-04-10', DATE '2010-04-05', DATE '2010-04-11', DATE '2010-04-06', DATE '2010-04-12', DATE '2010-04-07', DATE '2010-04-13', DATE '2010-04-08', DATE '2010-04-14', DATE '2010-04-09', DATE '2010-04-15', DATE '2010-04-03', DATE '2010-04-09', 1029, 3087, 13422, 13423, 13423, 13423, 13423, 13423, 13422, 2455296, 55295, N'2010-04-09', 201014, 14, 5, N'2010-W14', N'2010-W14-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93966, DATE '2010-04-10', DATE '2010-04-11', 2010, 20102, 201004, 2010100, 2, 4, 100, 10, 7, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-04', DATE '2010-04-10', DATE '2010-04-05', DATE '2010-04-11', DATE '2010-04-06', DATE '2010-04-12', DATE '2010-04-07', DATE '2010-04-13', DATE '2010-04-08', DATE '2010-04-14', DATE '2010-04-09', DATE '2010-04-15', DATE '2010-04-10', DATE '2010-04-16', 1029, 3087, 13422, 13423, 13423, 13423, 13423, 13423, 13423, 2455297, 55296, N'2010-04-10', 201014, 14, 6, N'2010-W14', N'2010-W14-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93967, DATE '2010-04-11', DATE '2010-04-12', 2010, 20102, 201004, 2010101, 2, 4, 101, 11, 1, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-11', DATE '2010-04-17', DATE '2010-04-05', DATE '2010-04-11', DATE '2010-04-06', DATE '2010-04-12', DATE '2010-04-07', DATE '2010-04-13', DATE '2010-04-08', DATE '2010-04-14', DATE '2010-04-09', DATE '2010-04-15', DATE '2010-04-10', DATE '2010-04-16', 1029, 3087, 13423, 13423, 13423, 13423, 13423, 13423, 13423, 2455298, 55297, N'2010-04-11', 201014, 14, 7, N'2010-W14', N'2010-W14-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93968, DATE '2010-04-12', DATE '2010-04-13', 2010, 20102, 201004, 2010102, 2, 4, 102, 12, 2, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-11', DATE '2010-04-17', DATE '2010-04-12', DATE '2010-04-18', DATE '2010-04-06', DATE '2010-04-12', DATE '2010-04-07', DATE '2010-04-13', DATE '2010-04-08', DATE '2010-04-14', DATE '2010-04-09', DATE '2010-04-15', DATE '2010-04-10', DATE '2010-04-16', 1029, 3087, 13423, 13424, 13423, 13423, 13423, 13423, 13423, 2455299, 55298, N'2010-04-12', 201015, 15, 1, N'2010-W15', N'2010-W15-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93969, DATE '2010-04-13', DATE '2010-04-14', 2010, 20102, 201004, 2010103, 2, 4, 103, 13, 3, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-11', DATE '2010-04-17', DATE '2010-04-12', DATE '2010-04-18', DATE '2010-04-13', DATE '2010-04-19', DATE '2010-04-07', DATE '2010-04-13', DATE '2010-04-08', DATE '2010-04-14', DATE '2010-04-09', DATE '2010-04-15', DATE '2010-04-10', DATE '2010-04-16', 1029, 3087, 13423, 13424, 13424, 13423, 13423, 13423, 13423, 2455300, 55299, N'2010-04-13', 201015, 15, 2, N'2010-W15', N'2010-W15-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93970, DATE '2010-04-14', DATE '2010-04-15', 2010, 20102, 201004, 2010104, 2, 4, 104, 14, 4, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-11', DATE '2010-04-17', DATE '2010-04-12', DATE '2010-04-18', DATE '2010-04-13', DATE '2010-04-19', DATE '2010-04-14', DATE '2010-04-20', DATE '2010-04-08', DATE '2010-04-14', DATE '2010-04-09', DATE '2010-04-15', DATE '2010-04-10', DATE '2010-04-16', 1029, 3087, 13423, 13424, 13424, 13424, 13423, 13423, 13423, 2455301, 55300, N'2010-04-14', 201015, 15, 3, N'2010-W15', N'2010-W15-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93971, DATE '2010-04-15', DATE '2010-04-16', 2010, 20102, 201004, 2010105, 2, 4, 105, 15, 5, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-11', DATE '2010-04-17', DATE '2010-04-12', DATE '2010-04-18', DATE '2010-04-13', DATE '2010-04-19', DATE '2010-04-14', DATE '2010-04-20', DATE '2010-04-15', DATE '2010-04-21', DATE '2010-04-09', DATE '2010-04-15', DATE '2010-04-10', DATE '2010-04-16', 1029, 3087, 13423, 13424, 13424, 13424, 13424, 13423, 13423, 2455302, 55301, N'2010-04-15', 201015, 15, 4, N'2010-W15', N'2010-W15-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93972, DATE '2010-04-16', DATE '2010-04-17', 2010, 20102, 201004, 2010106, 2, 4, 106, 16, 6, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-11', DATE '2010-04-17', DATE '2010-04-12', DATE '2010-04-18', DATE '2010-04-13', DATE '2010-04-19', DATE '2010-04-14', DATE '2010-04-20', DATE '2010-04-15', DATE '2010-04-21', DATE '2010-04-16', DATE '2010-04-22', DATE '2010-04-10', DATE '2010-04-16', 1029, 3087, 13423, 13424, 13424, 13424, 13424, 13424, 13423, 2455303, 55302, N'2010-04-16', 201015, 15, 5, N'2010-W15', N'2010-W15-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93973, DATE '2010-04-17', DATE '2010-04-18', 2010, 20102, 201004, 2010107, 2, 4, 107, 17, 7, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-11', DATE '2010-04-17', DATE '2010-04-12', DATE '2010-04-18', DATE '2010-04-13', DATE '2010-04-19', DATE '2010-04-14', DATE '2010-04-20', DATE '2010-04-15', DATE '2010-04-21', DATE '2010-04-16', DATE '2010-04-22', DATE '2010-04-17', DATE '2010-04-23', 1029, 3087, 13423, 13424, 13424, 13424, 13424, 13424, 13424, 2455304, 55303, N'2010-04-17', 201015, 15, 6, N'2010-W15', N'2010-W15-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93974, DATE '2010-04-18', DATE '2010-04-19', 2010, 20102, 201004, 2010108, 2, 4, 108, 18, 1, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-18', DATE '2010-04-24', DATE '2010-04-12', DATE '2010-04-18', DATE '2010-04-13', DATE '2010-04-19', DATE '2010-04-14', DATE '2010-04-20', DATE '2010-04-15', DATE '2010-04-21', DATE '2010-04-16', DATE '2010-04-22', DATE '2010-04-17', DATE '2010-04-23', 1029, 3087, 13424, 13424, 13424, 13424, 13424, 13424, 13424, 2455305, 55304, N'2010-04-18', 201015, 15, 7, N'2010-W15', N'2010-W15-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93975, DATE '2010-04-19', DATE '2010-04-20', 2010, 20102, 201004, 2010109, 2, 4, 109, 19, 2, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-18', DATE '2010-04-24', DATE '2010-04-19', DATE '2010-04-25', DATE '2010-04-13', DATE '2010-04-19', DATE '2010-04-14', DATE '2010-04-20', DATE '2010-04-15', DATE '2010-04-21', DATE '2010-04-16', DATE '2010-04-22', DATE '2010-04-17', DATE '2010-04-23', 1029, 3087, 13424, 13425, 13424, 13424, 13424, 13424, 13424, 2455306, 55305, N'2010-04-19', 201016, 16, 1, N'2010-W16', N'2010-W16-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93976, DATE '2010-04-20', DATE '2010-04-21', 2010, 20102, 201004, 2010110, 2, 4, 110, 20, 3, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-18', DATE '2010-04-24', DATE '2010-04-19', DATE '2010-04-25', DATE '2010-04-20', DATE '2010-04-26', DATE '2010-04-14', DATE '2010-04-20', DATE '2010-04-15', DATE '2010-04-21', DATE '2010-04-16', DATE '2010-04-22', DATE '2010-04-17', DATE '2010-04-23', 1029, 3087, 13424, 13425, 13425, 13424, 13424, 13424, 13424, 2455307, 55306, N'2010-04-20', 201016, 16, 2, N'2010-W16', N'2010-W16-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93977, DATE '2010-04-21', DATE '2010-04-22', 2010, 20102, 201004, 2010111, 2, 4, 111, 21, 4, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-18', DATE '2010-04-24', DATE '2010-04-19', DATE '2010-04-25', DATE '2010-04-20', DATE '2010-04-26', DATE '2010-04-21', DATE '2010-04-27', DATE '2010-04-15', DATE '2010-04-21', DATE '2010-04-16', DATE '2010-04-22', DATE '2010-04-17', DATE '2010-04-23', 1029, 3087, 13424, 13425, 13425, 13425, 13424, 13424, 13424, 2455308, 55307, N'2010-04-21', 201016, 16, 3, N'2010-W16', N'2010-W16-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93978, DATE '2010-04-22', DATE '2010-04-23', 2010, 20102, 201004, 2010112, 2, 4, 112, 22, 5, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-18', DATE '2010-04-24', DATE '2010-04-19', DATE '2010-04-25', DATE '2010-04-20', DATE '2010-04-26', DATE '2010-04-21', DATE '2010-04-27', DATE '2010-04-22', DATE '2010-04-28', DATE '2010-04-16', DATE '2010-04-22', DATE '2010-04-17', DATE '2010-04-23', 1029, 3087, 13424, 13425, 13425, 13425, 13425, 13424, 13424, 2455309, 55308, N'2010-04-22', 201016, 16, 4, N'2010-W16', N'2010-W16-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93979, DATE '2010-04-23', DATE '2010-04-24', 2010, 20102, 201004, 2010113, 2, 4, 113, 23, 6, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-18', DATE '2010-04-24', DATE '2010-04-19', DATE '2010-04-25', DATE '2010-04-20', DATE '2010-04-26', DATE '2010-04-21', DATE '2010-04-27', DATE '2010-04-22', DATE '2010-04-28', DATE '2010-04-23', DATE '2010-04-29', DATE '2010-04-17', DATE '2010-04-23', 1029, 3087, 13424, 13425, 13425, 13425, 13425, 13425, 13424, 2455310, 55309, N'2010-04-23', 201016, 16, 5, N'2010-W16', N'2010-W16-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93980, DATE '2010-04-24', DATE '2010-04-25', 2010, 20102, 201004, 2010114, 2, 4, 114, 24, 7, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-18', DATE '2010-04-24', DATE '2010-04-19', DATE '2010-04-25', DATE '2010-04-20', DATE '2010-04-26', DATE '2010-04-21', DATE '2010-04-27', DATE '2010-04-22', DATE '2010-04-28', DATE '2010-04-23', DATE '2010-04-29', DATE '2010-04-24', DATE '2010-04-30', 1029, 3087, 13424, 13425, 13425, 13425, 13425, 13425, 13425, 2455311, 55310, N'2010-04-24', 201016, 16, 6, N'2010-W16', N'2010-W16-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93981, DATE '2010-04-25', DATE '2010-04-26', 2010, 20102, 201004, 2010115, 2, 4, 115, 25, 1, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-25', DATE '2010-05-01', DATE '2010-04-19', DATE '2010-04-25', DATE '2010-04-20', DATE '2010-04-26', DATE '2010-04-21', DATE '2010-04-27', DATE '2010-04-22', DATE '2010-04-28', DATE '2010-04-23', DATE '2010-04-29', DATE '2010-04-24', DATE '2010-04-30', 1029, 3087, 13425, 13425, 13425, 13425, 13425, 13425, 13425, 2455312, 55311, N'2010-04-25', 201016, 16, 7, N'2010-W16', N'2010-W16-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93982, DATE '2010-04-26', DATE '2010-04-27', 2010, 20102, 201004, 2010116, 2, 4, 116, 26, 2, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-25', DATE '2010-05-01', DATE '2010-04-26', DATE '2010-05-02', DATE '2010-04-20', DATE '2010-04-26', DATE '2010-04-21', DATE '2010-04-27', DATE '2010-04-22', DATE '2010-04-28', DATE '2010-04-23', DATE '2010-04-29', DATE '2010-04-24', DATE '2010-04-30', 1029, 3087, 13425, 13426, 13425, 13425, 13425, 13425, 13425, 2455313, 55312, N'2010-04-26', 201017, 17, 1, N'2010-W17', N'2010-W17-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93983, DATE '2010-04-27', DATE '2010-04-28', 2010, 20102, 201004, 2010117, 2, 4, 117, 27, 3, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-25', DATE '2010-05-01', DATE '2010-04-26', DATE '2010-05-02', DATE '2010-04-27', DATE '2010-05-03', DATE '2010-04-21', DATE '2010-04-27', DATE '2010-04-22', DATE '2010-04-28', DATE '2010-04-23', DATE '2010-04-29', DATE '2010-04-24', DATE '2010-04-30', 1029, 3087, 13425, 13426, 13426, 13425, 13425, 13425, 13425, 2455314, 55313, N'2010-04-27', 201017, 17, 2, N'2010-W17', N'2010-W17-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93984, DATE '2010-04-28', DATE '2010-04-29', 2010, 20102, 201004, 2010118, 2, 4, 118, 28, 4, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-25', DATE '2010-05-01', DATE '2010-04-26', DATE '2010-05-02', DATE '2010-04-27', DATE '2010-05-03', DATE '2010-04-28', DATE '2010-05-04', DATE '2010-04-22', DATE '2010-04-28', DATE '2010-04-23', DATE '2010-04-29', DATE '2010-04-24', DATE '2010-04-30', 1029, 3087, 13425, 13426, 13426, 13426, 13425, 13425, 13425, 2455315, 55314, N'2010-04-28', 201017, 17, 3, N'2010-W17', N'2010-W17-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93985, DATE '2010-04-29', DATE '2010-04-30', 2010, 20102, 201004, 2010119, 2, 4, 119, 29, 5, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-25', DATE '2010-05-01', DATE '2010-04-26', DATE '2010-05-02', DATE '2010-04-27', DATE '2010-05-03', DATE '2010-04-28', DATE '2010-05-04', DATE '2010-04-29', DATE '2010-05-05', DATE '2010-04-23', DATE '2010-04-29', DATE '2010-04-24', DATE '2010-04-30', 1029, 3087, 13425, 13426, 13426, 13426, 13426, 13425, 13425, 2455316, 55315, N'2010-04-29', 201017, 17, 4, N'2010-W17', N'2010-W17-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93986, DATE '2010-04-30', DATE '2010-05-01', 2010, 20102, 201004, 2010120, 2, 4, 120, 30, 6, N'2010', N'2010 Q2', N'2010 Apr', N'Apr', N'April', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-04-01', DATE '2010-04-30', DATE '2010-04-25', DATE '2010-05-01', DATE '2010-04-26', DATE '2010-05-02', DATE '2010-04-27', DATE '2010-05-03', DATE '2010-04-28', DATE '2010-05-04', DATE '2010-04-29', DATE '2010-05-05', DATE '2010-04-30', DATE '2010-05-06', DATE '2010-04-24', DATE '2010-04-30', 1029, 3087, 13425, 13426, 13426, 13426, 13426, 13426, 13425, 2455317, 55316, N'2010-04-30', 201017, 17, 5, N'2010-W17', N'2010-W17-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93987, DATE '2010-05-01', DATE '2010-05-02', 2010, 20102, 201005, 2010121, 2, 5, 121, 1, 7, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-04-25', DATE '2010-05-01', DATE '2010-04-26', DATE '2010-05-02', DATE '2010-04-27', DATE '2010-05-03', DATE '2010-04-28', DATE '2010-05-04', DATE '2010-04-29', DATE '2010-05-05', DATE '2010-04-30', DATE '2010-05-06', DATE '2010-05-01', DATE '2010-05-07', 1029, 3088, 13425, 13426, 13426, 13426, 13426, 13426, 13426, 2455318, 55317, N'2010-05-01', 201017, 17, 6, N'2010-W17', N'2010-W17-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93988, DATE '2010-05-02', DATE '2010-05-03', 2010, 20102, 201005, 2010122, 2, 5, 122, 2, 1, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-02', DATE '2010-05-08', DATE '2010-04-26', DATE '2010-05-02', DATE '2010-04-27', DATE '2010-05-03', DATE '2010-04-28', DATE '2010-05-04', DATE '2010-04-29', DATE '2010-05-05', DATE '2010-04-30', DATE '2010-05-06', DATE '2010-05-01', DATE '2010-05-07', 1029, 3088, 13426, 13426, 13426, 13426, 13426, 13426, 13426, 2455319, 55318, N'2010-05-02', 201017, 17, 7, N'2010-W17', N'2010-W17-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93989, DATE '2010-05-03', DATE '2010-05-04', 2010, 20102, 201005, 2010123, 2, 5, 123, 3, 2, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-02', DATE '2010-05-08', DATE '2010-05-03', DATE '2010-05-09', DATE '2010-04-27', DATE '2010-05-03', DATE '2010-04-28', DATE '2010-05-04', DATE '2010-04-29', DATE '2010-05-05', DATE '2010-04-30', DATE '2010-05-06', DATE '2010-05-01', DATE '2010-05-07', 1029, 3088, 13426, 13427, 13426, 13426, 13426, 13426, 13426, 2455320, 55319, N'2010-05-03', 201018, 18, 1, N'2010-W18', N'2010-W18-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93990, DATE '2010-05-04', DATE '2010-05-05', 2010, 20102, 201005, 2010124, 2, 5, 124, 4, 3, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-02', DATE '2010-05-08', DATE '2010-05-03', DATE '2010-05-09', DATE '2010-05-04', DATE '2010-05-10', DATE '2010-04-28', DATE '2010-05-04', DATE '2010-04-29', DATE '2010-05-05', DATE '2010-04-30', DATE '2010-05-06', DATE '2010-05-01', DATE '2010-05-07', 1029, 3088, 13426, 13427, 13427, 13426, 13426, 13426, 13426, 2455321, 55320, N'2010-05-04', 201018, 18, 2, N'2010-W18', N'2010-W18-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93991, DATE '2010-05-05', DATE '2010-05-06', 2010, 20102, 201005, 2010125, 2, 5, 125, 5, 4, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-02', DATE '2010-05-08', DATE '2010-05-03', DATE '2010-05-09', DATE '2010-05-04', DATE '2010-05-10', DATE '2010-05-05', DATE '2010-05-11', DATE '2010-04-29', DATE '2010-05-05', DATE '2010-04-30', DATE '2010-05-06', DATE '2010-05-01', DATE '2010-05-07', 1029, 3088, 13426, 13427, 13427, 13427, 13426, 13426, 13426, 2455322, 55321, N'2010-05-05', 201018, 18, 3, N'2010-W18', N'2010-W18-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93992, DATE '2010-05-06', DATE '2010-05-07', 2010, 20102, 201005, 2010126, 2, 5, 126, 6, 5, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-02', DATE '2010-05-08', DATE '2010-05-03', DATE '2010-05-09', DATE '2010-05-04', DATE '2010-05-10', DATE '2010-05-05', DATE '2010-05-11', DATE '2010-05-06', DATE '2010-05-12', DATE '2010-04-30', DATE '2010-05-06', DATE '2010-05-01', DATE '2010-05-07', 1029, 3088, 13426, 13427, 13427, 13427, 13427, 13426, 13426, 2455323, 55322, N'2010-05-06', 201018, 18, 4, N'2010-W18', N'2010-W18-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93993, DATE '2010-05-07', DATE '2010-05-08', 2010, 20102, 201005, 2010127, 2, 5, 127, 7, 6, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-02', DATE '2010-05-08', DATE '2010-05-03', DATE '2010-05-09', DATE '2010-05-04', DATE '2010-05-10', DATE '2010-05-05', DATE '2010-05-11', DATE '2010-05-06', DATE '2010-05-12', DATE '2010-05-07', DATE '2010-05-13', DATE '2010-05-01', DATE '2010-05-07', 1029, 3088, 13426, 13427, 13427, 13427, 13427, 13427, 13426, 2455324, 55323, N'2010-05-07', 201018, 18, 5, N'2010-W18', N'2010-W18-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93994, DATE '2010-05-08', DATE '2010-05-09', 2010, 20102, 201005, 2010128, 2, 5, 128, 8, 7, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-02', DATE '2010-05-08', DATE '2010-05-03', DATE '2010-05-09', DATE '2010-05-04', DATE '2010-05-10', DATE '2010-05-05', DATE '2010-05-11', DATE '2010-05-06', DATE '2010-05-12', DATE '2010-05-07', DATE '2010-05-13', DATE '2010-05-08', DATE '2010-05-14', 1029, 3088, 13426, 13427, 13427, 13427, 13427, 13427, 13427, 2455325, 55324, N'2010-05-08', 201018, 18, 6, N'2010-W18', N'2010-W18-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93995, DATE '2010-05-09', DATE '2010-05-10', 2010, 20102, 201005, 2010129, 2, 5, 129, 9, 1, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-09', DATE '2010-05-15', DATE '2010-05-03', DATE '2010-05-09', DATE '2010-05-04', DATE '2010-05-10', DATE '2010-05-05', DATE '2010-05-11', DATE '2010-05-06', DATE '2010-05-12', DATE '2010-05-07', DATE '2010-05-13', DATE '2010-05-08', DATE '2010-05-14', 1029, 3088, 13427, 13427, 13427, 13427, 13427, 13427, 13427, 2455326, 55325, N'2010-05-09', 201018, 18, 7, N'2010-W18', N'2010-W18-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93996, DATE '2010-05-10', DATE '2010-05-11', 2010, 20102, 201005, 2010130, 2, 5, 130, 10, 2, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-09', DATE '2010-05-15', DATE '2010-05-10', DATE '2010-05-16', DATE '2010-05-04', DATE '2010-05-10', DATE '2010-05-05', DATE '2010-05-11', DATE '2010-05-06', DATE '2010-05-12', DATE '2010-05-07', DATE '2010-05-13', DATE '2010-05-08', DATE '2010-05-14', 1029, 3088, 13427, 13428, 13427, 13427, 13427, 13427, 13427, 2455327, 55326, N'2010-05-10', 201019, 19, 1, N'2010-W19', N'2010-W19-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93997, DATE '2010-05-11', DATE '2010-05-12', 2010, 20102, 201005, 2010131, 2, 5, 131, 11, 3, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-09', DATE '2010-05-15', DATE '2010-05-10', DATE '2010-05-16', DATE '2010-05-11', DATE '2010-05-17', DATE '2010-05-05', DATE '2010-05-11', DATE '2010-05-06', DATE '2010-05-12', DATE '2010-05-07', DATE '2010-05-13', DATE '2010-05-08', DATE '2010-05-14', 1029, 3088, 13427, 13428, 13428, 13427, 13427, 13427, 13427, 2455328, 55327, N'2010-05-11', 201019, 19, 2, N'2010-W19', N'2010-W19-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93998, DATE '2010-05-12', DATE '2010-05-13', 2010, 20102, 201005, 2010132, 2, 5, 132, 12, 4, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-09', DATE '2010-05-15', DATE '2010-05-10', DATE '2010-05-16', DATE '2010-05-11', DATE '2010-05-17', DATE '2010-05-12', DATE '2010-05-18', DATE '2010-05-06', DATE '2010-05-12', DATE '2010-05-07', DATE '2010-05-13', DATE '2010-05-08', DATE '2010-05-14', 1029, 3088, 13427, 13428, 13428, 13428, 13427, 13427, 13427, 2455329, 55328, N'2010-05-12', 201019, 19, 3, N'2010-W19', N'2010-W19-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (93999, DATE '2010-05-13', DATE '2010-05-14', 2010, 20102, 201005, 2010133, 2, 5, 133, 13, 5, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-09', DATE '2010-05-15', DATE '2010-05-10', DATE '2010-05-16', DATE '2010-05-11', DATE '2010-05-17', DATE '2010-05-12', DATE '2010-05-18', DATE '2010-05-13', DATE '2010-05-19', DATE '2010-05-07', DATE '2010-05-13', DATE '2010-05-08', DATE '2010-05-14', 1029, 3088, 13427, 13428, 13428, 13428, 13428, 13427, 13427, 2455330, 55329, N'2010-05-13', 201019, 19, 4, N'2010-W19', N'2010-W19-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94000, DATE '2010-05-14', DATE '2010-05-15', 2010, 20102, 201005, 2010134, 2, 5, 134, 14, 6, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-09', DATE '2010-05-15', DATE '2010-05-10', DATE '2010-05-16', DATE '2010-05-11', DATE '2010-05-17', DATE '2010-05-12', DATE '2010-05-18', DATE '2010-05-13', DATE '2010-05-19', DATE '2010-05-14', DATE '2010-05-20', DATE '2010-05-08', DATE '2010-05-14', 1029, 3088, 13427, 13428, 13428, 13428, 13428, 13428, 13427, 2455331, 55330, N'2010-05-14', 201019, 19, 5, N'2010-W19', N'2010-W19-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94001, DATE '2010-05-15', DATE '2010-05-16', 2010, 20102, 201005, 2010135, 2, 5, 135, 15, 7, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-09', DATE '2010-05-15', DATE '2010-05-10', DATE '2010-05-16', DATE '2010-05-11', DATE '2010-05-17', DATE '2010-05-12', DATE '2010-05-18', DATE '2010-05-13', DATE '2010-05-19', DATE '2010-05-14', DATE '2010-05-20', DATE '2010-05-15', DATE '2010-05-21', 1029, 3088, 13427, 13428, 13428, 13428, 13428, 13428, 13428, 2455332, 55331, N'2010-05-15', 201019, 19, 6, N'2010-W19', N'2010-W19-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94002, DATE '2010-05-16', DATE '2010-05-17', 2010, 20102, 201005, 2010136, 2, 5, 136, 16, 1, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-16', DATE '2010-05-22', DATE '2010-05-10', DATE '2010-05-16', DATE '2010-05-11', DATE '2010-05-17', DATE '2010-05-12', DATE '2010-05-18', DATE '2010-05-13', DATE '2010-05-19', DATE '2010-05-14', DATE '2010-05-20', DATE '2010-05-15', DATE '2010-05-21', 1029, 3088, 13428, 13428, 13428, 13428, 13428, 13428, 13428, 2455333, 55332, N'2010-05-16', 201019, 19, 7, N'2010-W19', N'2010-W19-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94003, DATE '2010-05-17', DATE '2010-05-18', 2010, 20102, 201005, 2010137, 2, 5, 137, 17, 2, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-16', DATE '2010-05-22', DATE '2010-05-17', DATE '2010-05-23', DATE '2010-05-11', DATE '2010-05-17', DATE '2010-05-12', DATE '2010-05-18', DATE '2010-05-13', DATE '2010-05-19', DATE '2010-05-14', DATE '2010-05-20', DATE '2010-05-15', DATE '2010-05-21', 1029, 3088, 13428, 13429, 13428, 13428, 13428, 13428, 13428, 2455334, 55333, N'2010-05-17', 201020, 20, 1, N'2010-W20', N'2010-W20-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94004, DATE '2010-05-18', DATE '2010-05-19', 2010, 20102, 201005, 2010138, 2, 5, 138, 18, 3, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-16', DATE '2010-05-22', DATE '2010-05-17', DATE '2010-05-23', DATE '2010-05-18', DATE '2010-05-24', DATE '2010-05-12', DATE '2010-05-18', DATE '2010-05-13', DATE '2010-05-19', DATE '2010-05-14', DATE '2010-05-20', DATE '2010-05-15', DATE '2010-05-21', 1029, 3088, 13428, 13429, 13429, 13428, 13428, 13428, 13428, 2455335, 55334, N'2010-05-18', 201020, 20, 2, N'2010-W20', N'2010-W20-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94005, DATE '2010-05-19', DATE '2010-05-20', 2010, 20102, 201005, 2010139, 2, 5, 139, 19, 4, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-16', DATE '2010-05-22', DATE '2010-05-17', DATE '2010-05-23', DATE '2010-05-18', DATE '2010-05-24', DATE '2010-05-19', DATE '2010-05-25', DATE '2010-05-13', DATE '2010-05-19', DATE '2010-05-14', DATE '2010-05-20', DATE '2010-05-15', DATE '2010-05-21', 1029, 3088, 13428, 13429, 13429, 13429, 13428, 13428, 13428, 2455336, 55335, N'2010-05-19', 201020, 20, 3, N'2010-W20', N'2010-W20-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94006, DATE '2010-05-20', DATE '2010-05-21', 2010, 20102, 201005, 2010140, 2, 5, 140, 20, 5, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-16', DATE '2010-05-22', DATE '2010-05-17', DATE '2010-05-23', DATE '2010-05-18', DATE '2010-05-24', DATE '2010-05-19', DATE '2010-05-25', DATE '2010-05-20', DATE '2010-05-26', DATE '2010-05-14', DATE '2010-05-20', DATE '2010-05-15', DATE '2010-05-21', 1029, 3088, 13428, 13429, 13429, 13429, 13429, 13428, 13428, 2455337, 55336, N'2010-05-20', 201020, 20, 4, N'2010-W20', N'2010-W20-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94007, DATE '2010-05-21', DATE '2010-05-22', 2010, 20102, 201005, 2010141, 2, 5, 141, 21, 6, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-16', DATE '2010-05-22', DATE '2010-05-17', DATE '2010-05-23', DATE '2010-05-18', DATE '2010-05-24', DATE '2010-05-19', DATE '2010-05-25', DATE '2010-05-20', DATE '2010-05-26', DATE '2010-05-21', DATE '2010-05-27', DATE '2010-05-15', DATE '2010-05-21', 1029, 3088, 13428, 13429, 13429, 13429, 13429, 13429, 13428, 2455338, 55337, N'2010-05-21', 201020, 20, 5, N'2010-W20', N'2010-W20-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94008, DATE '2010-05-22', DATE '2010-05-23', 2010, 20102, 201005, 2010142, 2, 5, 142, 22, 7, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-16', DATE '2010-05-22', DATE '2010-05-17', DATE '2010-05-23', DATE '2010-05-18', DATE '2010-05-24', DATE '2010-05-19', DATE '2010-05-25', DATE '2010-05-20', DATE '2010-05-26', DATE '2010-05-21', DATE '2010-05-27', DATE '2010-05-22', DATE '2010-05-28', 1029, 3088, 13428, 13429, 13429, 13429, 13429, 13429, 13429, 2455339, 55338, N'2010-05-22', 201020, 20, 6, N'2010-W20', N'2010-W20-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94009, DATE '2010-05-23', DATE '2010-05-24', 2010, 20102, 201005, 2010143, 2, 5, 143, 23, 1, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-23', DATE '2010-05-29', DATE '2010-05-17', DATE '2010-05-23', DATE '2010-05-18', DATE '2010-05-24', DATE '2010-05-19', DATE '2010-05-25', DATE '2010-05-20', DATE '2010-05-26', DATE '2010-05-21', DATE '2010-05-27', DATE '2010-05-22', DATE '2010-05-28', 1029, 3088, 13429, 13429, 13429, 13429, 13429, 13429, 13429, 2455340, 55339, N'2010-05-23', 201020, 20, 7, N'2010-W20', N'2010-W20-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94010, DATE '2010-05-24', DATE '2010-05-25', 2010, 20102, 201005, 2010144, 2, 5, 144, 24, 2, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-23', DATE '2010-05-29', DATE '2010-05-24', DATE '2010-05-30', DATE '2010-05-18', DATE '2010-05-24', DATE '2010-05-19', DATE '2010-05-25', DATE '2010-05-20', DATE '2010-05-26', DATE '2010-05-21', DATE '2010-05-27', DATE '2010-05-22', DATE '2010-05-28', 1029, 3088, 13429, 13430, 13429, 13429, 13429, 13429, 13429, 2455341, 55340, N'2010-05-24', 201021, 21, 1, N'2010-W21', N'2010-W21-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94011, DATE '2010-05-25', DATE '2010-05-26', 2010, 20102, 201005, 2010145, 2, 5, 145, 25, 3, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-23', DATE '2010-05-29', DATE '2010-05-24', DATE '2010-05-30', DATE '2010-05-25', DATE '2010-05-31', DATE '2010-05-19', DATE '2010-05-25', DATE '2010-05-20', DATE '2010-05-26', DATE '2010-05-21', DATE '2010-05-27', DATE '2010-05-22', DATE '2010-05-28', 1029, 3088, 13429, 13430, 13430, 13429, 13429, 13429, 13429, 2455342, 55341, N'2010-05-25', 201021, 21, 2, N'2010-W21', N'2010-W21-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94012, DATE '2010-05-26', DATE '2010-05-27', 2010, 20102, 201005, 2010146, 2, 5, 146, 26, 4, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-23', DATE '2010-05-29', DATE '2010-05-24', DATE '2010-05-30', DATE '2010-05-25', DATE '2010-05-31', DATE '2010-05-26', DATE '2010-06-01', DATE '2010-05-20', DATE '2010-05-26', DATE '2010-05-21', DATE '2010-05-27', DATE '2010-05-22', DATE '2010-05-28', 1029, 3088, 13429, 13430, 13430, 13430, 13429, 13429, 13429, 2455343, 55342, N'2010-05-26', 201021, 21, 3, N'2010-W21', N'2010-W21-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94013, DATE '2010-05-27', DATE '2010-05-28', 2010, 20102, 201005, 2010147, 2, 5, 147, 27, 5, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-23', DATE '2010-05-29', DATE '2010-05-24', DATE '2010-05-30', DATE '2010-05-25', DATE '2010-05-31', DATE '2010-05-26', DATE '2010-06-01', DATE '2010-05-27', DATE '2010-06-02', DATE '2010-05-21', DATE '2010-05-27', DATE '2010-05-22', DATE '2010-05-28', 1029, 3088, 13429, 13430, 13430, 13430, 13430, 13429, 13429, 2455344, 55343, N'2010-05-27', 201021, 21, 4, N'2010-W21', N'2010-W21-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94014, DATE '2010-05-28', DATE '2010-05-29', 2010, 20102, 201005, 2010148, 2, 5, 148, 28, 6, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-23', DATE '2010-05-29', DATE '2010-05-24', DATE '2010-05-30', DATE '2010-05-25', DATE '2010-05-31', DATE '2010-05-26', DATE '2010-06-01', DATE '2010-05-27', DATE '2010-06-02', DATE '2010-05-28', DATE '2010-06-03', DATE '2010-05-22', DATE '2010-05-28', 1029, 3088, 13429, 13430, 13430, 13430, 13430, 13430, 13429, 2455345, 55344, N'2010-05-28', 201021, 21, 5, N'2010-W21', N'2010-W21-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94015, DATE '2010-05-29', DATE '2010-05-30', 2010, 20102, 201005, 2010149, 2, 5, 149, 29, 7, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-23', DATE '2010-05-29', DATE '2010-05-24', DATE '2010-05-30', DATE '2010-05-25', DATE '2010-05-31', DATE '2010-05-26', DATE '2010-06-01', DATE '2010-05-27', DATE '2010-06-02', DATE '2010-05-28', DATE '2010-06-03', DATE '2010-05-29', DATE '2010-06-04', 1029, 3088, 13429, 13430, 13430, 13430, 13430, 13430, 13430, 2455346, 55345, N'2010-05-29', 201021, 21, 6, N'2010-W21', N'2010-W21-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94016, DATE '2010-05-30', DATE '2010-05-31', 2010, 20102, 201005, 2010150, 2, 5, 150, 30, 1, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-30', DATE '2010-06-05', DATE '2010-05-24', DATE '2010-05-30', DATE '2010-05-25', DATE '2010-05-31', DATE '2010-05-26', DATE '2010-06-01', DATE '2010-05-27', DATE '2010-06-02', DATE '2010-05-28', DATE '2010-06-03', DATE '2010-05-29', DATE '2010-06-04', 1029, 3088, 13430, 13430, 13430, 13430, 13430, 13430, 13430, 2455347, 55346, N'2010-05-30', 201021, 21, 7, N'2010-W21', N'2010-W21-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94017, DATE '2010-05-31', DATE '2010-06-01', 2010, 20102, 201005, 2010151, 2, 5, 151, 31, 2, N'2010', N'2010 Q2', N'2010 May', N'May', N'May', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-05-01', DATE '2010-05-31', DATE '2010-05-30', DATE '2010-06-05', DATE '2010-05-31', DATE '2010-06-06', DATE '2010-05-25', DATE '2010-05-31', DATE '2010-05-26', DATE '2010-06-01', DATE '2010-05-27', DATE '2010-06-02', DATE '2010-05-28', DATE '2010-06-03', DATE '2010-05-29', DATE '2010-06-04', 1029, 3088, 13430, 13431, 13430, 13430, 13430, 13430, 13430, 2455348, 55347, N'2010-05-31', 201022, 22, 1, N'2010-W22', N'2010-W22-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94018, DATE '2010-06-01', DATE '2010-06-02', 2010, 20102, 201006, 2010152, 2, 6, 152, 1, 3, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-05-30', DATE '2010-06-05', DATE '2010-05-31', DATE '2010-06-06', DATE '2010-06-01', DATE '2010-06-07', DATE '2010-05-26', DATE '2010-06-01', DATE '2010-05-27', DATE '2010-06-02', DATE '2010-05-28', DATE '2010-06-03', DATE '2010-05-29', DATE '2010-06-04', 1029, 3089, 13430, 13431, 13431, 13430, 13430, 13430, 13430, 2455349, 55348, N'2010-06-01', 201022, 22, 2, N'2010-W22', N'2010-W22-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94019, DATE '2010-06-02', DATE '2010-06-03', 2010, 20102, 201006, 2010153, 2, 6, 153, 2, 4, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-05-30', DATE '2010-06-05', DATE '2010-05-31', DATE '2010-06-06', DATE '2010-06-01', DATE '2010-06-07', DATE '2010-06-02', DATE '2010-06-08', DATE '2010-05-27', DATE '2010-06-02', DATE '2010-05-28', DATE '2010-06-03', DATE '2010-05-29', DATE '2010-06-04', 1029, 3089, 13430, 13431, 13431, 13431, 13430, 13430, 13430, 2455350, 55349, N'2010-06-02', 201022, 22, 3, N'2010-W22', N'2010-W22-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94020, DATE '2010-06-03', DATE '2010-06-04', 2010, 20102, 201006, 2010154, 2, 6, 154, 3, 5, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-05-30', DATE '2010-06-05', DATE '2010-05-31', DATE '2010-06-06', DATE '2010-06-01', DATE '2010-06-07', DATE '2010-06-02', DATE '2010-06-08', DATE '2010-06-03', DATE '2010-06-09', DATE '2010-05-28', DATE '2010-06-03', DATE '2010-05-29', DATE '2010-06-04', 1029, 3089, 13430, 13431, 13431, 13431, 13431, 13430, 13430, 2455351, 55350, N'2010-06-03', 201022, 22, 4, N'2010-W22', N'2010-W22-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94021, DATE '2010-06-04', DATE '2010-06-05', 2010, 20102, 201006, 2010155, 2, 6, 155, 4, 6, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-05-30', DATE '2010-06-05', DATE '2010-05-31', DATE '2010-06-06', DATE '2010-06-01', DATE '2010-06-07', DATE '2010-06-02', DATE '2010-06-08', DATE '2010-06-03', DATE '2010-06-09', DATE '2010-06-04', DATE '2010-06-10', DATE '2010-05-29', DATE '2010-06-04', 1029, 3089, 13430, 13431, 13431, 13431, 13431, 13431, 13430, 2455352, 55351, N'2010-06-04', 201022, 22, 5, N'2010-W22', N'2010-W22-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94022, DATE '2010-06-05', DATE '2010-06-06', 2010, 20102, 201006, 2010156, 2, 6, 156, 5, 7, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-05-30', DATE '2010-06-05', DATE '2010-05-31', DATE '2010-06-06', DATE '2010-06-01', DATE '2010-06-07', DATE '2010-06-02', DATE '2010-06-08', DATE '2010-06-03', DATE '2010-06-09', DATE '2010-06-04', DATE '2010-06-10', DATE '2010-06-05', DATE '2010-06-11', 1029, 3089, 13430, 13431, 13431, 13431, 13431, 13431, 13431, 2455353, 55352, N'2010-06-05', 201022, 22, 6, N'2010-W22', N'2010-W22-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94023, DATE '2010-06-06', DATE '2010-06-07', 2010, 20102, 201006, 2010157, 2, 6, 157, 6, 1, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-06', DATE '2010-06-12', DATE '2010-05-31', DATE '2010-06-06', DATE '2010-06-01', DATE '2010-06-07', DATE '2010-06-02', DATE '2010-06-08', DATE '2010-06-03', DATE '2010-06-09', DATE '2010-06-04', DATE '2010-06-10', DATE '2010-06-05', DATE '2010-06-11', 1029, 3089, 13431, 13431, 13431, 13431, 13431, 13431, 13431, 2455354, 55353, N'2010-06-06', 201022, 22, 7, N'2010-W22', N'2010-W22-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94024, DATE '2010-06-07', DATE '2010-06-08', 2010, 20102, 201006, 2010158, 2, 6, 158, 7, 2, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-06', DATE '2010-06-12', DATE '2010-06-07', DATE '2010-06-13', DATE '2010-06-01', DATE '2010-06-07', DATE '2010-06-02', DATE '2010-06-08', DATE '2010-06-03', DATE '2010-06-09', DATE '2010-06-04', DATE '2010-06-10', DATE '2010-06-05', DATE '2010-06-11', 1029, 3089, 13431, 13432, 13431, 13431, 13431, 13431, 13431, 2455355, 55354, N'2010-06-07', 201023, 23, 1, N'2010-W23', N'2010-W23-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94025, DATE '2010-06-08', DATE '2010-06-09', 2010, 20102, 201006, 2010159, 2, 6, 159, 8, 3, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-06', DATE '2010-06-12', DATE '2010-06-07', DATE '2010-06-13', DATE '2010-06-08', DATE '2010-06-14', DATE '2010-06-02', DATE '2010-06-08', DATE '2010-06-03', DATE '2010-06-09', DATE '2010-06-04', DATE '2010-06-10', DATE '2010-06-05', DATE '2010-06-11', 1029, 3089, 13431, 13432, 13432, 13431, 13431, 13431, 13431, 2455356, 55355, N'2010-06-08', 201023, 23, 2, N'2010-W23', N'2010-W23-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94026, DATE '2010-06-09', DATE '2010-06-10', 2010, 20102, 201006, 2010160, 2, 6, 160, 9, 4, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-06', DATE '2010-06-12', DATE '2010-06-07', DATE '2010-06-13', DATE '2010-06-08', DATE '2010-06-14', DATE '2010-06-09', DATE '2010-06-15', DATE '2010-06-03', DATE '2010-06-09', DATE '2010-06-04', DATE '2010-06-10', DATE '2010-06-05', DATE '2010-06-11', 1029, 3089, 13431, 13432, 13432, 13432, 13431, 13431, 13431, 2455357, 55356, N'2010-06-09', 201023, 23, 3, N'2010-W23', N'2010-W23-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94027, DATE '2010-06-10', DATE '2010-06-11', 2010, 20102, 201006, 2010161, 2, 6, 161, 10, 5, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-06', DATE '2010-06-12', DATE '2010-06-07', DATE '2010-06-13', DATE '2010-06-08', DATE '2010-06-14', DATE '2010-06-09', DATE '2010-06-15', DATE '2010-06-10', DATE '2010-06-16', DATE '2010-06-04', DATE '2010-06-10', DATE '2010-06-05', DATE '2010-06-11', 1029, 3089, 13431, 13432, 13432, 13432, 13432, 13431, 13431, 2455358, 55357, N'2010-06-10', 201023, 23, 4, N'2010-W23', N'2010-W23-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94028, DATE '2010-06-11', DATE '2010-06-12', 2010, 20102, 201006, 2010162, 2, 6, 162, 11, 6, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-06', DATE '2010-06-12', DATE '2010-06-07', DATE '2010-06-13', DATE '2010-06-08', DATE '2010-06-14', DATE '2010-06-09', DATE '2010-06-15', DATE '2010-06-10', DATE '2010-06-16', DATE '2010-06-11', DATE '2010-06-17', DATE '2010-06-05', DATE '2010-06-11', 1029, 3089, 13431, 13432, 13432, 13432, 13432, 13432, 13431, 2455359, 55358, N'2010-06-11', 201023, 23, 5, N'2010-W23', N'2010-W23-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94029, DATE '2010-06-12', DATE '2010-06-13', 2010, 20102, 201006, 2010163, 2, 6, 163, 12, 7, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-06', DATE '2010-06-12', DATE '2010-06-07', DATE '2010-06-13', DATE '2010-06-08', DATE '2010-06-14', DATE '2010-06-09', DATE '2010-06-15', DATE '2010-06-10', DATE '2010-06-16', DATE '2010-06-11', DATE '2010-06-17', DATE '2010-06-12', DATE '2010-06-18', 1029, 3089, 13431, 13432, 13432, 13432, 13432, 13432, 13432, 2455360, 55359, N'2010-06-12', 201023, 23, 6, N'2010-W23', N'2010-W23-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94030, DATE '2010-06-13', DATE '2010-06-14', 2010, 20102, 201006, 2010164, 2, 6, 164, 13, 1, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-13', DATE '2010-06-19', DATE '2010-06-07', DATE '2010-06-13', DATE '2010-06-08', DATE '2010-06-14', DATE '2010-06-09', DATE '2010-06-15', DATE '2010-06-10', DATE '2010-06-16', DATE '2010-06-11', DATE '2010-06-17', DATE '2010-06-12', DATE '2010-06-18', 1029, 3089, 13432, 13432, 13432, 13432, 13432, 13432, 13432, 2455361, 55360, N'2010-06-13', 201023, 23, 7, N'2010-W23', N'2010-W23-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94031, DATE '2010-06-14', DATE '2010-06-15', 2010, 20102, 201006, 2010165, 2, 6, 165, 14, 2, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-13', DATE '2010-06-19', DATE '2010-06-14', DATE '2010-06-20', DATE '2010-06-08', DATE '2010-06-14', DATE '2010-06-09', DATE '2010-06-15', DATE '2010-06-10', DATE '2010-06-16', DATE '2010-06-11', DATE '2010-06-17', DATE '2010-06-12', DATE '2010-06-18', 1029, 3089, 13432, 13433, 13432, 13432, 13432, 13432, 13432, 2455362, 55361, N'2010-06-14', 201024, 24, 1, N'2010-W24', N'2010-W24-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94032, DATE '2010-06-15', DATE '2010-06-16', 2010, 20102, 201006, 2010166, 2, 6, 166, 15, 3, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-13', DATE '2010-06-19', DATE '2010-06-14', DATE '2010-06-20', DATE '2010-06-15', DATE '2010-06-21', DATE '2010-06-09', DATE '2010-06-15', DATE '2010-06-10', DATE '2010-06-16', DATE '2010-06-11', DATE '2010-06-17', DATE '2010-06-12', DATE '2010-06-18', 1029, 3089, 13432, 13433, 13433, 13432, 13432, 13432, 13432, 2455363, 55362, N'2010-06-15', 201024, 24, 2, N'2010-W24', N'2010-W24-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94033, DATE '2010-06-16', DATE '2010-06-17', 2010, 20102, 201006, 2010167, 2, 6, 167, 16, 4, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-13', DATE '2010-06-19', DATE '2010-06-14', DATE '2010-06-20', DATE '2010-06-15', DATE '2010-06-21', DATE '2010-06-16', DATE '2010-06-22', DATE '2010-06-10', DATE '2010-06-16', DATE '2010-06-11', DATE '2010-06-17', DATE '2010-06-12', DATE '2010-06-18', 1029, 3089, 13432, 13433, 13433, 13433, 13432, 13432, 13432, 2455364, 55363, N'2010-06-16', 201024, 24, 3, N'2010-W24', N'2010-W24-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94034, DATE '2010-06-17', DATE '2010-06-18', 2010, 20102, 201006, 2010168, 2, 6, 168, 17, 5, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-13', DATE '2010-06-19', DATE '2010-06-14', DATE '2010-06-20', DATE '2010-06-15', DATE '2010-06-21', DATE '2010-06-16', DATE '2010-06-22', DATE '2010-06-17', DATE '2010-06-23', DATE '2010-06-11', DATE '2010-06-17', DATE '2010-06-12', DATE '2010-06-18', 1029, 3089, 13432, 13433, 13433, 13433, 13433, 13432, 13432, 2455365, 55364, N'2010-06-17', 201024, 24, 4, N'2010-W24', N'2010-W24-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94035, DATE '2010-06-18', DATE '2010-06-19', 2010, 20102, 201006, 2010169, 2, 6, 169, 18, 6, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-13', DATE '2010-06-19', DATE '2010-06-14', DATE '2010-06-20', DATE '2010-06-15', DATE '2010-06-21', DATE '2010-06-16', DATE '2010-06-22', DATE '2010-06-17', DATE '2010-06-23', DATE '2010-06-18', DATE '2010-06-24', DATE '2010-06-12', DATE '2010-06-18', 1029, 3089, 13432, 13433, 13433, 13433, 13433, 13433, 13432, 2455366, 55365, N'2010-06-18', 201024, 24, 5, N'2010-W24', N'2010-W24-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94036, DATE '2010-06-19', DATE '2010-06-20', 2010, 20102, 201006, 2010170, 2, 6, 170, 19, 7, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-13', DATE '2010-06-19', DATE '2010-06-14', DATE '2010-06-20', DATE '2010-06-15', DATE '2010-06-21', DATE '2010-06-16', DATE '2010-06-22', DATE '2010-06-17', DATE '2010-06-23', DATE '2010-06-18', DATE '2010-06-24', DATE '2010-06-19', DATE '2010-06-25', 1029, 3089, 13432, 13433, 13433, 13433, 13433, 13433, 13433, 2455367, 55366, N'2010-06-19', 201024, 24, 6, N'2010-W24', N'2010-W24-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94037, DATE '2010-06-20', DATE '2010-06-21', 2010, 20102, 201006, 2010171, 2, 6, 171, 20, 1, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-20', DATE '2010-06-26', DATE '2010-06-14', DATE '2010-06-20', DATE '2010-06-15', DATE '2010-06-21', DATE '2010-06-16', DATE '2010-06-22', DATE '2010-06-17', DATE '2010-06-23', DATE '2010-06-18', DATE '2010-06-24', DATE '2010-06-19', DATE '2010-06-25', 1029, 3089, 13433, 13433, 13433, 13433, 13433, 13433, 13433, 2455368, 55367, N'2010-06-20', 201024, 24, 7, N'2010-W24', N'2010-W24-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94038, DATE '2010-06-21', DATE '2010-06-22', 2010, 20102, 201006, 2010172, 2, 6, 172, 21, 2, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-20', DATE '2010-06-26', DATE '2010-06-21', DATE '2010-06-27', DATE '2010-06-15', DATE '2010-06-21', DATE '2010-06-16', DATE '2010-06-22', DATE '2010-06-17', DATE '2010-06-23', DATE '2010-06-18', DATE '2010-06-24', DATE '2010-06-19', DATE '2010-06-25', 1029, 3089, 13433, 13434, 13433, 13433, 13433, 13433, 13433, 2455369, 55368, N'2010-06-21', 201025, 25, 1, N'2010-W25', N'2010-W25-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94039, DATE '2010-06-22', DATE '2010-06-23', 2010, 20102, 201006, 2010173, 2, 6, 173, 22, 3, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-20', DATE '2010-06-26', DATE '2010-06-21', DATE '2010-06-27', DATE '2010-06-22', DATE '2010-06-28', DATE '2010-06-16', DATE '2010-06-22', DATE '2010-06-17', DATE '2010-06-23', DATE '2010-06-18', DATE '2010-06-24', DATE '2010-06-19', DATE '2010-06-25', 1029, 3089, 13433, 13434, 13434, 13433, 13433, 13433, 13433, 2455370, 55369, N'2010-06-22', 201025, 25, 2, N'2010-W25', N'2010-W25-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94040, DATE '2010-06-23', DATE '2010-06-24', 2010, 20102, 201006, 2010174, 2, 6, 174, 23, 4, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-20', DATE '2010-06-26', DATE '2010-06-21', DATE '2010-06-27', DATE '2010-06-22', DATE '2010-06-28', DATE '2010-06-23', DATE '2010-06-29', DATE '2010-06-17', DATE '2010-06-23', DATE '2010-06-18', DATE '2010-06-24', DATE '2010-06-19', DATE '2010-06-25', 1029, 3089, 13433, 13434, 13434, 13434, 13433, 13433, 13433, 2455371, 55370, N'2010-06-23', 201025, 25, 3, N'2010-W25', N'2010-W25-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94041, DATE '2010-06-24', DATE '2010-06-25', 2010, 20102, 201006, 2010175, 2, 6, 175, 24, 5, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-20', DATE '2010-06-26', DATE '2010-06-21', DATE '2010-06-27', DATE '2010-06-22', DATE '2010-06-28', DATE '2010-06-23', DATE '2010-06-29', DATE '2010-06-24', DATE '2010-06-30', DATE '2010-06-18', DATE '2010-06-24', DATE '2010-06-19', DATE '2010-06-25', 1029, 3089, 13433, 13434, 13434, 13434, 13434, 13433, 13433, 2455372, 55371, N'2010-06-24', 201025, 25, 4, N'2010-W25', N'2010-W25-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94042, DATE '2010-06-25', DATE '2010-06-26', 2010, 20102, 201006, 2010176, 2, 6, 176, 25, 6, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-20', DATE '2010-06-26', DATE '2010-06-21', DATE '2010-06-27', DATE '2010-06-22', DATE '2010-06-28', DATE '2010-06-23', DATE '2010-06-29', DATE '2010-06-24', DATE '2010-06-30', DATE '2010-06-25', DATE '2010-07-01', DATE '2010-06-19', DATE '2010-06-25', 1029, 3089, 13433, 13434, 13434, 13434, 13434, 13434, 13433, 2455373, 55372, N'2010-06-25', 201025, 25, 5, N'2010-W25', N'2010-W25-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94043, DATE '2010-06-26', DATE '2010-06-27', 2010, 20102, 201006, 2010177, 2, 6, 177, 26, 7, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-20', DATE '2010-06-26', DATE '2010-06-21', DATE '2010-06-27', DATE '2010-06-22', DATE '2010-06-28', DATE '2010-06-23', DATE '2010-06-29', DATE '2010-06-24', DATE '2010-06-30', DATE '2010-06-25', DATE '2010-07-01', DATE '2010-06-26', DATE '2010-07-02', 1029, 3089, 13433, 13434, 13434, 13434, 13434, 13434, 13434, 2455374, 55373, N'2010-06-26', 201025, 25, 6, N'2010-W25', N'2010-W25-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94044, DATE '2010-06-27', DATE '2010-06-28', 2010, 20102, 201006, 2010178, 2, 6, 178, 27, 1, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-27', DATE '2010-07-03', DATE '2010-06-21', DATE '2010-06-27', DATE '2010-06-22', DATE '2010-06-28', DATE '2010-06-23', DATE '2010-06-29', DATE '2010-06-24', DATE '2010-06-30', DATE '2010-06-25', DATE '2010-07-01', DATE '2010-06-26', DATE '2010-07-02', 1029, 3089, 13434, 13434, 13434, 13434, 13434, 13434, 13434, 2455375, 55374, N'2010-06-27', 201025, 25, 7, N'2010-W25', N'2010-W25-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94045, DATE '2010-06-28', DATE '2010-06-29', 2010, 20102, 201006, 2010179, 2, 6, 179, 28, 2, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-27', DATE '2010-07-03', DATE '2010-06-28', DATE '2010-07-04', DATE '2010-06-22', DATE '2010-06-28', DATE '2010-06-23', DATE '2010-06-29', DATE '2010-06-24', DATE '2010-06-30', DATE '2010-06-25', DATE '2010-07-01', DATE '2010-06-26', DATE '2010-07-02', 1029, 3089, 13434, 13435, 13434, 13434, 13434, 13434, 13434, 2455376, 55375, N'2010-06-28', 201026, 26, 1, N'2010-W26', N'2010-W26-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94046, DATE '2010-06-29', DATE '2010-06-30', 2010, 20102, 201006, 2010180, 2, 6, 180, 29, 3, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-27', DATE '2010-07-03', DATE '2010-06-28', DATE '2010-07-04', DATE '2010-06-29', DATE '2010-07-05', DATE '2010-06-23', DATE '2010-06-29', DATE '2010-06-24', DATE '2010-06-30', DATE '2010-06-25', DATE '2010-07-01', DATE '2010-06-26', DATE '2010-07-02', 1029, 3089, 13434, 13435, 13435, 13434, 13434, 13434, 13434, 2455377, 55376, N'2010-06-29', 201026, 26, 2, N'2010-W26', N'2010-W26-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94047, DATE '2010-06-30', DATE '2010-07-01', 2010, 20102, 201006, 2010181, 2, 6, 181, 30, 4, N'2010', N'2010 Q2', N'2010 Jun', N'Jun', N'June', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-04-01', DATE '2010-06-30', DATE '2010-06-01', DATE '2010-06-30', DATE '2010-06-27', DATE '2010-07-03', DATE '2010-06-28', DATE '2010-07-04', DATE '2010-06-29', DATE '2010-07-05', DATE '2010-06-30', DATE '2010-07-06', DATE '2010-06-24', DATE '2010-06-30', DATE '2010-06-25', DATE '2010-07-01', DATE '2010-06-26', DATE '2010-07-02', 1029, 3089, 13434, 13435, 13435, 13435, 13434, 13434, 13434, 2455378, 55377, N'2010-06-30', 201026, 26, 3, N'2010-W26', N'2010-W26-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94048, DATE '2010-07-01', DATE '2010-07-02', 2010, 20103, 201007, 2010182, 3, 7, 182, 1, 5, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-06-27', DATE '2010-07-03', DATE '2010-06-28', DATE '2010-07-04', DATE '2010-06-29', DATE '2010-07-05', DATE '2010-06-30', DATE '2010-07-06', DATE '2010-07-01', DATE '2010-07-07', DATE '2010-06-25', DATE '2010-07-01', DATE '2010-06-26', DATE '2010-07-02', 1030, 3090, 13434, 13435, 13435, 13435, 13435, 13434, 13434, 2455379, 55378, N'2010-07-01', 201026, 26, 4, N'2010-W26', N'2010-W26-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94049, DATE '2010-07-02', DATE '2010-07-03', 2010, 20103, 201007, 2010183, 3, 7, 183, 2, 6, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-06-27', DATE '2010-07-03', DATE '2010-06-28', DATE '2010-07-04', DATE '2010-06-29', DATE '2010-07-05', DATE '2010-06-30', DATE '2010-07-06', DATE '2010-07-01', DATE '2010-07-07', DATE '2010-07-02', DATE '2010-07-08', DATE '2010-06-26', DATE '2010-07-02', 1030, 3090, 13434, 13435, 13435, 13435, 13435, 13435, 13434, 2455380, 55379, N'2010-07-02', 201026, 26, 5, N'2010-W26', N'2010-W26-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94050, DATE '2010-07-03', DATE '2010-07-04', 2010, 20103, 201007, 2010184, 3, 7, 184, 3, 7, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-06-27', DATE '2010-07-03', DATE '2010-06-28', DATE '2010-07-04', DATE '2010-06-29', DATE '2010-07-05', DATE '2010-06-30', DATE '2010-07-06', DATE '2010-07-01', DATE '2010-07-07', DATE '2010-07-02', DATE '2010-07-08', DATE '2010-07-03', DATE '2010-07-09', 1030, 3090, 13434, 13435, 13435, 13435, 13435, 13435, 13435, 2455381, 55380, N'2010-07-03', 201026, 26, 6, N'2010-W26', N'2010-W26-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94051, DATE '2010-07-04', DATE '2010-07-05', 2010, 20103, 201007, 2010185, 3, 7, 185, 4, 1, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-04', DATE '2010-07-10', DATE '2010-06-28', DATE '2010-07-04', DATE '2010-06-29', DATE '2010-07-05', DATE '2010-06-30', DATE '2010-07-06', DATE '2010-07-01', DATE '2010-07-07', DATE '2010-07-02', DATE '2010-07-08', DATE '2010-07-03', DATE '2010-07-09', 1030, 3090, 13435, 13435, 13435, 13435, 13435, 13435, 13435, 2455382, 55381, N'2010-07-04', 201026, 26, 7, N'2010-W26', N'2010-W26-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94052, DATE '2010-07-05', DATE '2010-07-06', 2010, 20103, 201007, 2010186, 3, 7, 186, 5, 2, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-04', DATE '2010-07-10', DATE '2010-07-05', DATE '2010-07-11', DATE '2010-06-29', DATE '2010-07-05', DATE '2010-06-30', DATE '2010-07-06', DATE '2010-07-01', DATE '2010-07-07', DATE '2010-07-02', DATE '2010-07-08', DATE '2010-07-03', DATE '2010-07-09', 1030, 3090, 13435, 13436, 13435, 13435, 13435, 13435, 13435, 2455383, 55382, N'2010-07-05', 201027, 27, 1, N'2010-W27', N'2010-W27-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94053, DATE '2010-07-06', DATE '2010-07-07', 2010, 20103, 201007, 2010187, 3, 7, 187, 6, 3, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-04', DATE '2010-07-10', DATE '2010-07-05', DATE '2010-07-11', DATE '2010-07-06', DATE '2010-07-12', DATE '2010-06-30', DATE '2010-07-06', DATE '2010-07-01', DATE '2010-07-07', DATE '2010-07-02', DATE '2010-07-08', DATE '2010-07-03', DATE '2010-07-09', 1030, 3090, 13435, 13436, 13436, 13435, 13435, 13435, 13435, 2455384, 55383, N'2010-07-06', 201027, 27, 2, N'2010-W27', N'2010-W27-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94054, DATE '2010-07-07', DATE '2010-07-08', 2010, 20103, 201007, 2010188, 3, 7, 188, 7, 4, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-04', DATE '2010-07-10', DATE '2010-07-05', DATE '2010-07-11', DATE '2010-07-06', DATE '2010-07-12', DATE '2010-07-07', DATE '2010-07-13', DATE '2010-07-01', DATE '2010-07-07', DATE '2010-07-02', DATE '2010-07-08', DATE '2010-07-03', DATE '2010-07-09', 1030, 3090, 13435, 13436, 13436, 13436, 13435, 13435, 13435, 2455385, 55384, N'2010-07-07', 201027, 27, 3, N'2010-W27', N'2010-W27-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94055, DATE '2010-07-08', DATE '2010-07-09', 2010, 20103, 201007, 2010189, 3, 7, 189, 8, 5, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-04', DATE '2010-07-10', DATE '2010-07-05', DATE '2010-07-11', DATE '2010-07-06', DATE '2010-07-12', DATE '2010-07-07', DATE '2010-07-13', DATE '2010-07-08', DATE '2010-07-14', DATE '2010-07-02', DATE '2010-07-08', DATE '2010-07-03', DATE '2010-07-09', 1030, 3090, 13435, 13436, 13436, 13436, 13436, 13435, 13435, 2455386, 55385, N'2010-07-08', 201027, 27, 4, N'2010-W27', N'2010-W27-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94056, DATE '2010-07-09', DATE '2010-07-10', 2010, 20103, 201007, 2010190, 3, 7, 190, 9, 6, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-04', DATE '2010-07-10', DATE '2010-07-05', DATE '2010-07-11', DATE '2010-07-06', DATE '2010-07-12', DATE '2010-07-07', DATE '2010-07-13', DATE '2010-07-08', DATE '2010-07-14', DATE '2010-07-09', DATE '2010-07-15', DATE '2010-07-03', DATE '2010-07-09', 1030, 3090, 13435, 13436, 13436, 13436, 13436, 13436, 13435, 2455387, 55386, N'2010-07-09', 201027, 27, 5, N'2010-W27', N'2010-W27-5');

INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94057, DATE '2010-07-10', DATE '2010-07-11', 2010, 20103, 201007, 2010191, 3, 7, 191, 10, 7, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-04', DATE '2010-07-10', DATE '2010-07-05', DATE '2010-07-11', DATE '2010-07-06', DATE '2010-07-12', DATE '2010-07-07', DATE '2010-07-13', DATE '2010-07-08', DATE '2010-07-14', DATE '2010-07-09', DATE '2010-07-15', DATE '2010-07-10', DATE '2010-07-16', 1030, 3090, 13435, 13436, 13436, 13436, 13436, 13436, 13436, 2455388, 55387, N'2010-07-10', 201027, 27, 6, N'2010-W27', N'2010-W27-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94058, DATE '2010-07-11', DATE '2010-07-12', 2010, 20103, 201007, 2010192, 3, 7, 192, 11, 1, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-11', DATE '2010-07-17', DATE '2010-07-05', DATE '2010-07-11', DATE '2010-07-06', DATE '2010-07-12', DATE '2010-07-07', DATE '2010-07-13', DATE '2010-07-08', DATE '2010-07-14', DATE '2010-07-09', DATE '2010-07-15', DATE '2010-07-10', DATE '2010-07-16', 1030, 3090, 13436, 13436, 13436, 13436, 13436, 13436, 13436, 2455389, 55388, N'2010-07-11', 201027, 27, 7, N'2010-W27', N'2010-W27-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94059, DATE '2010-07-12', DATE '2010-07-13', 2010, 20103, 201007, 2010193, 3, 7, 193, 12, 2, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-11', DATE '2010-07-17', DATE '2010-07-12', DATE '2010-07-18', DATE '2010-07-06', DATE '2010-07-12', DATE '2010-07-07', DATE '2010-07-13', DATE '2010-07-08', DATE '2010-07-14', DATE '2010-07-09', DATE '2010-07-15', DATE '2010-07-10', DATE '2010-07-16', 1030, 3090, 13436, 13437, 13436, 13436, 13436, 13436, 13436, 2455390, 55389, N'2010-07-12', 201028, 28, 1, N'2010-W28', N'2010-W28-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94060, DATE '2010-07-13', DATE '2010-07-14', 2010, 20103, 201007, 2010194, 3, 7, 194, 13, 3, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-11', DATE '2010-07-17', DATE '2010-07-12', DATE '2010-07-18', DATE '2010-07-13', DATE '2010-07-19', DATE '2010-07-07', DATE '2010-07-13', DATE '2010-07-08', DATE '2010-07-14', DATE '2010-07-09', DATE '2010-07-15', DATE '2010-07-10', DATE '2010-07-16', 1030, 3090, 13436, 13437, 13437, 13436, 13436, 13436, 13436, 2455391, 55390, N'2010-07-13', 201028, 28, 2, N'2010-W28', N'2010-W28-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94061, DATE '2010-07-14', DATE '2010-07-15', 2010, 20103, 201007, 2010195, 3, 7, 195, 14, 4, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-11', DATE '2010-07-17', DATE '2010-07-12', DATE '2010-07-18', DATE '2010-07-13', DATE '2010-07-19', DATE '2010-07-14', DATE '2010-07-20', DATE '2010-07-08', DATE '2010-07-14', DATE '2010-07-09', DATE '2010-07-15', DATE '2010-07-10', DATE '2010-07-16', 1030, 3090, 13436, 13437, 13437, 13437, 13436, 13436, 13436, 2455392, 55391, N'2010-07-14', 201028, 28, 3, N'2010-W28', N'2010-W28-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94062, DATE '2010-07-15', DATE '2010-07-16', 2010, 20103, 201007, 2010196, 3, 7, 196, 15, 5, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-11', DATE '2010-07-17', DATE '2010-07-12', DATE '2010-07-18', DATE '2010-07-13', DATE '2010-07-19', DATE '2010-07-14', DATE '2010-07-20', DATE '2010-07-15', DATE '2010-07-21', DATE '2010-07-09', DATE '2010-07-15', DATE '2010-07-10', DATE '2010-07-16', 1030, 3090, 13436, 13437, 13437, 13437, 13437, 13436, 13436, 2455393, 55392, N'2010-07-15', 201028, 28, 4, N'2010-W28', N'2010-W28-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94063, DATE '2010-07-16', DATE '2010-07-17', 2010, 20103, 201007, 2010197, 3, 7, 197, 16, 6, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-11', DATE '2010-07-17', DATE '2010-07-12', DATE '2010-07-18', DATE '2010-07-13', DATE '2010-07-19', DATE '2010-07-14', DATE '2010-07-20', DATE '2010-07-15', DATE '2010-07-21', DATE '2010-07-16', DATE '2010-07-22', DATE '2010-07-10', DATE '2010-07-16', 1030, 3090, 13436, 13437, 13437, 13437, 13437, 13437, 13436, 2455394, 55393, N'2010-07-16', 201028, 28, 5, N'2010-W28', N'2010-W28-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94064, DATE '2010-07-17', DATE '2010-07-18', 2010, 20103, 201007, 2010198, 3, 7, 198, 17, 7, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-11', DATE '2010-07-17', DATE '2010-07-12', DATE '2010-07-18', DATE '2010-07-13', DATE '2010-07-19', DATE '2010-07-14', DATE '2010-07-20', DATE '2010-07-15', DATE '2010-07-21', DATE '2010-07-16', DATE '2010-07-22', DATE '2010-07-17', DATE '2010-07-23', 1030, 3090, 13436, 13437, 13437, 13437, 13437, 13437, 13437, 2455395, 55394, N'2010-07-17', 201028, 28, 6, N'2010-W28', N'2010-W28-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94065, DATE '2010-07-18', DATE '2010-07-19', 2010, 20103, 201007, 2010199, 3, 7, 199, 18, 1, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-18', DATE '2010-07-24', DATE '2010-07-12', DATE '2010-07-18', DATE '2010-07-13', DATE '2010-07-19', DATE '2010-07-14', DATE '2010-07-20', DATE '2010-07-15', DATE '2010-07-21', DATE '2010-07-16', DATE '2010-07-22', DATE '2010-07-17', DATE '2010-07-23', 1030, 3090, 13437, 13437, 13437, 13437, 13437, 13437, 13437, 2455396, 55395, N'2010-07-18', 201028, 28, 7, N'2010-W28', N'2010-W28-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94066, DATE '2010-07-19', DATE '2010-07-20', 2010, 20103, 201007, 2010200, 3, 7, 200, 19, 2, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-18', DATE '2010-07-24', DATE '2010-07-19', DATE '2010-07-25', DATE '2010-07-13', DATE '2010-07-19', DATE '2010-07-14', DATE '2010-07-20', DATE '2010-07-15', DATE '2010-07-21', DATE '2010-07-16', DATE '2010-07-22', DATE '2010-07-17', DATE '2010-07-23', 1030, 3090, 13437, 13438, 13437, 13437, 13437, 13437, 13437, 2455397, 55396, N'2010-07-19', 201029, 29, 1, N'2010-W29', N'2010-W29-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94067, DATE '2010-07-20', DATE '2010-07-21', 2010, 20103, 201007, 2010201, 3, 7, 201, 20, 3, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-18', DATE '2010-07-24', DATE '2010-07-19', DATE '2010-07-25', DATE '2010-07-20', DATE '2010-07-26', DATE '2010-07-14', DATE '2010-07-20', DATE '2010-07-15', DATE '2010-07-21', DATE '2010-07-16', DATE '2010-07-22', DATE '2010-07-17', DATE '2010-07-23', 1030, 3090, 13437, 13438, 13438, 13437, 13437, 13437, 13437, 2455398, 55397, N'2010-07-20', 201029, 29, 2, N'2010-W29', N'2010-W29-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94068, DATE '2010-07-21', DATE '2010-07-22', 2010, 20103, 201007, 2010202, 3, 7, 202, 21, 4, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-18', DATE '2010-07-24', DATE '2010-07-19', DATE '2010-07-25', DATE '2010-07-20', DATE '2010-07-26', DATE '2010-07-21', DATE '2010-07-27', DATE '2010-07-15', DATE '2010-07-21', DATE '2010-07-16', DATE '2010-07-22', DATE '2010-07-17', DATE '2010-07-23', 1030, 3090, 13437, 13438, 13438, 13438, 13437, 13437, 13437, 2455399, 55398, N'2010-07-21', 201029, 29, 3, N'2010-W29', N'2010-W29-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94069, DATE '2010-07-22', DATE '2010-07-23', 2010, 20103, 201007, 2010203, 3, 7, 203, 22, 5, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-18', DATE '2010-07-24', DATE '2010-07-19', DATE '2010-07-25', DATE '2010-07-20', DATE '2010-07-26', DATE '2010-07-21', DATE '2010-07-27', DATE '2010-07-22', DATE '2010-07-28', DATE '2010-07-16', DATE '2010-07-22', DATE '2010-07-17', DATE '2010-07-23', 1030, 3090, 13437, 13438, 13438, 13438, 13438, 13437, 13437, 2455400, 55399, N'2010-07-22', 201029, 29, 4, N'2010-W29', N'2010-W29-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94070, DATE '2010-07-23', DATE '2010-07-24', 2010, 20103, 201007, 2010204, 3, 7, 204, 23, 6, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-18', DATE '2010-07-24', DATE '2010-07-19', DATE '2010-07-25', DATE '2010-07-20', DATE '2010-07-26', DATE '2010-07-21', DATE '2010-07-27', DATE '2010-07-22', DATE '2010-07-28', DATE '2010-07-23', DATE '2010-07-29', DATE '2010-07-17', DATE '2010-07-23', 1030, 3090, 13437, 13438, 13438, 13438, 13438, 13438, 13437, 2455401, 55400, N'2010-07-23', 201029, 29, 5, N'2010-W29', N'2010-W29-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94071, DATE '2010-07-24', DATE '2010-07-25', 2010, 20103, 201007, 2010205, 3, 7, 205, 24, 7, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-18', DATE '2010-07-24', DATE '2010-07-19', DATE '2010-07-25', DATE '2010-07-20', DATE '2010-07-26', DATE '2010-07-21', DATE '2010-07-27', DATE '2010-07-22', DATE '2010-07-28', DATE '2010-07-23', DATE '2010-07-29', DATE '2010-07-24', DATE '2010-07-30', 1030, 3090, 13437, 13438, 13438, 13438, 13438, 13438, 13438, 2455402, 55401, N'2010-07-24', 201029, 29, 6, N'2010-W29', N'2010-W29-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94072, DATE '2010-07-25', DATE '2010-07-26', 2010, 20103, 201007, 2010206, 3, 7, 206, 25, 1, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-25', DATE '2010-07-31', DATE '2010-07-19', DATE '2010-07-25', DATE '2010-07-20', DATE '2010-07-26', DATE '2010-07-21', DATE '2010-07-27', DATE '2010-07-22', DATE '2010-07-28', DATE '2010-07-23', DATE '2010-07-29', DATE '2010-07-24', DATE '2010-07-30', 1030, 3090, 13438, 13438, 13438, 13438, 13438, 13438, 13438, 2455403, 55402, N'2010-07-25', 201029, 29, 7, N'2010-W29', N'2010-W29-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94073, DATE '2010-07-26', DATE '2010-07-27', 2010, 20103, 201007, 2010207, 3, 7, 207, 26, 2, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-25', DATE '2010-07-31', DATE '2010-07-26', DATE '2010-08-01', DATE '2010-07-20', DATE '2010-07-26', DATE '2010-07-21', DATE '2010-07-27', DATE '2010-07-22', DATE '2010-07-28', DATE '2010-07-23', DATE '2010-07-29', DATE '2010-07-24', DATE '2010-07-30', 1030, 3090, 13438, 13439, 13438, 13438, 13438, 13438, 13438, 2455404, 55403, N'2010-07-26', 201030, 30, 1, N'2010-W30', N'2010-W30-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94074, DATE '2010-07-27', DATE '2010-07-28', 2010, 20103, 201007, 2010208, 3, 7, 208, 27, 3, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-25', DATE '2010-07-31', DATE '2010-07-26', DATE '2010-08-01', DATE '2010-07-27', DATE '2010-08-02', DATE '2010-07-21', DATE '2010-07-27', DATE '2010-07-22', DATE '2010-07-28', DATE '2010-07-23', DATE '2010-07-29', DATE '2010-07-24', DATE '2010-07-30', 1030, 3090, 13438, 13439, 13439, 13438, 13438, 13438, 13438, 2455405, 55404, N'2010-07-27', 201030, 30, 2, N'2010-W30', N'2010-W30-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94075, DATE '2010-07-28', DATE '2010-07-29', 2010, 20103, 201007, 2010209, 3, 7, 209, 28, 4, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-25', DATE '2010-07-31', DATE '2010-07-26', DATE '2010-08-01', DATE '2010-07-27', DATE '2010-08-02', DATE '2010-07-28', DATE '2010-08-03', DATE '2010-07-22', DATE '2010-07-28', DATE '2010-07-23', DATE '2010-07-29', DATE '2010-07-24', DATE '2010-07-30', 1030, 3090, 13438, 13439, 13439, 13439, 13438, 13438, 13438, 2455406, 55405, N'2010-07-28', 201030, 30, 3, N'2010-W30', N'2010-W30-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94076, DATE '2010-07-29', DATE '2010-07-30', 2010, 20103, 201007, 2010210, 3, 7, 210, 29, 5, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-25', DATE '2010-07-31', DATE '2010-07-26', DATE '2010-08-01', DATE '2010-07-27', DATE '2010-08-02', DATE '2010-07-28', DATE '2010-08-03', DATE '2010-07-29', DATE '2010-08-04', DATE '2010-07-23', DATE '2010-07-29', DATE '2010-07-24', DATE '2010-07-30', 1030, 3090, 13438, 13439, 13439, 13439, 13439, 13438, 13438, 2455407, 55406, N'2010-07-29', 201030, 30, 4, N'2010-W30', N'2010-W30-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94077, DATE '2010-07-30', DATE '2010-07-31', 2010, 20103, 201007, 2010211, 3, 7, 211, 30, 6, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-25', DATE '2010-07-31', DATE '2010-07-26', DATE '2010-08-01', DATE '2010-07-27', DATE '2010-08-02', DATE '2010-07-28', DATE '2010-08-03', DATE '2010-07-29', DATE '2010-08-04', DATE '2010-07-30', DATE '2010-08-05', DATE '2010-07-24', DATE '2010-07-30', 1030, 3090, 13438, 13439, 13439, 13439, 13439, 13439, 13438, 2455408, 55407, N'2010-07-30', 201030, 30, 5, N'2010-W30', N'2010-W30-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94078, DATE '2010-07-31', DATE '2010-08-01', 2010, 20103, 201007, 2010212, 3, 7, 212, 31, 7, N'2010', N'2010 Q3', N'2010 Jul', N'Jul', N'July', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-07-01', DATE '2010-07-31', DATE '2010-07-25', DATE '2010-07-31', DATE '2010-07-26', DATE '2010-08-01', DATE '2010-07-27', DATE '2010-08-02', DATE '2010-07-28', DATE '2010-08-03', DATE '2010-07-29', DATE '2010-08-04', DATE '2010-07-30', DATE '2010-08-05', DATE '2010-07-31', DATE '2010-08-06', 1030, 3090, 13438, 13439, 13439, 13439, 13439, 13439, 13439, 2455409, 55408, N'2010-07-31', 201030, 30, 6, N'2010-W30', N'2010-W30-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94079, DATE '2010-08-01', DATE '2010-08-02', 2010, 20103, 201008, 2010213, 3, 8, 213, 1, 1, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-01', DATE '2010-08-07', DATE '2010-07-26', DATE '2010-08-01', DATE '2010-07-27', DATE '2010-08-02', DATE '2010-07-28', DATE '2010-08-03', DATE '2010-07-29', DATE '2010-08-04', DATE '2010-07-30', DATE '2010-08-05', DATE '2010-07-31', DATE '2010-08-06', 1030, 3091, 13439, 13439, 13439, 13439, 13439, 13439, 13439, 2455410, 55409, N'2010-08-01', 201030, 30, 7, N'2010-W30', N'2010-W30-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94080, DATE '2010-08-02', DATE '2010-08-03', 2010, 20103, 201008, 2010214, 3, 8, 214, 2, 2, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-01', DATE '2010-08-07', DATE '2010-08-02', DATE '2010-08-08', DATE '2010-07-27', DATE '2010-08-02', DATE '2010-07-28', DATE '2010-08-03', DATE '2010-07-29', DATE '2010-08-04', DATE '2010-07-30', DATE '2010-08-05', DATE '2010-07-31', DATE '2010-08-06', 1030, 3091, 13439, 13440, 13439, 13439, 13439, 13439, 13439, 2455411, 55410, N'2010-08-02', 201031, 31, 1, N'2010-W31', N'2010-W31-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94081, DATE '2010-08-03', DATE '2010-08-04', 2010, 20103, 201008, 2010215, 3, 8, 215, 3, 3, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-01', DATE '2010-08-07', DATE '2010-08-02', DATE '2010-08-08', DATE '2010-08-03', DATE '2010-08-09', DATE '2010-07-28', DATE '2010-08-03', DATE '2010-07-29', DATE '2010-08-04', DATE '2010-07-30', DATE '2010-08-05', DATE '2010-07-31', DATE '2010-08-06', 1030, 3091, 13439, 13440, 13440, 13439, 13439, 13439, 13439, 2455412, 55411, N'2010-08-03', 201031, 31, 2, N'2010-W31', N'2010-W31-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94082, DATE '2010-08-04', DATE '2010-08-05', 2010, 20103, 201008, 2010216, 3, 8, 216, 4, 4, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-01', DATE '2010-08-07', DATE '2010-08-02', DATE '2010-08-08', DATE '2010-08-03', DATE '2010-08-09', DATE '2010-08-04', DATE '2010-08-10', DATE '2010-07-29', DATE '2010-08-04', DATE '2010-07-30', DATE '2010-08-05', DATE '2010-07-31', DATE '2010-08-06', 1030, 3091, 13439, 13440, 13440, 13440, 13439, 13439, 13439, 2455413, 55412, N'2010-08-04', 201031, 31, 3, N'2010-W31', N'2010-W31-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94083, DATE '2010-08-05', DATE '2010-08-06', 2010, 20103, 201008, 2010217, 3, 8, 217, 5, 5, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-01', DATE '2010-08-07', DATE '2010-08-02', DATE '2010-08-08', DATE '2010-08-03', DATE '2010-08-09', DATE '2010-08-04', DATE '2010-08-10', DATE '2010-08-05', DATE '2010-08-11', DATE '2010-07-30', DATE '2010-08-05', DATE '2010-07-31', DATE '2010-08-06', 1030, 3091, 13439, 13440, 13440, 13440, 13440, 13439, 13439, 2455414, 55413, N'2010-08-05', 201031, 31, 4, N'2010-W31', N'2010-W31-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94084, DATE '2010-08-06', DATE '2010-08-07', 2010, 20103, 201008, 2010218, 3, 8, 218, 6, 6, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-01', DATE '2010-08-07', DATE '2010-08-02', DATE '2010-08-08', DATE '2010-08-03', DATE '2010-08-09', DATE '2010-08-04', DATE '2010-08-10', DATE '2010-08-05', DATE '2010-08-11', DATE '2010-08-06', DATE '2010-08-12', DATE '2010-07-31', DATE '2010-08-06', 1030, 3091, 13439, 13440, 13440, 13440, 13440, 13440, 13439, 2455415, 55414, N'2010-08-06', 201031, 31, 5, N'2010-W31', N'2010-W31-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94085, DATE '2010-08-07', DATE '2010-08-08', 2010, 20103, 201008, 2010219, 3, 8, 219, 7, 7, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-01', DATE '2010-08-07', DATE '2010-08-02', DATE '2010-08-08', DATE '2010-08-03', DATE '2010-08-09', DATE '2010-08-04', DATE '2010-08-10', DATE '2010-08-05', DATE '2010-08-11', DATE '2010-08-06', DATE '2010-08-12', DATE '2010-08-07', DATE '2010-08-13', 1030, 3091, 13439, 13440, 13440, 13440, 13440, 13440, 13440, 2455416, 55415, N'2010-08-07', 201031, 31, 6, N'2010-W31', N'2010-W31-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94086, DATE '2010-08-08', DATE '2010-08-09', 2010, 20103, 201008, 2010220, 3, 8, 220, 8, 1, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-08', DATE '2010-08-14', DATE '2010-08-02', DATE '2010-08-08', DATE '2010-08-03', DATE '2010-08-09', DATE '2010-08-04', DATE '2010-08-10', DATE '2010-08-05', DATE '2010-08-11', DATE '2010-08-06', DATE '2010-08-12', DATE '2010-08-07', DATE '2010-08-13', 1030, 3091, 13440, 13440, 13440, 13440, 13440, 13440, 13440, 2455417, 55416, N'2010-08-08', 201031, 31, 7, N'2010-W31', N'2010-W31-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94087, DATE '2010-08-09', DATE '2010-08-10', 2010, 20103, 201008, 2010221, 3, 8, 221, 9, 2, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-08', DATE '2010-08-14', DATE '2010-08-09', DATE '2010-08-15', DATE '2010-08-03', DATE '2010-08-09', DATE '2010-08-04', DATE '2010-08-10', DATE '2010-08-05', DATE '2010-08-11', DATE '2010-08-06', DATE '2010-08-12', DATE '2010-08-07', DATE '2010-08-13', 1030, 3091, 13440, 13441, 13440, 13440, 13440, 13440, 13440, 2455418, 55417, N'2010-08-09', 201032, 32, 1, N'2010-W32', N'2010-W32-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94088, DATE '2010-08-10', DATE '2010-08-11', 2010, 20103, 201008, 2010222, 3, 8, 222, 10, 3, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-08', DATE '2010-08-14', DATE '2010-08-09', DATE '2010-08-15', DATE '2010-08-10', DATE '2010-08-16', DATE '2010-08-04', DATE '2010-08-10', DATE '2010-08-05', DATE '2010-08-11', DATE '2010-08-06', DATE '2010-08-12', DATE '2010-08-07', DATE '2010-08-13', 1030, 3091, 13440, 13441, 13441, 13440, 13440, 13440, 13440, 2455419, 55418, N'2010-08-10', 201032, 32, 2, N'2010-W32', N'2010-W32-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94089, DATE '2010-08-11', DATE '2010-08-12', 2010, 20103, 201008, 2010223, 3, 8, 223, 11, 4, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-08', DATE '2010-08-14', DATE '2010-08-09', DATE '2010-08-15', DATE '2010-08-10', DATE '2010-08-16', DATE '2010-08-11', DATE '2010-08-17', DATE '2010-08-05', DATE '2010-08-11', DATE '2010-08-06', DATE '2010-08-12', DATE '2010-08-07', DATE '2010-08-13', 1030, 3091, 13440, 13441, 13441, 13441, 13440, 13440, 13440, 2455420, 55419, N'2010-08-11', 201032, 32, 3, N'2010-W32', N'2010-W32-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94090, DATE '2010-08-12', DATE '2010-08-13', 2010, 20103, 201008, 2010224, 3, 8, 224, 12, 5, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-08', DATE '2010-08-14', DATE '2010-08-09', DATE '2010-08-15', DATE '2010-08-10', DATE '2010-08-16', DATE '2010-08-11', DATE '2010-08-17', DATE '2010-08-12', DATE '2010-08-18', DATE '2010-08-06', DATE '2010-08-12', DATE '2010-08-07', DATE '2010-08-13', 1030, 3091, 13440, 13441, 13441, 13441, 13441, 13440, 13440, 2455421, 55420, N'2010-08-12', 201032, 32, 4, N'2010-W32', N'2010-W32-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94091, DATE '2010-08-13', DATE '2010-08-14', 2010, 20103, 201008, 2010225, 3, 8, 225, 13, 6, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-08', DATE '2010-08-14', DATE '2010-08-09', DATE '2010-08-15', DATE '2010-08-10', DATE '2010-08-16', DATE '2010-08-11', DATE '2010-08-17', DATE '2010-08-12', DATE '2010-08-18', DATE '2010-08-13', DATE '2010-08-19', DATE '2010-08-07', DATE '2010-08-13', 1030, 3091, 13440, 13441, 13441, 13441, 13441, 13441, 13440, 2455422, 55421, N'2010-08-13', 201032, 32, 5, N'2010-W32', N'2010-W32-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94092, DATE '2010-08-14', DATE '2010-08-15', 2010, 20103, 201008, 2010226, 3, 8, 226, 14, 7, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-08', DATE '2010-08-14', DATE '2010-08-09', DATE '2010-08-15', DATE '2010-08-10', DATE '2010-08-16', DATE '2010-08-11', DATE '2010-08-17', DATE '2010-08-12', DATE '2010-08-18', DATE '2010-08-13', DATE '2010-08-19', DATE '2010-08-14', DATE '2010-08-20', 1030, 3091, 13440, 13441, 13441, 13441, 13441, 13441, 13441, 2455423, 55422, N'2010-08-14', 201032, 32, 6, N'2010-W32', N'2010-W32-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94093, DATE '2010-08-15', DATE '2010-08-16', 2010, 20103, 201008, 2010227, 3, 8, 227, 15, 1, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-15', DATE '2010-08-21', DATE '2010-08-09', DATE '2010-08-15', DATE '2010-08-10', DATE '2010-08-16', DATE '2010-08-11', DATE '2010-08-17', DATE '2010-08-12', DATE '2010-08-18', DATE '2010-08-13', DATE '2010-08-19', DATE '2010-08-14', DATE '2010-08-20', 1030, 3091, 13441, 13441, 13441, 13441, 13441, 13441, 13441, 2455424, 55423, N'2010-08-15', 201032, 32, 7, N'2010-W32', N'2010-W32-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94094, DATE '2010-08-16', DATE '2010-08-17', 2010, 20103, 201008, 2010228, 3, 8, 228, 16, 2, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-15', DATE '2010-08-21', DATE '2010-08-16', DATE '2010-08-22', DATE '2010-08-10', DATE '2010-08-16', DATE '2010-08-11', DATE '2010-08-17', DATE '2010-08-12', DATE '2010-08-18', DATE '2010-08-13', DATE '2010-08-19', DATE '2010-08-14', DATE '2010-08-20', 1030, 3091, 13441, 13442, 13441, 13441, 13441, 13441, 13441, 2455425, 55424, N'2010-08-16', 201033, 33, 1, N'2010-W33', N'2010-W33-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94095, DATE '2010-08-17', DATE '2010-08-18', 2010, 20103, 201008, 2010229, 3, 8, 229, 17, 3, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-15', DATE '2010-08-21', DATE '2010-08-16', DATE '2010-08-22', DATE '2010-08-17', DATE '2010-08-23', DATE '2010-08-11', DATE '2010-08-17', DATE '2010-08-12', DATE '2010-08-18', DATE '2010-08-13', DATE '2010-08-19', DATE '2010-08-14', DATE '2010-08-20', 1030, 3091, 13441, 13442, 13442, 13441, 13441, 13441, 13441, 2455426, 55425, N'2010-08-17', 201033, 33, 2, N'2010-W33', N'2010-W33-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94096, DATE '2010-08-18', DATE '2010-08-19', 2010, 20103, 201008, 2010230, 3, 8, 230, 18, 4, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-15', DATE '2010-08-21', DATE '2010-08-16', DATE '2010-08-22', DATE '2010-08-17', DATE '2010-08-23', DATE '2010-08-18', DATE '2010-08-24', DATE '2010-08-12', DATE '2010-08-18', DATE '2010-08-13', DATE '2010-08-19', DATE '2010-08-14', DATE '2010-08-20', 1030, 3091, 13441, 13442, 13442, 13442, 13441, 13441, 13441, 2455427, 55426, N'2010-08-18', 201033, 33, 3, N'2010-W33', N'2010-W33-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94097, DATE '2010-08-19', DATE '2010-08-20', 2010, 20103, 201008, 2010231, 3, 8, 231, 19, 5, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-15', DATE '2010-08-21', DATE '2010-08-16', DATE '2010-08-22', DATE '2010-08-17', DATE '2010-08-23', DATE '2010-08-18', DATE '2010-08-24', DATE '2010-08-19', DATE '2010-08-25', DATE '2010-08-13', DATE '2010-08-19', DATE '2010-08-14', DATE '2010-08-20', 1030, 3091, 13441, 13442, 13442, 13442, 13442, 13441, 13441, 2455428, 55427, N'2010-08-19', 201033, 33, 4, N'2010-W33', N'2010-W33-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94098, DATE '2010-08-20', DATE '2010-08-21', 2010, 20103, 201008, 2010232, 3, 8, 232, 20, 6, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-15', DATE '2010-08-21', DATE '2010-08-16', DATE '2010-08-22', DATE '2010-08-17', DATE '2010-08-23', DATE '2010-08-18', DATE '2010-08-24', DATE '2010-08-19', DATE '2010-08-25', DATE '2010-08-20', DATE '2010-08-26', DATE '2010-08-14', DATE '2010-08-20', 1030, 3091, 13441, 13442, 13442, 13442, 13442, 13442, 13441, 2455429, 55428, N'2010-08-20', 201033, 33, 5, N'2010-W33', N'2010-W33-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94099, DATE '2010-08-21', DATE '2010-08-22', 2010, 20103, 201008, 2010233, 3, 8, 233, 21, 7, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-15', DATE '2010-08-21', DATE '2010-08-16', DATE '2010-08-22', DATE '2010-08-17', DATE '2010-08-23', DATE '2010-08-18', DATE '2010-08-24', DATE '2010-08-19', DATE '2010-08-25', DATE '2010-08-20', DATE '2010-08-26', DATE '2010-08-21', DATE '2010-08-27', 1030, 3091, 13441, 13442, 13442, 13442, 13442, 13442, 13442, 2455430, 55429, N'2010-08-21', 201033, 33, 6, N'2010-W33', N'2010-W33-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94100, DATE '2010-08-22', DATE '2010-08-23', 2010, 20103, 201008, 2010234, 3, 8, 234, 22, 1, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-22', DATE '2010-08-28', DATE '2010-08-16', DATE '2010-08-22', DATE '2010-08-17', DATE '2010-08-23', DATE '2010-08-18', DATE '2010-08-24', DATE '2010-08-19', DATE '2010-08-25', DATE '2010-08-20', DATE '2010-08-26', DATE '2010-08-21', DATE '2010-08-27', 1030, 3091, 13442, 13442, 13442, 13442, 13442, 13442, 13442, 2455431, 55430, N'2010-08-22', 201033, 33, 7, N'2010-W33', N'2010-W33-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94101, DATE '2010-08-23', DATE '2010-08-24', 2010, 20103, 201008, 2010235, 3, 8, 235, 23, 2, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-22', DATE '2010-08-28', DATE '2010-08-23', DATE '2010-08-29', DATE '2010-08-17', DATE '2010-08-23', DATE '2010-08-18', DATE '2010-08-24', DATE '2010-08-19', DATE '2010-08-25', DATE '2010-08-20', DATE '2010-08-26', DATE '2010-08-21', DATE '2010-08-27', 1030, 3091, 13442, 13443, 13442, 13442, 13442, 13442, 13442, 2455432, 55431, N'2010-08-23', 201034, 34, 1, N'2010-W34', N'2010-W34-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94102, DATE '2010-08-24', DATE '2010-08-25', 2010, 20103, 201008, 2010236, 3, 8, 236, 24, 3, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-22', DATE '2010-08-28', DATE '2010-08-23', DATE '2010-08-29', DATE '2010-08-24', DATE '2010-08-30', DATE '2010-08-18', DATE '2010-08-24', DATE '2010-08-19', DATE '2010-08-25', DATE '2010-08-20', DATE '2010-08-26', DATE '2010-08-21', DATE '2010-08-27', 1030, 3091, 13442, 13443, 13443, 13442, 13442, 13442, 13442, 2455433, 55432, N'2010-08-24', 201034, 34, 2, N'2010-W34', N'2010-W34-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94103, DATE '2010-08-25', DATE '2010-08-26', 2010, 20103, 201008, 2010237, 3, 8, 237, 25, 4, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-22', DATE '2010-08-28', DATE '2010-08-23', DATE '2010-08-29', DATE '2010-08-24', DATE '2010-08-30', DATE '2010-08-25', DATE '2010-08-31', DATE '2010-08-19', DATE '2010-08-25', DATE '2010-08-20', DATE '2010-08-26', DATE '2010-08-21', DATE '2010-08-27', 1030, 3091, 13442, 13443, 13443, 13443, 13442, 13442, 13442, 2455434, 55433, N'2010-08-25', 201034, 34, 3, N'2010-W34', N'2010-W34-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94104, DATE '2010-08-26', DATE '2010-08-27', 2010, 20103, 201008, 2010238, 3, 8, 238, 26, 5, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-22', DATE '2010-08-28', DATE '2010-08-23', DATE '2010-08-29', DATE '2010-08-24', DATE '2010-08-30', DATE '2010-08-25', DATE '2010-08-31', DATE '2010-08-26', DATE '2010-09-01', DATE '2010-08-20', DATE '2010-08-26', DATE '2010-08-21', DATE '2010-08-27', 1030, 3091, 13442, 13443, 13443, 13443, 13443, 13442, 13442, 2455435, 55434, N'2010-08-26', 201034, 34, 4, N'2010-W34', N'2010-W34-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94105, DATE '2010-08-27', DATE '2010-08-28', 2010, 20103, 201008, 2010239, 3, 8, 239, 27, 6, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-22', DATE '2010-08-28', DATE '2010-08-23', DATE '2010-08-29', DATE '2010-08-24', DATE '2010-08-30', DATE '2010-08-25', DATE '2010-08-31', DATE '2010-08-26', DATE '2010-09-01', DATE '2010-08-27', DATE '2010-09-02', DATE '2010-08-21', DATE '2010-08-27', 1030, 3091, 13442, 13443, 13443, 13443, 13443, 13443, 13442, 2455436, 55435, N'2010-08-27', 201034, 34, 5, N'2010-W34', N'2010-W34-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94106, DATE '2010-08-28', DATE '2010-08-29', 2010, 20103, 201008, 2010240, 3, 8, 240, 28, 7, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-22', DATE '2010-08-28', DATE '2010-08-23', DATE '2010-08-29', DATE '2010-08-24', DATE '2010-08-30', DATE '2010-08-25', DATE '2010-08-31', DATE '2010-08-26', DATE '2010-09-01', DATE '2010-08-27', DATE '2010-09-02', DATE '2010-08-28', DATE '2010-09-03', 1030, 3091, 13442, 13443, 13443, 13443, 13443, 13443, 13443, 2455437, 55436, N'2010-08-28', 201034, 34, 6, N'2010-W34', N'2010-W34-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94107, DATE '2010-08-29', DATE '2010-08-30', 2010, 20103, 201008, 2010241, 3, 8, 241, 29, 1, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-29', DATE '2010-09-04', DATE '2010-08-23', DATE '2010-08-29', DATE '2010-08-24', DATE '2010-08-30', DATE '2010-08-25', DATE '2010-08-31', DATE '2010-08-26', DATE '2010-09-01', DATE '2010-08-27', DATE '2010-09-02', DATE '2010-08-28', DATE '2010-09-03', 1030, 3091, 13443, 13443, 13443, 13443, 13443, 13443, 13443, 2455438, 55437, N'2010-08-29', 201034, 34, 7, N'2010-W34', N'2010-W34-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94108, DATE '2010-08-30', DATE '2010-08-31', 2010, 20103, 201008, 2010242, 3, 8, 242, 30, 2, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-29', DATE '2010-09-04', DATE '2010-08-30', DATE '2010-09-05', DATE '2010-08-24', DATE '2010-08-30', DATE '2010-08-25', DATE '2010-08-31', DATE '2010-08-26', DATE '2010-09-01', DATE '2010-08-27', DATE '2010-09-02', DATE '2010-08-28', DATE '2010-09-03', 1030, 3091, 13443, 13444, 13443, 13443, 13443, 13443, 13443, 2455439, 55438, N'2010-08-30', 201035, 35, 1, N'2010-W35', N'2010-W35-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94109, DATE '2010-08-31', DATE '2010-09-01', 2010, 20103, 201008, 2010243, 3, 8, 243, 31, 3, N'2010', N'2010 Q3', N'2010 Aug', N'Aug', N'August', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-08-01', DATE '2010-08-31', DATE '2010-08-29', DATE '2010-09-04', DATE '2010-08-30', DATE '2010-09-05', DATE '2010-08-31', DATE '2010-09-06', DATE '2010-08-25', DATE '2010-08-31', DATE '2010-08-26', DATE '2010-09-01', DATE '2010-08-27', DATE '2010-09-02', DATE '2010-08-28', DATE '2010-09-03', 1030, 3091, 13443, 13444, 13444, 13443, 13443, 13443, 13443, 2455440, 55439, N'2010-08-31', 201035, 35, 2, N'2010-W35', N'2010-W35-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94110, DATE '2010-09-01', DATE '2010-09-02', 2010, 20103, 201009, 2010244, 3, 9, 244, 1, 4, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-08-29', DATE '2010-09-04', DATE '2010-08-30', DATE '2010-09-05', DATE '2010-08-31', DATE '2010-09-06', DATE '2010-09-01', DATE '2010-09-07', DATE '2010-08-26', DATE '2010-09-01', DATE '2010-08-27', DATE '2010-09-02', DATE '2010-08-28', DATE '2010-09-03', 1030, 3092, 13443, 13444, 13444, 13444, 13443, 13443, 13443, 2455441, 55440, N'2010-09-01', 201035, 35, 3, N'2010-W35', N'2010-W35-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94111, DATE '2010-09-02', DATE '2010-09-03', 2010, 20103, 201009, 2010245, 3, 9, 245, 2, 5, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-08-29', DATE '2010-09-04', DATE '2010-08-30', DATE '2010-09-05', DATE '2010-08-31', DATE '2010-09-06', DATE '2010-09-01', DATE '2010-09-07', DATE '2010-09-02', DATE '2010-09-08', DATE '2010-08-27', DATE '2010-09-02', DATE '2010-08-28', DATE '2010-09-03', 1030, 3092, 13443, 13444, 13444, 13444, 13444, 13443, 13443, 2455442, 55441, N'2010-09-02', 201035, 35, 4, N'2010-W35', N'2010-W35-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94112, DATE '2010-09-03', DATE '2010-09-04', 2010, 20103, 201009, 2010246, 3, 9, 246, 3, 6, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-08-29', DATE '2010-09-04', DATE '2010-08-30', DATE '2010-09-05', DATE '2010-08-31', DATE '2010-09-06', DATE '2010-09-01', DATE '2010-09-07', DATE '2010-09-02', DATE '2010-09-08', DATE '2010-09-03', DATE '2010-09-09', DATE '2010-08-28', DATE '2010-09-03', 1030, 3092, 13443, 13444, 13444, 13444, 13444, 13444, 13443, 2455443, 55442, N'2010-09-03', 201035, 35, 5, N'2010-W35', N'2010-W35-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94113, DATE '2010-09-04', DATE '2010-09-05', 2010, 20103, 201009, 2010247, 3, 9, 247, 4, 7, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-08-29', DATE '2010-09-04', DATE '2010-08-30', DATE '2010-09-05', DATE '2010-08-31', DATE '2010-09-06', DATE '2010-09-01', DATE '2010-09-07', DATE '2010-09-02', DATE '2010-09-08', DATE '2010-09-03', DATE '2010-09-09', DATE '2010-09-04', DATE '2010-09-10', 1030, 3092, 13443, 13444, 13444, 13444, 13444, 13444, 13444, 2455444, 55443, N'2010-09-04', 201035, 35, 6, N'2010-W35', N'2010-W35-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94114, DATE '2010-09-05', DATE '2010-09-06', 2010, 20103, 201009, 2010248, 3, 9, 248, 5, 1, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-05', DATE '2010-09-11', DATE '2010-08-30', DATE '2010-09-05', DATE '2010-08-31', DATE '2010-09-06', DATE '2010-09-01', DATE '2010-09-07', DATE '2010-09-02', DATE '2010-09-08', DATE '2010-09-03', DATE '2010-09-09', DATE '2010-09-04', DATE '2010-09-10', 1030, 3092, 13444, 13444, 13444, 13444, 13444, 13444, 13444, 2455445, 55444, N'2010-09-05', 201035, 35, 7, N'2010-W35', N'2010-W35-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94115, DATE '2010-09-06', DATE '2010-09-07', 2010, 20103, 201009, 2010249, 3, 9, 249, 6, 2, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-05', DATE '2010-09-11', DATE '2010-09-06', DATE '2010-09-12', DATE '2010-08-31', DATE '2010-09-06', DATE '2010-09-01', DATE '2010-09-07', DATE '2010-09-02', DATE '2010-09-08', DATE '2010-09-03', DATE '2010-09-09', DATE '2010-09-04', DATE '2010-09-10', 1030, 3092, 13444, 13445, 13444, 13444, 13444, 13444, 13444, 2455446, 55445, N'2010-09-06', 201036, 36, 1, N'2010-W36', N'2010-W36-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94116, DATE '2010-09-07', DATE '2010-09-08', 2010, 20103, 201009, 2010250, 3, 9, 250, 7, 3, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-05', DATE '2010-09-11', DATE '2010-09-06', DATE '2010-09-12', DATE '2010-09-07', DATE '2010-09-13', DATE '2010-09-01', DATE '2010-09-07', DATE '2010-09-02', DATE '2010-09-08', DATE '2010-09-03', DATE '2010-09-09', DATE '2010-09-04', DATE '2010-09-10', 1030, 3092, 13444, 13445, 13445, 13444, 13444, 13444, 13444, 2455447, 55446, N'2010-09-07', 201036, 36, 2, N'2010-W36', N'2010-W36-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94117, DATE '2010-09-08', DATE '2010-09-09', 2010, 20103, 201009, 2010251, 3, 9, 251, 8, 4, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-05', DATE '2010-09-11', DATE '2010-09-06', DATE '2010-09-12', DATE '2010-09-07', DATE '2010-09-13', DATE '2010-09-08', DATE '2010-09-14', DATE '2010-09-02', DATE '2010-09-08', DATE '2010-09-03', DATE '2010-09-09', DATE '2010-09-04', DATE '2010-09-10', 1030, 3092, 13444, 13445, 13445, 13445, 13444, 13444, 13444, 2455448, 55447, N'2010-09-08', 201036, 36, 3, N'2010-W36', N'2010-W36-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94118, DATE '2010-09-09', DATE '2010-09-10', 2010, 20103, 201009, 2010252, 3, 9, 252, 9, 5, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-05', DATE '2010-09-11', DATE '2010-09-06', DATE '2010-09-12', DATE '2010-09-07', DATE '2010-09-13', DATE '2010-09-08', DATE '2010-09-14', DATE '2010-09-09', DATE '2010-09-15', DATE '2010-09-03', DATE '2010-09-09', DATE '2010-09-04', DATE '2010-09-10', 1030, 3092, 13444, 13445, 13445, 13445, 13445, 13444, 13444, 2455449, 55448, N'2010-09-09', 201036, 36, 4, N'2010-W36', N'2010-W36-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94119, DATE '2010-09-10', DATE '2010-09-11', 2010, 20103, 201009, 2010253, 3, 9, 253, 10, 6, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-05', DATE '2010-09-11', DATE '2010-09-06', DATE '2010-09-12', DATE '2010-09-07', DATE '2010-09-13', DATE '2010-09-08', DATE '2010-09-14', DATE '2010-09-09', DATE '2010-09-15', DATE '2010-09-10', DATE '2010-09-16', DATE '2010-09-04', DATE '2010-09-10', 1030, 3092, 13444, 13445, 13445, 13445, 13445, 13445, 13444, 2455450, 55449, N'2010-09-10', 201036, 36, 5, N'2010-W36', N'2010-W36-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94120, DATE '2010-09-11', DATE '2010-09-12', 2010, 20103, 201009, 2010254, 3, 9, 254, 11, 7, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-05', DATE '2010-09-11', DATE '2010-09-06', DATE '2010-09-12', DATE '2010-09-07', DATE '2010-09-13', DATE '2010-09-08', DATE '2010-09-14', DATE '2010-09-09', DATE '2010-09-15', DATE '2010-09-10', DATE '2010-09-16', DATE '2010-09-11', DATE '2010-09-17', 1030, 3092, 13444, 13445, 13445, 13445, 13445, 13445, 13445, 2455451, 55450, N'2010-09-11', 201036, 36, 6, N'2010-W36', N'2010-W36-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94121, DATE '2010-09-12', DATE '2010-09-13', 2010, 20103, 201009, 2010255, 3, 9, 255, 12, 1, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-12', DATE '2010-09-18', DATE '2010-09-06', DATE '2010-09-12', DATE '2010-09-07', DATE '2010-09-13', DATE '2010-09-08', DATE '2010-09-14', DATE '2010-09-09', DATE '2010-09-15', DATE '2010-09-10', DATE '2010-09-16', DATE '2010-09-11', DATE '2010-09-17', 1030, 3092, 13445, 13445, 13445, 13445, 13445, 13445, 13445, 2455452, 55451, N'2010-09-12', 201036, 36, 7, N'2010-W36', N'2010-W36-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94122, DATE '2010-09-13', DATE '2010-09-14', 2010, 20103, 201009, 2010256, 3, 9, 256, 13, 2, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-12', DATE '2010-09-18', DATE '2010-09-13', DATE '2010-09-19', DATE '2010-09-07', DATE '2010-09-13', DATE '2010-09-08', DATE '2010-09-14', DATE '2010-09-09', DATE '2010-09-15', DATE '2010-09-10', DATE '2010-09-16', DATE '2010-09-11', DATE '2010-09-17', 1030, 3092, 13445, 13446, 13445, 13445, 13445, 13445, 13445, 2455453, 55452, N'2010-09-13', 201037, 37, 1, N'2010-W37', N'2010-W37-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94123, DATE '2010-09-14', DATE '2010-09-15', 2010, 20103, 201009, 2010257, 3, 9, 257, 14, 3, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-12', DATE '2010-09-18', DATE '2010-09-13', DATE '2010-09-19', DATE '2010-09-14', DATE '2010-09-20', DATE '2010-09-08', DATE '2010-09-14', DATE '2010-09-09', DATE '2010-09-15', DATE '2010-09-10', DATE '2010-09-16', DATE '2010-09-11', DATE '2010-09-17', 1030, 3092, 13445, 13446, 13446, 13445, 13445, 13445, 13445, 2455454, 55453, N'2010-09-14', 201037, 37, 2, N'2010-W37', N'2010-W37-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94124, DATE '2010-09-15', DATE '2010-09-16', 2010, 20103, 201009, 2010258, 3, 9, 258, 15, 4, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-12', DATE '2010-09-18', DATE '2010-09-13', DATE '2010-09-19', DATE '2010-09-14', DATE '2010-09-20', DATE '2010-09-15', DATE '2010-09-21', DATE '2010-09-09', DATE '2010-09-15', DATE '2010-09-10', DATE '2010-09-16', DATE '2010-09-11', DATE '2010-09-17', 1030, 3092, 13445, 13446, 13446, 13446, 13445, 13445, 13445, 2455455, 55454, N'2010-09-15', 201037, 37, 3, N'2010-W37', N'2010-W37-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94125, DATE '2010-09-16', DATE '2010-09-17', 2010, 20103, 201009, 2010259, 3, 9, 259, 16, 5, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-12', DATE '2010-09-18', DATE '2010-09-13', DATE '2010-09-19', DATE '2010-09-14', DATE '2010-09-20', DATE '2010-09-15', DATE '2010-09-21', DATE '2010-09-16', DATE '2010-09-22', DATE '2010-09-10', DATE '2010-09-16', DATE '2010-09-11', DATE '2010-09-17', 1030, 3092, 13445, 13446, 13446, 13446, 13446, 13445, 13445, 2455456, 55455, N'2010-09-16', 201037, 37, 4, N'2010-W37', N'2010-W37-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94126, DATE '2010-09-17', DATE '2010-09-18', 2010, 20103, 201009, 2010260, 3, 9, 260, 17, 6, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-12', DATE '2010-09-18', DATE '2010-09-13', DATE '2010-09-19', DATE '2010-09-14', DATE '2010-09-20', DATE '2010-09-15', DATE '2010-09-21', DATE '2010-09-16', DATE '2010-09-22', DATE '2010-09-17', DATE '2010-09-23', DATE '2010-09-11', DATE '2010-09-17', 1030, 3092, 13445, 13446, 13446, 13446, 13446, 13446, 13445, 2455457, 55456, N'2010-09-17', 201037, 37, 5, N'2010-W37', N'2010-W37-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94127, DATE '2010-09-18', DATE '2010-09-19', 2010, 20103, 201009, 2010261, 3, 9, 261, 18, 7, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-12', DATE '2010-09-18', DATE '2010-09-13', DATE '2010-09-19', DATE '2010-09-14', DATE '2010-09-20', DATE '2010-09-15', DATE '2010-09-21', DATE '2010-09-16', DATE '2010-09-22', DATE '2010-09-17', DATE '2010-09-23', DATE '2010-09-18', DATE '2010-09-24', 1030, 3092, 13445, 13446, 13446, 13446, 13446, 13446, 13446, 2455458, 55457, N'2010-09-18', 201037, 37, 6, N'2010-W37', N'2010-W37-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94128, DATE '2010-09-19', DATE '2010-09-20', 2010, 20103, 201009, 2010262, 3, 9, 262, 19, 1, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-19', DATE '2010-09-25', DATE '2010-09-13', DATE '2010-09-19', DATE '2010-09-14', DATE '2010-09-20', DATE '2010-09-15', DATE '2010-09-21', DATE '2010-09-16', DATE '2010-09-22', DATE '2010-09-17', DATE '2010-09-23', DATE '2010-09-18', DATE '2010-09-24', 1030, 3092, 13446, 13446, 13446, 13446, 13446, 13446, 13446, 2455459, 55458, N'2010-09-19', 201037, 37, 7, N'2010-W37', N'2010-W37-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94129, DATE '2010-09-20', DATE '2010-09-21', 2010, 20103, 201009, 2010263, 3, 9, 263, 20, 2, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-19', DATE '2010-09-25', DATE '2010-09-20', DATE '2010-09-26', DATE '2010-09-14', DATE '2010-09-20', DATE '2010-09-15', DATE '2010-09-21', DATE '2010-09-16', DATE '2010-09-22', DATE '2010-09-17', DATE '2010-09-23', DATE '2010-09-18', DATE '2010-09-24', 1030, 3092, 13446, 13447, 13446, 13446, 13446, 13446, 13446, 2455460, 55459, N'2010-09-20', 201038, 38, 1, N'2010-W38', N'2010-W38-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94130, DATE '2010-09-21', DATE '2010-09-22', 2010, 20103, 201009, 2010264, 3, 9, 264, 21, 3, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-19', DATE '2010-09-25', DATE '2010-09-20', DATE '2010-09-26', DATE '2010-09-21', DATE '2010-09-27', DATE '2010-09-15', DATE '2010-09-21', DATE '2010-09-16', DATE '2010-09-22', DATE '2010-09-17', DATE '2010-09-23', DATE '2010-09-18', DATE '2010-09-24', 1030, 3092, 13446, 13447, 13447, 13446, 13446, 13446, 13446, 2455461, 55460, N'2010-09-21', 201038, 38, 2, N'2010-W38', N'2010-W38-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94131, DATE '2010-09-22', DATE '2010-09-23', 2010, 20103, 201009, 2010265, 3, 9, 265, 22, 4, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-19', DATE '2010-09-25', DATE '2010-09-20', DATE '2010-09-26', DATE '2010-09-21', DATE '2010-09-27', DATE '2010-09-22', DATE '2010-09-28', DATE '2010-09-16', DATE '2010-09-22', DATE '2010-09-17', DATE '2010-09-23', DATE '2010-09-18', DATE '2010-09-24', 1030, 3092, 13446, 13447, 13447, 13447, 13446, 13446, 13446, 2455462, 55461, N'2010-09-22', 201038, 38, 3, N'2010-W38', N'2010-W38-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94132, DATE '2010-09-23', DATE '2010-09-24', 2010, 20103, 201009, 2010266, 3, 9, 266, 23, 5, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-19', DATE '2010-09-25', DATE '2010-09-20', DATE '2010-09-26', DATE '2010-09-21', DATE '2010-09-27', DATE '2010-09-22', DATE '2010-09-28', DATE '2010-09-23', DATE '2010-09-29', DATE '2010-09-17', DATE '2010-09-23', DATE '2010-09-18', DATE '2010-09-24', 1030, 3092, 13446, 13447, 13447, 13447, 13447, 13446, 13446, 2455463, 55462, N'2010-09-23', 201038, 38, 4, N'2010-W38', N'2010-W38-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94133, DATE '2010-09-24', DATE '2010-09-25', 2010, 20103, 201009, 2010267, 3, 9, 267, 24, 6, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-19', DATE '2010-09-25', DATE '2010-09-20', DATE '2010-09-26', DATE '2010-09-21', DATE '2010-09-27', DATE '2010-09-22', DATE '2010-09-28', DATE '2010-09-23', DATE '2010-09-29', DATE '2010-09-24', DATE '2010-09-30', DATE '2010-09-18', DATE '2010-09-24', 1030, 3092, 13446, 13447, 13447, 13447, 13447, 13447, 13446, 2455464, 55463, N'2010-09-24', 201038, 38, 5, N'2010-W38', N'2010-W38-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94134, DATE '2010-09-25', DATE '2010-09-26', 2010, 20103, 201009, 2010268, 3, 9, 268, 25, 7, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-19', DATE '2010-09-25', DATE '2010-09-20', DATE '2010-09-26', DATE '2010-09-21', DATE '2010-09-27', DATE '2010-09-22', DATE '2010-09-28', DATE '2010-09-23', DATE '2010-09-29', DATE '2010-09-24', DATE '2010-09-30', DATE '2010-09-25', DATE '2010-10-01', 1030, 3092, 13446, 13447, 13447, 13447, 13447, 13447, 13447, 2455465, 55464, N'2010-09-25', 201038, 38, 6, N'2010-W38', N'2010-W38-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94135, DATE '2010-09-26', DATE '2010-09-27', 2010, 20103, 201009, 2010269, 3, 9, 269, 26, 1, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-26', DATE '2010-10-02', DATE '2010-09-20', DATE '2010-09-26', DATE '2010-09-21', DATE '2010-09-27', DATE '2010-09-22', DATE '2010-09-28', DATE '2010-09-23', DATE '2010-09-29', DATE '2010-09-24', DATE '2010-09-30', DATE '2010-09-25', DATE '2010-10-01', 1030, 3092, 13447, 13447, 13447, 13447, 13447, 13447, 13447, 2455466, 55465, N'2010-09-26', 201038, 38, 7, N'2010-W38', N'2010-W38-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94136, DATE '2010-09-27', DATE '2010-09-28', 2010, 20103, 201009, 2010270, 3, 9, 270, 27, 2, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-26', DATE '2010-10-02', DATE '2010-09-27', DATE '2010-10-03', DATE '2010-09-21', DATE '2010-09-27', DATE '2010-09-22', DATE '2010-09-28', DATE '2010-09-23', DATE '2010-09-29', DATE '2010-09-24', DATE '2010-09-30', DATE '2010-09-25', DATE '2010-10-01', 1030, 3092, 13447, 13448, 13447, 13447, 13447, 13447, 13447, 2455467, 55466, N'2010-09-27', 201039, 39, 1, N'2010-W39', N'2010-W39-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94137, DATE '2010-09-28', DATE '2010-09-29', 2010, 20103, 201009, 2010271, 3, 9, 271, 28, 3, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-26', DATE '2010-10-02', DATE '2010-09-27', DATE '2010-10-03', DATE '2010-09-28', DATE '2010-10-04', DATE '2010-09-22', DATE '2010-09-28', DATE '2010-09-23', DATE '2010-09-29', DATE '2010-09-24', DATE '2010-09-30', DATE '2010-09-25', DATE '2010-10-01', 1030, 3092, 13447, 13448, 13448, 13447, 13447, 13447, 13447, 2455468, 55467, N'2010-09-28', 201039, 39, 2, N'2010-W39', N'2010-W39-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94138, DATE '2010-09-29', DATE '2010-09-30', 2010, 20103, 201009, 2010272, 3, 9, 272, 29, 4, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-26', DATE '2010-10-02', DATE '2010-09-27', DATE '2010-10-03', DATE '2010-09-28', DATE '2010-10-04', DATE '2010-09-29', DATE '2010-10-05', DATE '2010-09-23', DATE '2010-09-29', DATE '2010-09-24', DATE '2010-09-30', DATE '2010-09-25', DATE '2010-10-01', 1030, 3092, 13447, 13448, 13448, 13448, 13447, 13447, 13447, 2455469, 55468, N'2010-09-29', 201039, 39, 3, N'2010-W39', N'2010-W39-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94139, DATE '2010-09-30', DATE '2010-10-01', 2010, 20103, 201009, 2010273, 3, 9, 273, 30, 5, N'2010', N'2010 Q3', N'2010 Sep', N'Sep', N'September', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-07-01', DATE '2010-09-30', DATE '2010-09-01', DATE '2010-09-30', DATE '2010-09-26', DATE '2010-10-02', DATE '2010-09-27', DATE '2010-10-03', DATE '2010-09-28', DATE '2010-10-04', DATE '2010-09-29', DATE '2010-10-05', DATE '2010-09-30', DATE '2010-10-06', DATE '2010-09-24', DATE '2010-09-30', DATE '2010-09-25', DATE '2010-10-01', 1030, 3092, 13447, 13448, 13448, 13448, 13448, 13447, 13447, 2455470, 55469, N'2010-09-30', 201039, 39, 4, N'2010-W39', N'2010-W39-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94140, DATE '2010-10-01', DATE '2010-10-02', 2010, 20104, 201010, 2010274, 4, 10, 274, 1, 6, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-09-26', DATE '2010-10-02', DATE '2010-09-27', DATE '2010-10-03', DATE '2010-09-28', DATE '2010-10-04', DATE '2010-09-29', DATE '2010-10-05', DATE '2010-09-30', DATE '2010-10-06', DATE '2010-10-01', DATE '2010-10-07', DATE '2010-09-25', DATE '2010-10-01', 1031, 3093, 13447, 13448, 13448, 13448, 13448, 13448, 13447, 2455471, 55470, N'2010-10-01', 201039, 39, 5, N'2010-W39', N'2010-W39-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94141, DATE '2010-10-02', DATE '2010-10-03', 2010, 20104, 201010, 2010275, 4, 10, 275, 2, 7, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-09-26', DATE '2010-10-02', DATE '2010-09-27', DATE '2010-10-03', DATE '2010-09-28', DATE '2010-10-04', DATE '2010-09-29', DATE '2010-10-05', DATE '2010-09-30', DATE '2010-10-06', DATE '2010-10-01', DATE '2010-10-07', DATE '2010-10-02', DATE '2010-10-08', 1031, 3093, 13447, 13448, 13448, 13448, 13448, 13448, 13448, 2455472, 55471, N'2010-10-02', 201039, 39, 6, N'2010-W39', N'2010-W39-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94142, DATE '2010-10-03', DATE '2010-10-04', 2010, 20104, 201010, 2010276, 4, 10, 276, 3, 1, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-03', DATE '2010-10-09', DATE '2010-09-27', DATE '2010-10-03', DATE '2010-09-28', DATE '2010-10-04', DATE '2010-09-29', DATE '2010-10-05', DATE '2010-09-30', DATE '2010-10-06', DATE '2010-10-01', DATE '2010-10-07', DATE '2010-10-02', DATE '2010-10-08', 1031, 3093, 13448, 13448, 13448, 13448, 13448, 13448, 13448, 2455473, 55472, N'2010-10-03', 201039, 39, 7, N'2010-W39', N'2010-W39-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94143, DATE '2010-10-04', DATE '2010-10-05', 2010, 20104, 201010, 2010277, 4, 10, 277, 4, 2, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-03', DATE '2010-10-09', DATE '2010-10-04', DATE '2010-10-10', DATE '2010-09-28', DATE '2010-10-04', DATE '2010-09-29', DATE '2010-10-05', DATE '2010-09-30', DATE '2010-10-06', DATE '2010-10-01', DATE '2010-10-07', DATE '2010-10-02', DATE '2010-10-08', 1031, 3093, 13448, 13449, 13448, 13448, 13448, 13448, 13448, 2455474, 55473, N'2010-10-04', 201040, 40, 1, N'2010-W40', N'2010-W40-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94144, DATE '2010-10-05', DATE '2010-10-06', 2010, 20104, 201010, 2010278, 4, 10, 278, 5, 3, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-03', DATE '2010-10-09', DATE '2010-10-04', DATE '2010-10-10', DATE '2010-10-05', DATE '2010-10-11', DATE '2010-09-29', DATE '2010-10-05', DATE '2010-09-30', DATE '2010-10-06', DATE '2010-10-01', DATE '2010-10-07', DATE '2010-10-02', DATE '2010-10-08', 1031, 3093, 13448, 13449, 13449, 13448, 13448, 13448, 13448, 2455475, 55474, N'2010-10-05', 201040, 40, 2, N'2010-W40', N'2010-W40-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94145, DATE '2010-10-06', DATE '2010-10-07', 2010, 20104, 201010, 2010279, 4, 10, 279, 6, 4, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-03', DATE '2010-10-09', DATE '2010-10-04', DATE '2010-10-10', DATE '2010-10-05', DATE '2010-10-11', DATE '2010-10-06', DATE '2010-10-12', DATE '2010-09-30', DATE '2010-10-06', DATE '2010-10-01', DATE '2010-10-07', DATE '2010-10-02', DATE '2010-10-08', 1031, 3093, 13448, 13449, 13449, 13449, 13448, 13448, 13448, 2455476, 55475, N'2010-10-06', 201040, 40, 3, N'2010-W40', N'2010-W40-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94146, DATE '2010-10-07', DATE '2010-10-08', 2010, 20104, 201010, 2010280, 4, 10, 280, 7, 5, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-03', DATE '2010-10-09', DATE '2010-10-04', DATE '2010-10-10', DATE '2010-10-05', DATE '2010-10-11', DATE '2010-10-06', DATE '2010-10-12', DATE '2010-10-07', DATE '2010-10-13', DATE '2010-10-01', DATE '2010-10-07', DATE '2010-10-02', DATE '2010-10-08', 1031, 3093, 13448, 13449, 13449, 13449, 13449, 13448, 13448, 2455477, 55476, N'2010-10-07', 201040, 40, 4, N'2010-W40', N'2010-W40-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94147, DATE '2010-10-08', DATE '2010-10-09', 2010, 20104, 201010, 2010281, 4, 10, 281, 8, 6, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-03', DATE '2010-10-09', DATE '2010-10-04', DATE '2010-10-10', DATE '2010-10-05', DATE '2010-10-11', DATE '2010-10-06', DATE '2010-10-12', DATE '2010-10-07', DATE '2010-10-13', DATE '2010-10-08', DATE '2010-10-14', DATE '2010-10-02', DATE '2010-10-08', 1031, 3093, 13448, 13449, 13449, 13449, 13449, 13449, 13448, 2455478, 55477, N'2010-10-08', 201040, 40, 5, N'2010-W40', N'2010-W40-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94148, DATE '2010-10-09', DATE '2010-10-10', 2010, 20104, 201010, 2010282, 4, 10, 282, 9, 7, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-03', DATE '2010-10-09', DATE '2010-10-04', DATE '2010-10-10', DATE '2010-10-05', DATE '2010-10-11', DATE '2010-10-06', DATE '2010-10-12', DATE '2010-10-07', DATE '2010-10-13', DATE '2010-10-08', DATE '2010-10-14', DATE '2010-10-09', DATE '2010-10-15', 1031, 3093, 13448, 13449, 13449, 13449, 13449, 13449, 13449, 2455479, 55478, N'2010-10-09', 201040, 40, 6, N'2010-W40', N'2010-W40-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94149, DATE '2010-10-10', DATE '2010-10-11', 2010, 20104, 201010, 2010283, 4, 10, 283, 10, 1, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-10', DATE '2010-10-16', DATE '2010-10-04', DATE '2010-10-10', DATE '2010-10-05', DATE '2010-10-11', DATE '2010-10-06', DATE '2010-10-12', DATE '2010-10-07', DATE '2010-10-13', DATE '2010-10-08', DATE '2010-10-14', DATE '2010-10-09', DATE '2010-10-15', 1031, 3093, 13449, 13449, 13449, 13449, 13449, 13449, 13449, 2455480, 55479, N'2010-10-10', 201040, 40, 7, N'2010-W40', N'2010-W40-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94150, DATE '2010-10-11', DATE '2010-10-12', 2010, 20104, 201010, 2010284, 4, 10, 284, 11, 2, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-10', DATE '2010-10-16', DATE '2010-10-11', DATE '2010-10-17', DATE '2010-10-05', DATE '2010-10-11', DATE '2010-10-06', DATE '2010-10-12', DATE '2010-10-07', DATE '2010-10-13', DATE '2010-10-08', DATE '2010-10-14', DATE '2010-10-09', DATE '2010-10-15', 1031, 3093, 13449, 13450, 13449, 13449, 13449, 13449, 13449, 2455481, 55480, N'2010-10-11', 201041, 41, 1, N'2010-W41', N'2010-W41-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94151, DATE '2010-10-12', DATE '2010-10-13', 2010, 20104, 201010, 2010285, 4, 10, 285, 12, 3, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-10', DATE '2010-10-16', DATE '2010-10-11', DATE '2010-10-17', DATE '2010-10-12', DATE '2010-10-18', DATE '2010-10-06', DATE '2010-10-12', DATE '2010-10-07', DATE '2010-10-13', DATE '2010-10-08', DATE '2010-10-14', DATE '2010-10-09', DATE '2010-10-15', 1031, 3093, 13449, 13450, 13450, 13449, 13449, 13449, 13449, 2455482, 55481, N'2010-10-12', 201041, 41, 2, N'2010-W41', N'2010-W41-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94152, DATE '2010-10-13', DATE '2010-10-14', 2010, 20104, 201010, 2010286, 4, 10, 286, 13, 4, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-10', DATE '2010-10-16', DATE '2010-10-11', DATE '2010-10-17', DATE '2010-10-12', DATE '2010-10-18', DATE '2010-10-13', DATE '2010-10-19', DATE '2010-10-07', DATE '2010-10-13', DATE '2010-10-08', DATE '2010-10-14', DATE '2010-10-09', DATE '2010-10-15', 1031, 3093, 13449, 13450, 13450, 13450, 13449, 13449, 13449, 2455483, 55482, N'2010-10-13', 201041, 41, 3, N'2010-W41', N'2010-W41-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94153, DATE '2010-10-14', DATE '2010-10-15', 2010, 20104, 201010, 2010287, 4, 10, 287, 14, 5, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-10', DATE '2010-10-16', DATE '2010-10-11', DATE '2010-10-17', DATE '2010-10-12', DATE '2010-10-18', DATE '2010-10-13', DATE '2010-10-19', DATE '2010-10-14', DATE '2010-10-20', DATE '2010-10-08', DATE '2010-10-14', DATE '2010-10-09', DATE '2010-10-15', 1031, 3093, 13449, 13450, 13450, 13450, 13450, 13449, 13449, 2455484, 55483, N'2010-10-14', 201041, 41, 4, N'2010-W41', N'2010-W41-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94154, DATE '2010-10-15', DATE '2010-10-16', 2010, 20104, 201010, 2010288, 4, 10, 288, 15, 6, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-10', DATE '2010-10-16', DATE '2010-10-11', DATE '2010-10-17', DATE '2010-10-12', DATE '2010-10-18', DATE '2010-10-13', DATE '2010-10-19', DATE '2010-10-14', DATE '2010-10-20', DATE '2010-10-15', DATE '2010-10-21', DATE '2010-10-09', DATE '2010-10-15', 1031, 3093, 13449, 13450, 13450, 13450, 13450, 13450, 13449, 2455485, 55484, N'2010-10-15', 201041, 41, 5, N'2010-W41', N'2010-W41-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94155, DATE '2010-10-16', DATE '2010-10-17', 2010, 20104, 201010, 2010289, 4, 10, 289, 16, 7, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-10', DATE '2010-10-16', DATE '2010-10-11', DATE '2010-10-17', DATE '2010-10-12', DATE '2010-10-18', DATE '2010-10-13', DATE '2010-10-19', DATE '2010-10-14', DATE '2010-10-20', DATE '2010-10-15', DATE '2010-10-21', DATE '2010-10-16', DATE '2010-10-22', 1031, 3093, 13449, 13450, 13450, 13450, 13450, 13450, 13450, 2455486, 55485, N'2010-10-16', 201041, 41, 6, N'2010-W41', N'2010-W41-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94156, DATE '2010-10-17', DATE '2010-10-18', 2010, 20104, 201010, 2010290, 4, 10, 290, 17, 1, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-17', DATE '2010-10-23', DATE '2010-10-11', DATE '2010-10-17', DATE '2010-10-12', DATE '2010-10-18', DATE '2010-10-13', DATE '2010-10-19', DATE '2010-10-14', DATE '2010-10-20', DATE '2010-10-15', DATE '2010-10-21', DATE '2010-10-16', DATE '2010-10-22', 1031, 3093, 13450, 13450, 13450, 13450, 13450, 13450, 13450, 2455487, 55486, N'2010-10-17', 201041, 41, 7, N'2010-W41', N'2010-W41-7');

INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94157, DATE '2010-10-18', DATE '2010-10-19', 2010, 20104, 201010, 2010291, 4, 10, 291, 18, 2, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-17', DATE '2010-10-23', DATE '2010-10-18', DATE '2010-10-24', DATE '2010-10-12', DATE '2010-10-18', DATE '2010-10-13', DATE '2010-10-19', DATE '2010-10-14', DATE '2010-10-20', DATE '2010-10-15', DATE '2010-10-21', DATE '2010-10-16', DATE '2010-10-22', 1031, 3093, 13450, 13451, 13450, 13450, 13450, 13450, 13450, 2455488, 55487, N'2010-10-18', 201042, 42, 1, N'2010-W42', N'2010-W42-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94158, DATE '2010-10-19', DATE '2010-10-20', 2010, 20104, 201010, 2010292, 4, 10, 292, 19, 3, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-17', DATE '2010-10-23', DATE '2010-10-18', DATE '2010-10-24', DATE '2010-10-19', DATE '2010-10-25', DATE '2010-10-13', DATE '2010-10-19', DATE '2010-10-14', DATE '2010-10-20', DATE '2010-10-15', DATE '2010-10-21', DATE '2010-10-16', DATE '2010-10-22', 1031, 3093, 13450, 13451, 13451, 13450, 13450, 13450, 13450, 2455489, 55488, N'2010-10-19', 201042, 42, 2, N'2010-W42', N'2010-W42-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94159, DATE '2010-10-20', DATE '2010-10-21', 2010, 20104, 201010, 2010293, 4, 10, 293, 20, 4, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-17', DATE '2010-10-23', DATE '2010-10-18', DATE '2010-10-24', DATE '2010-10-19', DATE '2010-10-25', DATE '2010-10-20', DATE '2010-10-26', DATE '2010-10-14', DATE '2010-10-20', DATE '2010-10-15', DATE '2010-10-21', DATE '2010-10-16', DATE '2010-10-22', 1031, 3093, 13450, 13451, 13451, 13451, 13450, 13450, 13450, 2455490, 55489, N'2010-10-20', 201042, 42, 3, N'2010-W42', N'2010-W42-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94160, DATE '2010-10-21', DATE '2010-10-22', 2010, 20104, 201010, 2010294, 4, 10, 294, 21, 5, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-17', DATE '2010-10-23', DATE '2010-10-18', DATE '2010-10-24', DATE '2010-10-19', DATE '2010-10-25', DATE '2010-10-20', DATE '2010-10-26', DATE '2010-10-21', DATE '2010-10-27', DATE '2010-10-15', DATE '2010-10-21', DATE '2010-10-16', DATE '2010-10-22', 1031, 3093, 13450, 13451, 13451, 13451, 13451, 13450, 13450, 2455491, 55490, N'2010-10-21', 201042, 42, 4, N'2010-W42', N'2010-W42-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94161, DATE '2010-10-22', DATE '2010-10-23', 2010, 20104, 201010, 2010295, 4, 10, 295, 22, 6, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-17', DATE '2010-10-23', DATE '2010-10-18', DATE '2010-10-24', DATE '2010-10-19', DATE '2010-10-25', DATE '2010-10-20', DATE '2010-10-26', DATE '2010-10-21', DATE '2010-10-27', DATE '2010-10-22', DATE '2010-10-28', DATE '2010-10-16', DATE '2010-10-22', 1031, 3093, 13450, 13451, 13451, 13451, 13451, 13451, 13450, 2455492, 55491, N'2010-10-22', 201042, 42, 5, N'2010-W42', N'2010-W42-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94162, DATE '2010-10-23', DATE '2010-10-24', 2010, 20104, 201010, 2010296, 4, 10, 296, 23, 7, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-17', DATE '2010-10-23', DATE '2010-10-18', DATE '2010-10-24', DATE '2010-10-19', DATE '2010-10-25', DATE '2010-10-20', DATE '2010-10-26', DATE '2010-10-21', DATE '2010-10-27', DATE '2010-10-22', DATE '2010-10-28', DATE '2010-10-23', DATE '2010-10-29', 1031, 3093, 13450, 13451, 13451, 13451, 13451, 13451, 13451, 2455493, 55492, N'2010-10-23', 201042, 42, 6, N'2010-W42', N'2010-W42-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94163, DATE '2010-10-24', DATE '2010-10-25', 2010, 20104, 201010, 2010297, 4, 10, 297, 24, 1, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-24', DATE '2010-10-30', DATE '2010-10-18', DATE '2010-10-24', DATE '2010-10-19', DATE '2010-10-25', DATE '2010-10-20', DATE '2010-10-26', DATE '2010-10-21', DATE '2010-10-27', DATE '2010-10-22', DATE '2010-10-28', DATE '2010-10-23', DATE '2010-10-29', 1031, 3093, 13451, 13451, 13451, 13451, 13451, 13451, 13451, 2455494, 55493, N'2010-10-24', 201042, 42, 7, N'2010-W42', N'2010-W42-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94164, DATE '2010-10-25', DATE '2010-10-26', 2010, 20104, 201010, 2010298, 4, 10, 298, 25, 2, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-24', DATE '2010-10-30', DATE '2010-10-25', DATE '2010-10-31', DATE '2010-10-19', DATE '2010-10-25', DATE '2010-10-20', DATE '2010-10-26', DATE '2010-10-21', DATE '2010-10-27', DATE '2010-10-22', DATE '2010-10-28', DATE '2010-10-23', DATE '2010-10-29', 1031, 3093, 13451, 13452, 13451, 13451, 13451, 13451, 13451, 2455495, 55494, N'2010-10-25', 201043, 43, 1, N'2010-W43', N'2010-W43-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94165, DATE '2010-10-26', DATE '2010-10-27', 2010, 20104, 201010, 2010299, 4, 10, 299, 26, 3, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-24', DATE '2010-10-30', DATE '2010-10-25', DATE '2010-10-31', DATE '2010-10-26', DATE '2010-11-01', DATE '2010-10-20', DATE '2010-10-26', DATE '2010-10-21', DATE '2010-10-27', DATE '2010-10-22', DATE '2010-10-28', DATE '2010-10-23', DATE '2010-10-29', 1031, 3093, 13451, 13452, 13452, 13451, 13451, 13451, 13451, 2455496, 55495, N'2010-10-26', 201043, 43, 2, N'2010-W43', N'2010-W43-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94166, DATE '2010-10-27', DATE '2010-10-28', 2010, 20104, 201010, 2010300, 4, 10, 300, 27, 4, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-24', DATE '2010-10-30', DATE '2010-10-25', DATE '2010-10-31', DATE '2010-10-26', DATE '2010-11-01', DATE '2010-10-27', DATE '2010-11-02', DATE '2010-10-21', DATE '2010-10-27', DATE '2010-10-22', DATE '2010-10-28', DATE '2010-10-23', DATE '2010-10-29', 1031, 3093, 13451, 13452, 13452, 13452, 13451, 13451, 13451, 2455497, 55496, N'2010-10-27', 201043, 43, 3, N'2010-W43', N'2010-W43-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94167, DATE '2010-10-28', DATE '2010-10-29', 2010, 20104, 201010, 2010301, 4, 10, 301, 28, 5, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-24', DATE '2010-10-30', DATE '2010-10-25', DATE '2010-10-31', DATE '2010-10-26', DATE '2010-11-01', DATE '2010-10-27', DATE '2010-11-02', DATE '2010-10-28', DATE '2010-11-03', DATE '2010-10-22', DATE '2010-10-28', DATE '2010-10-23', DATE '2010-10-29', 1031, 3093, 13451, 13452, 13452, 13452, 13452, 13451, 13451, 2455498, 55497, N'2010-10-28', 201043, 43, 4, N'2010-W43', N'2010-W43-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94168, DATE '2010-10-29', DATE '2010-10-30', 2010, 20104, 201010, 2010302, 4, 10, 302, 29, 6, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-24', DATE '2010-10-30', DATE '2010-10-25', DATE '2010-10-31', DATE '2010-10-26', DATE '2010-11-01', DATE '2010-10-27', DATE '2010-11-02', DATE '2010-10-28', DATE '2010-11-03', DATE '2010-10-29', DATE '2010-11-04', DATE '2010-10-23', DATE '2010-10-29', 1031, 3093, 13451, 13452, 13452, 13452, 13452, 13452, 13451, 2455499, 55498, N'2010-10-29', 201043, 43, 5, N'2010-W43', N'2010-W43-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94169, DATE '2010-10-30', DATE '2010-10-31', 2010, 20104, 201010, 2010303, 4, 10, 303, 30, 7, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-24', DATE '2010-10-30', DATE '2010-10-25', DATE '2010-10-31', DATE '2010-10-26', DATE '2010-11-01', DATE '2010-10-27', DATE '2010-11-02', DATE '2010-10-28', DATE '2010-11-03', DATE '2010-10-29', DATE '2010-11-04', DATE '2010-10-30', DATE '2010-11-05', 1031, 3093, 13451, 13452, 13452, 13452, 13452, 13452, 13452, 2455500, 55499, N'2010-10-30', 201043, 43, 6, N'2010-W43', N'2010-W43-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94170, DATE '2010-10-31', DATE '2010-11-01', 2010, 20104, 201010, 2010304, 4, 10, 304, 31, 1, N'2010', N'2010 Q4', N'2010 Oct', N'Oct', N'October', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-10-31', DATE '2010-10-31', DATE '2010-11-06', DATE '2010-10-25', DATE '2010-10-31', DATE '2010-10-26', DATE '2010-11-01', DATE '2010-10-27', DATE '2010-11-02', DATE '2010-10-28', DATE '2010-11-03', DATE '2010-10-29', DATE '2010-11-04', DATE '2010-10-30', DATE '2010-11-05', 1031, 3093, 13452, 13452, 13452, 13452, 13452, 13452, 13452, 2455501, 55500, N'2010-10-31', 201043, 43, 7, N'2010-W43', N'2010-W43-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94171, DATE '2010-11-01', DATE '2010-11-02', 2010, 20104, 201011, 2010305, 4, 11, 305, 1, 2, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-10-31', DATE '2010-11-06', DATE '2010-11-01', DATE '2010-11-07', DATE '2010-10-26', DATE '2010-11-01', DATE '2010-10-27', DATE '2010-11-02', DATE '2010-10-28', DATE '2010-11-03', DATE '2010-10-29', DATE '2010-11-04', DATE '2010-10-30', DATE '2010-11-05', 1031, 3094, 13452, 13453, 13452, 13452, 13452, 13452, 13452, 2455502, 55501, N'2010-11-01', 201044, 44, 1, N'2010-W44', N'2010-W44-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94172, DATE '2010-11-02', DATE '2010-11-03', 2010, 20104, 201011, 2010306, 4, 11, 306, 2, 3, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-10-31', DATE '2010-11-06', DATE '2010-11-01', DATE '2010-11-07', DATE '2010-11-02', DATE '2010-11-08', DATE '2010-10-27', DATE '2010-11-02', DATE '2010-10-28', DATE '2010-11-03', DATE '2010-10-29', DATE '2010-11-04', DATE '2010-10-30', DATE '2010-11-05', 1031, 3094, 13452, 13453, 13453, 13452, 13452, 13452, 13452, 2455503, 55502, N'2010-11-02', 201044, 44, 2, N'2010-W44', N'2010-W44-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94173, DATE '2010-11-03', DATE '2010-11-04', 2010, 20104, 201011, 2010307, 4, 11, 307, 3, 4, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-10-31', DATE '2010-11-06', DATE '2010-11-01', DATE '2010-11-07', DATE '2010-11-02', DATE '2010-11-08', DATE '2010-11-03', DATE '2010-11-09', DATE '2010-10-28', DATE '2010-11-03', DATE '2010-10-29', DATE '2010-11-04', DATE '2010-10-30', DATE '2010-11-05', 1031, 3094, 13452, 13453, 13453, 13453, 13452, 13452, 13452, 2455504, 55503, N'2010-11-03', 201044, 44, 3, N'2010-W44', N'2010-W44-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94174, DATE '2010-11-04', DATE '2010-11-05', 2010, 20104, 201011, 2010308, 4, 11, 308, 4, 5, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-10-31', DATE '2010-11-06', DATE '2010-11-01', DATE '2010-11-07', DATE '2010-11-02', DATE '2010-11-08', DATE '2010-11-03', DATE '2010-11-09', DATE '2010-11-04', DATE '2010-11-10', DATE '2010-10-29', DATE '2010-11-04', DATE '2010-10-30', DATE '2010-11-05', 1031, 3094, 13452, 13453, 13453, 13453, 13453, 13452, 13452, 2455505, 55504, N'2010-11-04', 201044, 44, 4, N'2010-W44', N'2010-W44-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94175, DATE '2010-11-05', DATE '2010-11-06', 2010, 20104, 201011, 2010309, 4, 11, 309, 5, 6, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-10-31', DATE '2010-11-06', DATE '2010-11-01', DATE '2010-11-07', DATE '2010-11-02', DATE '2010-11-08', DATE '2010-11-03', DATE '2010-11-09', DATE '2010-11-04', DATE '2010-11-10', DATE '2010-11-05', DATE '2010-11-11', DATE '2010-10-30', DATE '2010-11-05', 1031, 3094, 13452, 13453, 13453, 13453, 13453, 13453, 13452, 2455506, 55505, N'2010-11-05', 201044, 44, 5, N'2010-W44', N'2010-W44-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94176, DATE '2010-11-06', DATE '2010-11-07', 2010, 20104, 201011, 2010310, 4, 11, 310, 6, 7, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-10-31', DATE '2010-11-06', DATE '2010-11-01', DATE '2010-11-07', DATE '2010-11-02', DATE '2010-11-08', DATE '2010-11-03', DATE '2010-11-09', DATE '2010-11-04', DATE '2010-11-10', DATE '2010-11-05', DATE '2010-11-11', DATE '2010-11-06', DATE '2010-11-12', 1031, 3094, 13452, 13453, 13453, 13453, 13453, 13453, 13453, 2455507, 55506, N'2010-11-06', 201044, 44, 6, N'2010-W44', N'2010-W44-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94177, DATE '2010-11-07', DATE '2010-11-08', 2010, 20104, 201011, 2010311, 4, 11, 311, 7, 1, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-07', DATE '2010-11-13', DATE '2010-11-01', DATE '2010-11-07', DATE '2010-11-02', DATE '2010-11-08', DATE '2010-11-03', DATE '2010-11-09', DATE '2010-11-04', DATE '2010-11-10', DATE '2010-11-05', DATE '2010-11-11', DATE '2010-11-06', DATE '2010-11-12', 1031, 3094, 13453, 13453, 13453, 13453, 13453, 13453, 13453, 2455508, 55507, N'2010-11-07', 201044, 44, 7, N'2010-W44', N'2010-W44-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94178, DATE '2010-11-08', DATE '2010-11-09', 2010, 20104, 201011, 2010312, 4, 11, 312, 8, 2, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-07', DATE '2010-11-13', DATE '2010-11-08', DATE '2010-11-14', DATE '2010-11-02', DATE '2010-11-08', DATE '2010-11-03', DATE '2010-11-09', DATE '2010-11-04', DATE '2010-11-10', DATE '2010-11-05', DATE '2010-11-11', DATE '2010-11-06', DATE '2010-11-12', 1031, 3094, 13453, 13454, 13453, 13453, 13453, 13453, 13453, 2455509, 55508, N'2010-11-08', 201045, 45, 1, N'2010-W45', N'2010-W45-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94179, DATE '2010-11-09', DATE '2010-11-10', 2010, 20104, 201011, 2010313, 4, 11, 313, 9, 3, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-07', DATE '2010-11-13', DATE '2010-11-08', DATE '2010-11-14', DATE '2010-11-09', DATE '2010-11-15', DATE '2010-11-03', DATE '2010-11-09', DATE '2010-11-04', DATE '2010-11-10', DATE '2010-11-05', DATE '2010-11-11', DATE '2010-11-06', DATE '2010-11-12', 1031, 3094, 13453, 13454, 13454, 13453, 13453, 13453, 13453, 2455510, 55509, N'2010-11-09', 201045, 45, 2, N'2010-W45', N'2010-W45-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94180, DATE '2010-11-10', DATE '2010-11-11', 2010, 20104, 201011, 2010314, 4, 11, 314, 10, 4, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-07', DATE '2010-11-13', DATE '2010-11-08', DATE '2010-11-14', DATE '2010-11-09', DATE '2010-11-15', DATE '2010-11-10', DATE '2010-11-16', DATE '2010-11-04', DATE '2010-11-10', DATE '2010-11-05', DATE '2010-11-11', DATE '2010-11-06', DATE '2010-11-12', 1031, 3094, 13453, 13454, 13454, 13454, 13453, 13453, 13453, 2455511, 55510, N'2010-11-10', 201045, 45, 3, N'2010-W45', N'2010-W45-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94181, DATE '2010-11-11', DATE '2010-11-12', 2010, 20104, 201011, 2010315, 4, 11, 315, 11, 5, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-07', DATE '2010-11-13', DATE '2010-11-08', DATE '2010-11-14', DATE '2010-11-09', DATE '2010-11-15', DATE '2010-11-10', DATE '2010-11-16', DATE '2010-11-11', DATE '2010-11-17', DATE '2010-11-05', DATE '2010-11-11', DATE '2010-11-06', DATE '2010-11-12', 1031, 3094, 13453, 13454, 13454, 13454, 13454, 13453, 13453, 2455512, 55511, N'2010-11-11', 201045, 45, 4, N'2010-W45', N'2010-W45-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94182, DATE '2010-11-12', DATE '2010-11-13', 2010, 20104, 201011, 2010316, 4, 11, 316, 12, 6, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-07', DATE '2010-11-13', DATE '2010-11-08', DATE '2010-11-14', DATE '2010-11-09', DATE '2010-11-15', DATE '2010-11-10', DATE '2010-11-16', DATE '2010-11-11', DATE '2010-11-17', DATE '2010-11-12', DATE '2010-11-18', DATE '2010-11-06', DATE '2010-11-12', 1031, 3094, 13453, 13454, 13454, 13454, 13454, 13454, 13453, 2455513, 55512, N'2010-11-12', 201045, 45, 5, N'2010-W45', N'2010-W45-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94183, DATE '2010-11-13', DATE '2010-11-14', 2010, 20104, 201011, 2010317, 4, 11, 317, 13, 7, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-07', DATE '2010-11-13', DATE '2010-11-08', DATE '2010-11-14', DATE '2010-11-09', DATE '2010-11-15', DATE '2010-11-10', DATE '2010-11-16', DATE '2010-11-11', DATE '2010-11-17', DATE '2010-11-12', DATE '2010-11-18', DATE '2010-11-13', DATE '2010-11-19', 1031, 3094, 13453, 13454, 13454, 13454, 13454, 13454, 13454, 2455514, 55513, N'2010-11-13', 201045, 45, 6, N'2010-W45', N'2010-W45-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94184, DATE '2010-11-14', DATE '2010-11-15', 2010, 20104, 201011, 2010318, 4, 11, 318, 14, 1, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-14', DATE '2010-11-20', DATE '2010-11-08', DATE '2010-11-14', DATE '2010-11-09', DATE '2010-11-15', DATE '2010-11-10', DATE '2010-11-16', DATE '2010-11-11', DATE '2010-11-17', DATE '2010-11-12', DATE '2010-11-18', DATE '2010-11-13', DATE '2010-11-19', 1031, 3094, 13454, 13454, 13454, 13454, 13454, 13454, 13454, 2455515, 55514, N'2010-11-14', 201045, 45, 7, N'2010-W45', N'2010-W45-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94185, DATE '2010-11-15', DATE '2010-11-16', 2010, 20104, 201011, 2010319, 4, 11, 319, 15, 2, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-14', DATE '2010-11-20', DATE '2010-11-15', DATE '2010-11-21', DATE '2010-11-09', DATE '2010-11-15', DATE '2010-11-10', DATE '2010-11-16', DATE '2010-11-11', DATE '2010-11-17', DATE '2010-11-12', DATE '2010-11-18', DATE '2010-11-13', DATE '2010-11-19', 1031, 3094, 13454, 13455, 13454, 13454, 13454, 13454, 13454, 2455516, 55515, N'2010-11-15', 201046, 46, 1, N'2010-W46', N'2010-W46-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94186, DATE '2010-11-16', DATE '2010-11-17', 2010, 20104, 201011, 2010320, 4, 11, 320, 16, 3, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-14', DATE '2010-11-20', DATE '2010-11-15', DATE '2010-11-21', DATE '2010-11-16', DATE '2010-11-22', DATE '2010-11-10', DATE '2010-11-16', DATE '2010-11-11', DATE '2010-11-17', DATE '2010-11-12', DATE '2010-11-18', DATE '2010-11-13', DATE '2010-11-19', 1031, 3094, 13454, 13455, 13455, 13454, 13454, 13454, 13454, 2455517, 55516, N'2010-11-16', 201046, 46, 2, N'2010-W46', N'2010-W46-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94187, DATE '2010-11-17', DATE '2010-11-18', 2010, 20104, 201011, 2010321, 4, 11, 321, 17, 4, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-14', DATE '2010-11-20', DATE '2010-11-15', DATE '2010-11-21', DATE '2010-11-16', DATE '2010-11-22', DATE '2010-11-17', DATE '2010-11-23', DATE '2010-11-11', DATE '2010-11-17', DATE '2010-11-12', DATE '2010-11-18', DATE '2010-11-13', DATE '2010-11-19', 1031, 3094, 13454, 13455, 13455, 13455, 13454, 13454, 13454, 2455518, 55517, N'2010-11-17', 201046, 46, 3, N'2010-W46', N'2010-W46-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94188, DATE '2010-11-18', DATE '2010-11-19', 2010, 20104, 201011, 2010322, 4, 11, 322, 18, 5, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-14', DATE '2010-11-20', DATE '2010-11-15', DATE '2010-11-21', DATE '2010-11-16', DATE '2010-11-22', DATE '2010-11-17', DATE '2010-11-23', DATE '2010-11-18', DATE '2010-11-24', DATE '2010-11-12', DATE '2010-11-18', DATE '2010-11-13', DATE '2010-11-19', 1031, 3094, 13454, 13455, 13455, 13455, 13455, 13454, 13454, 2455519, 55518, N'2010-11-18', 201046, 46, 4, N'2010-W46', N'2010-W46-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94189, DATE '2010-11-19', DATE '2010-11-20', 2010, 20104, 201011, 2010323, 4, 11, 323, 19, 6, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-14', DATE '2010-11-20', DATE '2010-11-15', DATE '2010-11-21', DATE '2010-11-16', DATE '2010-11-22', DATE '2010-11-17', DATE '2010-11-23', DATE '2010-11-18', DATE '2010-11-24', DATE '2010-11-19', DATE '2010-11-25', DATE '2010-11-13', DATE '2010-11-19', 1031, 3094, 13454, 13455, 13455, 13455, 13455, 13455, 13454, 2455520, 55519, N'2010-11-19', 201046, 46, 5, N'2010-W46', N'2010-W46-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94190, DATE '2010-11-20', DATE '2010-11-21', 2010, 20104, 201011, 2010324, 4, 11, 324, 20, 7, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-14', DATE '2010-11-20', DATE '2010-11-15', DATE '2010-11-21', DATE '2010-11-16', DATE '2010-11-22', DATE '2010-11-17', DATE '2010-11-23', DATE '2010-11-18', DATE '2010-11-24', DATE '2010-11-19', DATE '2010-11-25', DATE '2010-11-20', DATE '2010-11-26', 1031, 3094, 13454, 13455, 13455, 13455, 13455, 13455, 13455, 2455521, 55520, N'2010-11-20', 201046, 46, 6, N'2010-W46', N'2010-W46-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94191, DATE '2010-11-21', DATE '2010-11-22', 2010, 20104, 201011, 2010325, 4, 11, 325, 21, 1, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-21', DATE '2010-11-27', DATE '2010-11-15', DATE '2010-11-21', DATE '2010-11-16', DATE '2010-11-22', DATE '2010-11-17', DATE '2010-11-23', DATE '2010-11-18', DATE '2010-11-24', DATE '2010-11-19', DATE '2010-11-25', DATE '2010-11-20', DATE '2010-11-26', 1031, 3094, 13455, 13455, 13455, 13455, 13455, 13455, 13455, 2455522, 55521, N'2010-11-21', 201046, 46, 7, N'2010-W46', N'2010-W46-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94192, DATE '2010-11-22', DATE '2010-11-23', 2010, 20104, 201011, 2010326, 4, 11, 326, 22, 2, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-21', DATE '2010-11-27', DATE '2010-11-22', DATE '2010-11-28', DATE '2010-11-16', DATE '2010-11-22', DATE '2010-11-17', DATE '2010-11-23', DATE '2010-11-18', DATE '2010-11-24', DATE '2010-11-19', DATE '2010-11-25', DATE '2010-11-20', DATE '2010-11-26', 1031, 3094, 13455, 13456, 13455, 13455, 13455, 13455, 13455, 2455523, 55522, N'2010-11-22', 201047, 47, 1, N'2010-W47', N'2010-W47-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94193, DATE '2010-11-23', DATE '2010-11-24', 2010, 20104, 201011, 2010327, 4, 11, 327, 23, 3, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-21', DATE '2010-11-27', DATE '2010-11-22', DATE '2010-11-28', DATE '2010-11-23', DATE '2010-11-29', DATE '2010-11-17', DATE '2010-11-23', DATE '2010-11-18', DATE '2010-11-24', DATE '2010-11-19', DATE '2010-11-25', DATE '2010-11-20', DATE '2010-11-26', 1031, 3094, 13455, 13456, 13456, 13455, 13455, 13455, 13455, 2455524, 55523, N'2010-11-23', 201047, 47, 2, N'2010-W47', N'2010-W47-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94194, DATE '2010-11-24', DATE '2010-11-25', 2010, 20104, 201011, 2010328, 4, 11, 328, 24, 4, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-21', DATE '2010-11-27', DATE '2010-11-22', DATE '2010-11-28', DATE '2010-11-23', DATE '2010-11-29', DATE '2010-11-24', DATE '2010-11-30', DATE '2010-11-18', DATE '2010-11-24', DATE '2010-11-19', DATE '2010-11-25', DATE '2010-11-20', DATE '2010-11-26', 1031, 3094, 13455, 13456, 13456, 13456, 13455, 13455, 13455, 2455525, 55524, N'2010-11-24', 201047, 47, 3, N'2010-W47', N'2010-W47-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94195, DATE '2010-11-25', DATE '2010-11-26', 2010, 20104, 201011, 2010329, 4, 11, 329, 25, 5, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-21', DATE '2010-11-27', DATE '2010-11-22', DATE '2010-11-28', DATE '2010-11-23', DATE '2010-11-29', DATE '2010-11-24', DATE '2010-11-30', DATE '2010-11-25', DATE '2010-12-01', DATE '2010-11-19', DATE '2010-11-25', DATE '2010-11-20', DATE '2010-11-26', 1031, 3094, 13455, 13456, 13456, 13456, 13456, 13455, 13455, 2455526, 55525, N'2010-11-25', 201047, 47, 4, N'2010-W47', N'2010-W47-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94196, DATE '2010-11-26', DATE '2010-11-27', 2010, 20104, 201011, 2010330, 4, 11, 330, 26, 6, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-21', DATE '2010-11-27', DATE '2010-11-22', DATE '2010-11-28', DATE '2010-11-23', DATE '2010-11-29', DATE '2010-11-24', DATE '2010-11-30', DATE '2010-11-25', DATE '2010-12-01', DATE '2010-11-26', DATE '2010-12-02', DATE '2010-11-20', DATE '2010-11-26', 1031, 3094, 13455, 13456, 13456, 13456, 13456, 13456, 13455, 2455527, 55526, N'2010-11-26', 201047, 47, 5, N'2010-W47', N'2010-W47-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94197, DATE '2010-11-27', DATE '2010-11-28', 2010, 20104, 201011, 2010331, 4, 11, 331, 27, 7, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-21', DATE '2010-11-27', DATE '2010-11-22', DATE '2010-11-28', DATE '2010-11-23', DATE '2010-11-29', DATE '2010-11-24', DATE '2010-11-30', DATE '2010-11-25', DATE '2010-12-01', DATE '2010-11-26', DATE '2010-12-02', DATE '2010-11-27', DATE '2010-12-03', 1031, 3094, 13455, 13456, 13456, 13456, 13456, 13456, 13456, 2455528, 55527, N'2010-11-27', 201047, 47, 6, N'2010-W47', N'2010-W47-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94198, DATE '2010-11-28', DATE '2010-11-29', 2010, 20104, 201011, 2010332, 4, 11, 332, 28, 1, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-28', DATE '2010-12-04', DATE '2010-11-22', DATE '2010-11-28', DATE '2010-11-23', DATE '2010-11-29', DATE '2010-11-24', DATE '2010-11-30', DATE '2010-11-25', DATE '2010-12-01', DATE '2010-11-26', DATE '2010-12-02', DATE '2010-11-27', DATE '2010-12-03', 1031, 3094, 13456, 13456, 13456, 13456, 13456, 13456, 13456, 2455529, 55528, N'2010-11-28', 201047, 47, 7, N'2010-W47', N'2010-W47-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94199, DATE '2010-11-29', DATE '2010-11-30', 2010, 20104, 201011, 2010333, 4, 11, 333, 29, 2, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-28', DATE '2010-12-04', DATE '2010-11-29', DATE '2010-12-05', DATE '2010-11-23', DATE '2010-11-29', DATE '2010-11-24', DATE '2010-11-30', DATE '2010-11-25', DATE '2010-12-01', DATE '2010-11-26', DATE '2010-12-02', DATE '2010-11-27', DATE '2010-12-03', 1031, 3094, 13456, 13457, 13456, 13456, 13456, 13456, 13456, 2455530, 55529, N'2010-11-29', 201048, 48, 1, N'2010-W48', N'2010-W48-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94200, DATE '2010-11-30', DATE '2010-12-01', 2010, 20104, 201011, 2010334, 4, 11, 334, 30, 3, N'2010', N'2010 Q4', N'2010 Nov', N'Nov', N'November', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-11-01', DATE '2010-11-30', DATE '2010-11-28', DATE '2010-12-04', DATE '2010-11-29', DATE '2010-12-05', DATE '2010-11-30', DATE '2010-12-06', DATE '2010-11-24', DATE '2010-11-30', DATE '2010-11-25', DATE '2010-12-01', DATE '2010-11-26', DATE '2010-12-02', DATE '2010-11-27', DATE '2010-12-03', 1031, 3094, 13456, 13457, 13457, 13456, 13456, 13456, 13456, 2455531, 55530, N'2010-11-30', 201048, 48, 2, N'2010-W48', N'2010-W48-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94201, DATE '2010-12-01', DATE '2010-12-02', 2010, 20104, 201012, 2010335, 4, 12, 335, 1, 4, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-11-28', DATE '2010-12-04', DATE '2010-11-29', DATE '2010-12-05', DATE '2010-11-30', DATE '2010-12-06', DATE '2010-12-01', DATE '2010-12-07', DATE '2010-11-25', DATE '2010-12-01', DATE '2010-11-26', DATE '2010-12-02', DATE '2010-11-27', DATE '2010-12-03', 1031, 3095, 13456, 13457, 13457, 13457, 13456, 13456, 13456, 2455532, 55531, N'2010-12-01', 201048, 48, 3, N'2010-W48', N'2010-W48-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94202, DATE '2010-12-02', DATE '2010-12-03', 2010, 20104, 201012, 2010336, 4, 12, 336, 2, 5, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-11-28', DATE '2010-12-04', DATE '2010-11-29', DATE '2010-12-05', DATE '2010-11-30', DATE '2010-12-06', DATE '2010-12-01', DATE '2010-12-07', DATE '2010-12-02', DATE '2010-12-08', DATE '2010-11-26', DATE '2010-12-02', DATE '2010-11-27', DATE '2010-12-03', 1031, 3095, 13456, 13457, 13457, 13457, 13457, 13456, 13456, 2455533, 55532, N'2010-12-02', 201048, 48, 4, N'2010-W48', N'2010-W48-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94203, DATE '2010-12-03', DATE '2010-12-04', 2010, 20104, 201012, 2010337, 4, 12, 337, 3, 6, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-11-28', DATE '2010-12-04', DATE '2010-11-29', DATE '2010-12-05', DATE '2010-11-30', DATE '2010-12-06', DATE '2010-12-01', DATE '2010-12-07', DATE '2010-12-02', DATE '2010-12-08', DATE '2010-12-03', DATE '2010-12-09', DATE '2010-11-27', DATE '2010-12-03', 1031, 3095, 13456, 13457, 13457, 13457, 13457, 13457, 13456, 2455534, 55533, N'2010-12-03', 201048, 48, 5, N'2010-W48', N'2010-W48-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94204, DATE '2010-12-04', DATE '2010-12-05', 2010, 20104, 201012, 2010338, 4, 12, 338, 4, 7, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-11-28', DATE '2010-12-04', DATE '2010-11-29', DATE '2010-12-05', DATE '2010-11-30', DATE '2010-12-06', DATE '2010-12-01', DATE '2010-12-07', DATE '2010-12-02', DATE '2010-12-08', DATE '2010-12-03', DATE '2010-12-09', DATE '2010-12-04', DATE '2010-12-10', 1031, 3095, 13456, 13457, 13457, 13457, 13457, 13457, 13457, 2455535, 55534, N'2010-12-04', 201048, 48, 6, N'2010-W48', N'2010-W48-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94205, DATE '2010-12-05', DATE '2010-12-06', 2010, 20104, 201012, 2010339, 4, 12, 339, 5, 1, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-05', DATE '2010-12-11', DATE '2010-11-29', DATE '2010-12-05', DATE '2010-11-30', DATE '2010-12-06', DATE '2010-12-01', DATE '2010-12-07', DATE '2010-12-02', DATE '2010-12-08', DATE '2010-12-03', DATE '2010-12-09', DATE '2010-12-04', DATE '2010-12-10', 1031, 3095, 13457, 13457, 13457, 13457, 13457, 13457, 13457, 2455536, 55535, N'2010-12-05', 201048, 48, 7, N'2010-W48', N'2010-W48-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94206, DATE '2010-12-06', DATE '2010-12-07', 2010, 20104, 201012, 2010340, 4, 12, 340, 6, 2, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-05', DATE '2010-12-11', DATE '2010-12-06', DATE '2010-12-12', DATE '2010-11-30', DATE '2010-12-06', DATE '2010-12-01', DATE '2010-12-07', DATE '2010-12-02', DATE '2010-12-08', DATE '2010-12-03', DATE '2010-12-09', DATE '2010-12-04', DATE '2010-12-10', 1031, 3095, 13457, 13458, 13457, 13457, 13457, 13457, 13457, 2455537, 55536, N'2010-12-06', 201049, 49, 1, N'2010-W49', N'2010-W49-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94207, DATE '2010-12-07', DATE '2010-12-08', 2010, 20104, 201012, 2010341, 4, 12, 341, 7, 3, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-05', DATE '2010-12-11', DATE '2010-12-06', DATE '2010-12-12', DATE '2010-12-07', DATE '2010-12-13', DATE '2010-12-01', DATE '2010-12-07', DATE '2010-12-02', DATE '2010-12-08', DATE '2010-12-03', DATE '2010-12-09', DATE '2010-12-04', DATE '2010-12-10', 1031, 3095, 13457, 13458, 13458, 13457, 13457, 13457, 13457, 2455538, 55537, N'2010-12-07', 201049, 49, 2, N'2010-W49', N'2010-W49-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94208, DATE '2010-12-08', DATE '2010-12-09', 2010, 20104, 201012, 2010342, 4, 12, 342, 8, 4, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-05', DATE '2010-12-11', DATE '2010-12-06', DATE '2010-12-12', DATE '2010-12-07', DATE '2010-12-13', DATE '2010-12-08', DATE '2010-12-14', DATE '2010-12-02', DATE '2010-12-08', DATE '2010-12-03', DATE '2010-12-09', DATE '2010-12-04', DATE '2010-12-10', 1031, 3095, 13457, 13458, 13458, 13458, 13457, 13457, 13457, 2455539, 55538, N'2010-12-08', 201049, 49, 3, N'2010-W49', N'2010-W49-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94209, DATE '2010-12-09', DATE '2010-12-10', 2010, 20104, 201012, 2010343, 4, 12, 343, 9, 5, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-05', DATE '2010-12-11', DATE '2010-12-06', DATE '2010-12-12', DATE '2010-12-07', DATE '2010-12-13', DATE '2010-12-08', DATE '2010-12-14', DATE '2010-12-09', DATE '2010-12-15', DATE '2010-12-03', DATE '2010-12-09', DATE '2010-12-04', DATE '2010-12-10', 1031, 3095, 13457, 13458, 13458, 13458, 13458, 13457, 13457, 2455540, 55539, N'2010-12-09', 201049, 49, 4, N'2010-W49', N'2010-W49-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94210, DATE '2010-12-10', DATE '2010-12-11', 2010, 20104, 201012, 2010344, 4, 12, 344, 10, 6, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-05', DATE '2010-12-11', DATE '2010-12-06', DATE '2010-12-12', DATE '2010-12-07', DATE '2010-12-13', DATE '2010-12-08', DATE '2010-12-14', DATE '2010-12-09', DATE '2010-12-15', DATE '2010-12-10', DATE '2010-12-16', DATE '2010-12-04', DATE '2010-12-10', 1031, 3095, 13457, 13458, 13458, 13458, 13458, 13458, 13457, 2455541, 55540, N'2010-12-10', 201049, 49, 5, N'2010-W49', N'2010-W49-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94211, DATE '2010-12-11', DATE '2010-12-12', 2010, 20104, 201012, 2010345, 4, 12, 345, 11, 7, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-05', DATE '2010-12-11', DATE '2010-12-06', DATE '2010-12-12', DATE '2010-12-07', DATE '2010-12-13', DATE '2010-12-08', DATE '2010-12-14', DATE '2010-12-09', DATE '2010-12-15', DATE '2010-12-10', DATE '2010-12-16', DATE '2010-12-11', DATE '2010-12-17', 1031, 3095, 13457, 13458, 13458, 13458, 13458, 13458, 13458, 2455542, 55541, N'2010-12-11', 201049, 49, 6, N'2010-W49', N'2010-W49-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94212, DATE '2010-12-12', DATE '2010-12-13', 2010, 20104, 201012, 2010346, 4, 12, 346, 12, 1, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-12', DATE '2010-12-18', DATE '2010-12-06', DATE '2010-12-12', DATE '2010-12-07', DATE '2010-12-13', DATE '2010-12-08', DATE '2010-12-14', DATE '2010-12-09', DATE '2010-12-15', DATE '2010-12-10', DATE '2010-12-16', DATE '2010-12-11', DATE '2010-12-17', 1031, 3095, 13458, 13458, 13458, 13458, 13458, 13458, 13458, 2455543, 55542, N'2010-12-12', 201049, 49, 7, N'2010-W49', N'2010-W49-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94213, DATE '2010-12-13', DATE '2010-12-14', 2010, 20104, 201012, 2010347, 4, 12, 347, 13, 2, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-12', DATE '2010-12-18', DATE '2010-12-13', DATE '2010-12-19', DATE '2010-12-07', DATE '2010-12-13', DATE '2010-12-08', DATE '2010-12-14', DATE '2010-12-09', DATE '2010-12-15', DATE '2010-12-10', DATE '2010-12-16', DATE '2010-12-11', DATE '2010-12-17', 1031, 3095, 13458, 13459, 13458, 13458, 13458, 13458, 13458, 2455544, 55543, N'2010-12-13', 201050, 50, 1, N'2010-W50', N'2010-W50-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94214, DATE '2010-12-14', DATE '2010-12-15', 2010, 20104, 201012, 2010348, 4, 12, 348, 14, 3, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-12', DATE '2010-12-18', DATE '2010-12-13', DATE '2010-12-19', DATE '2010-12-14', DATE '2010-12-20', DATE '2010-12-08', DATE '2010-12-14', DATE '2010-12-09', DATE '2010-12-15', DATE '2010-12-10', DATE '2010-12-16', DATE '2010-12-11', DATE '2010-12-17', 1031, 3095, 13458, 13459, 13459, 13458, 13458, 13458, 13458, 2455545, 55544, N'2010-12-14', 201050, 50, 2, N'2010-W50', N'2010-W50-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94215, DATE '2010-12-15', DATE '2010-12-16', 2010, 20104, 201012, 2010349, 4, 12, 349, 15, 4, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-12', DATE '2010-12-18', DATE '2010-12-13', DATE '2010-12-19', DATE '2010-12-14', DATE '2010-12-20', DATE '2010-12-15', DATE '2010-12-21', DATE '2010-12-09', DATE '2010-12-15', DATE '2010-12-10', DATE '2010-12-16', DATE '2010-12-11', DATE '2010-12-17', 1031, 3095, 13458, 13459, 13459, 13459, 13458, 13458, 13458, 2455546, 55545, N'2010-12-15', 201050, 50, 3, N'2010-W50', N'2010-W50-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94216, DATE '2010-12-16', DATE '2010-12-17', 2010, 20104, 201012, 2010350, 4, 12, 350, 16, 5, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-12', DATE '2010-12-18', DATE '2010-12-13', DATE '2010-12-19', DATE '2010-12-14', DATE '2010-12-20', DATE '2010-12-15', DATE '2010-12-21', DATE '2010-12-16', DATE '2010-12-22', DATE '2010-12-10', DATE '2010-12-16', DATE '2010-12-11', DATE '2010-12-17', 1031, 3095, 13458, 13459, 13459, 13459, 13459, 13458, 13458, 2455547, 55546, N'2010-12-16', 201050, 50, 4, N'2010-W50', N'2010-W50-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94217, DATE '2010-12-17', DATE '2010-12-18', 2010, 20104, 201012, 2010351, 4, 12, 351, 17, 6, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-12', DATE '2010-12-18', DATE '2010-12-13', DATE '2010-12-19', DATE '2010-12-14', DATE '2010-12-20', DATE '2010-12-15', DATE '2010-12-21', DATE '2010-12-16', DATE '2010-12-22', DATE '2010-12-17', DATE '2010-12-23', DATE '2010-12-11', DATE '2010-12-17', 1031, 3095, 13458, 13459, 13459, 13459, 13459, 13459, 13458, 2455548, 55547, N'2010-12-17', 201050, 50, 5, N'2010-W50', N'2010-W50-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94218, DATE '2010-12-18', DATE '2010-12-19', 2010, 20104, 201012, 2010352, 4, 12, 352, 18, 7, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-12', DATE '2010-12-18', DATE '2010-12-13', DATE '2010-12-19', DATE '2010-12-14', DATE '2010-12-20', DATE '2010-12-15', DATE '2010-12-21', DATE '2010-12-16', DATE '2010-12-22', DATE '2010-12-17', DATE '2010-12-23', DATE '2010-12-18', DATE '2010-12-24', 1031, 3095, 13458, 13459, 13459, 13459, 13459, 13459, 13459, 2455549, 55548, N'2010-12-18', 201050, 50, 6, N'2010-W50', N'2010-W50-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94219, DATE '2010-12-19', DATE '2010-12-20', 2010, 20104, 201012, 2010353, 4, 12, 353, 19, 1, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-19', DATE '2010-12-25', DATE '2010-12-13', DATE '2010-12-19', DATE '2010-12-14', DATE '2010-12-20', DATE '2010-12-15', DATE '2010-12-21', DATE '2010-12-16', DATE '2010-12-22', DATE '2010-12-17', DATE '2010-12-23', DATE '2010-12-18', DATE '2010-12-24', 1031, 3095, 13459, 13459, 13459, 13459, 13459, 13459, 13459, 2455550, 55549, N'2010-12-19', 201050, 50, 7, N'2010-W50', N'2010-W50-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94220, DATE '2010-12-20', DATE '2010-12-21', 2010, 20104, 201012, 2010354, 4, 12, 354, 20, 2, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-19', DATE '2010-12-25', DATE '2010-12-20', DATE '2010-12-26', DATE '2010-12-14', DATE '2010-12-20', DATE '2010-12-15', DATE '2010-12-21', DATE '2010-12-16', DATE '2010-12-22', DATE '2010-12-17', DATE '2010-12-23', DATE '2010-12-18', DATE '2010-12-24', 1031, 3095, 13459, 13460, 13459, 13459, 13459, 13459, 13459, 2455551, 55550, N'2010-12-20', 201051, 51, 1, N'2010-W51', N'2010-W51-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94221, DATE '2010-12-21', DATE '2010-12-22', 2010, 20104, 201012, 2010355, 4, 12, 355, 21, 3, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-19', DATE '2010-12-25', DATE '2010-12-20', DATE '2010-12-26', DATE '2010-12-21', DATE '2010-12-27', DATE '2010-12-15', DATE '2010-12-21', DATE '2010-12-16', DATE '2010-12-22', DATE '2010-12-17', DATE '2010-12-23', DATE '2010-12-18', DATE '2010-12-24', 1031, 3095, 13459, 13460, 13460, 13459, 13459, 13459, 13459, 2455552, 55551, N'2010-12-21', 201051, 51, 2, N'2010-W51', N'2010-W51-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94222, DATE '2010-12-22', DATE '2010-12-23', 2010, 20104, 201012, 2010356, 4, 12, 356, 22, 4, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-19', DATE '2010-12-25', DATE '2010-12-20', DATE '2010-12-26', DATE '2010-12-21', DATE '2010-12-27', DATE '2010-12-22', DATE '2010-12-28', DATE '2010-12-16', DATE '2010-12-22', DATE '2010-12-17', DATE '2010-12-23', DATE '2010-12-18', DATE '2010-12-24', 1031, 3095, 13459, 13460, 13460, 13460, 13459, 13459, 13459, 2455553, 55552, N'2010-12-22', 201051, 51, 3, N'2010-W51', N'2010-W51-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94223, DATE '2010-12-23', DATE '2010-12-24', 2010, 20104, 201012, 2010357, 4, 12, 357, 23, 5, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-19', DATE '2010-12-25', DATE '2010-12-20', DATE '2010-12-26', DATE '2010-12-21', DATE '2010-12-27', DATE '2010-12-22', DATE '2010-12-28', DATE '2010-12-23', DATE '2010-12-29', DATE '2010-12-17', DATE '2010-12-23', DATE '2010-12-18', DATE '2010-12-24', 1031, 3095, 13459, 13460, 13460, 13460, 13460, 13459, 13459, 2455554, 55553, N'2010-12-23', 201051, 51, 4, N'2010-W51', N'2010-W51-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94224, DATE '2010-12-24', DATE '2010-12-25', 2010, 20104, 201012, 2010358, 4, 12, 358, 24, 6, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-19', DATE '2010-12-25', DATE '2010-12-20', DATE '2010-12-26', DATE '2010-12-21', DATE '2010-12-27', DATE '2010-12-22', DATE '2010-12-28', DATE '2010-12-23', DATE '2010-12-29', DATE '2010-12-24', DATE '2010-12-30', DATE '2010-12-18', DATE '2010-12-24', 1031, 3095, 13459, 13460, 13460, 13460, 13460, 13460, 13459, 2455555, 55554, N'2010-12-24', 201051, 51, 5, N'2010-W51', N'2010-W51-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94225, DATE '2010-12-25', DATE '2010-12-26', 2010, 20104, 201012, 2010359, 4, 12, 359, 25, 7, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Sat', N'Saturday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-19', DATE '2010-12-25', DATE '2010-12-20', DATE '2010-12-26', DATE '2010-12-21', DATE '2010-12-27', DATE '2010-12-22', DATE '2010-12-28', DATE '2010-12-23', DATE '2010-12-29', DATE '2010-12-24', DATE '2010-12-30', DATE '2010-12-25', DATE '2010-12-31', 1031, 3095, 13459, 13460, 13460, 13460, 13460, 13460, 13460, 2455556, 55555, N'2010-12-25', 201051, 51, 6, N'2010-W51', N'2010-W51-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94226, DATE '2010-12-26', DATE '2010-12-27', 2010, 20104, 201012, 2010360, 4, 12, 360, 26, 1, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Sun', N'Sunday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-26', DATE '2011-01-01', DATE '2010-12-20', DATE '2010-12-26', DATE '2010-12-21', DATE '2010-12-27', DATE '2010-12-22', DATE '2010-12-28', DATE '2010-12-23', DATE '2010-12-29', DATE '2010-12-24', DATE '2010-12-30', DATE '2010-12-25', DATE '2010-12-31', 1031, 3095, 13460, 13460, 13460, 13460, 13460, 13460, 13460, 2455557, 55556, N'2010-12-26', 201051, 51, 7, N'2010-W51', N'2010-W51-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94227, DATE '2010-12-27', DATE '2010-12-28', 2010, 20104, 201012, 2010361, 4, 12, 361, 27, 2, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Mon', N'Monday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-26', DATE '2011-01-01', DATE '2010-12-27', DATE '2011-01-02', DATE '2010-12-21', DATE '2010-12-27', DATE '2010-12-22', DATE '2010-12-28', DATE '2010-12-23', DATE '2010-12-29', DATE '2010-12-24', DATE '2010-12-30', DATE '2010-12-25', DATE '2010-12-31', 1031, 3095, 13460, 13461, 13460, 13460, 13460, 13460, 13460, 2455558, 55557, N'2010-12-27', 201052, 52, 1, N'2010-W52', N'2010-W52-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94228, DATE '2010-12-28', DATE '2010-12-29', 2010, 20104, 201012, 2010362, 4, 12, 362, 28, 3, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Tue', N'Tuesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-26', DATE '2011-01-01', DATE '2010-12-27', DATE '2011-01-02', DATE '2010-12-28', DATE '2011-01-03', DATE '2010-12-22', DATE '2010-12-28', DATE '2010-12-23', DATE '2010-12-29', DATE '2010-12-24', DATE '2010-12-30', DATE '2010-12-25', DATE '2010-12-31', 1031, 3095, 13460, 13461, 13461, 13460, 13460, 13460, 13460, 2455559, 55558, N'2010-12-28', 201052, 52, 2, N'2010-W52', N'2010-W52-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94229, DATE '2010-12-29', DATE '2010-12-30', 2010, 20104, 201012, 2010363, 4, 12, 363, 29, 4, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Wed', N'Wednesday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-26', DATE '2011-01-01', DATE '2010-12-27', DATE '2011-01-02', DATE '2010-12-28', DATE '2011-01-03', DATE '2010-12-29', DATE '2011-01-04', DATE '2010-12-23', DATE '2010-12-29', DATE '2010-12-24', DATE '2010-12-30', DATE '2010-12-25', DATE '2010-12-31', 1031, 3095, 13460, 13461, 13461, 13461, 13460, 13460, 13460, 2455560, 55559, N'2010-12-29', 201052, 52, 3, N'2010-W52', N'2010-W52-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94230, DATE '2010-12-30', DATE '2010-12-31', 2010, 20104, 201012, 2010364, 4, 12, 364, 30, 5, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Thu', N'Thursday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-26', DATE '2011-01-01', DATE '2010-12-27', DATE '2011-01-02', DATE '2010-12-28', DATE '2011-01-03', DATE '2010-12-29', DATE '2011-01-04', DATE '2010-12-30', DATE '2011-01-05', DATE '2010-12-24', DATE '2010-12-30', DATE '2010-12-25', DATE '2010-12-31', 1031, 3095, 13460, 13461, 13461, 13461, 13461, 13460, 13460, 2455561, 55560, N'2010-12-30', 201052, 52, 4, N'2010-W52', N'2010-W52-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94231, DATE '2010-12-31', DATE '2011-01-01', 2010, 20104, 201012, 2010365, 4, 12, 365, 31, 6, N'2010', N'2010 Q4', N'2010 Dec', N'Dec', N'December', N'Fri', N'Friday', DATE '2010-01-01', DATE '2010-12-31', DATE '2010-10-01', DATE '2010-12-31', DATE '2010-12-01', DATE '2010-12-31', DATE '2010-12-26', DATE '2011-01-01', DATE '2010-12-27', DATE '2011-01-02', DATE '2010-12-28', DATE '2011-01-03', DATE '2010-12-29', DATE '2011-01-04', DATE '2010-12-30', DATE '2011-01-05', DATE '2010-12-31', DATE '2011-01-06', DATE '2010-12-25', DATE '2010-12-31', 1031, 3095, 13460, 13461, 13461, 13461, 13461, 13461, 13460, 2455562, 55561, N'2010-12-31', 201052, 52, 5, N'2010-W52', N'2010-W52-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94232, DATE '2011-01-01', DATE '2011-01-02', 2011, 20111, 201101, 2011001, 1, 1, 1, 1, 7, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2010-12-26', DATE '2011-01-01', DATE '2010-12-27', DATE '2011-01-02', DATE '2010-12-28', DATE '2011-01-03', DATE '2010-12-29', DATE '2011-01-04', DATE '2010-12-30', DATE '2011-01-05', DATE '2010-12-31', DATE '2011-01-06', DATE '2011-01-01', DATE '2011-01-07', 1032, 3096, 13460, 13461, 13461, 13461, 13461, 13461, 13461, 2455563, 55562, N'2011-01-01', 201052, 52, 6, N'2010-W52', N'2010-W52-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94233, DATE '2011-01-02', DATE '2011-01-03', 2011, 20111, 201101, 2011002, 1, 1, 2, 2, 1, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-02', DATE '2011-01-08', DATE '2010-12-27', DATE '2011-01-02', DATE '2010-12-28', DATE '2011-01-03', DATE '2010-12-29', DATE '2011-01-04', DATE '2010-12-30', DATE '2011-01-05', DATE '2010-12-31', DATE '2011-01-06', DATE '2011-01-01', DATE '2011-01-07', 1032, 3096, 13461, 13461, 13461, 13461, 13461, 13461, 13461, 2455564, 55563, N'2011-01-02', 201052, 52, 7, N'2010-W52', N'2010-W52-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94234, DATE '2011-01-03', DATE '2011-01-04', 2011, 20111, 201101, 2011003, 1, 1, 3, 3, 2, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-02', DATE '2011-01-08', DATE '2011-01-03', DATE '2011-01-09', DATE '2010-12-28', DATE '2011-01-03', DATE '2010-12-29', DATE '2011-01-04', DATE '2010-12-30', DATE '2011-01-05', DATE '2010-12-31', DATE '2011-01-06', DATE '2011-01-01', DATE '2011-01-07', 1032, 3096, 13461, 13462, 13461, 13461, 13461, 13461, 13461, 2455565, 55564, N'2011-01-03', 201101, 1, 1, N'2011-W01', N'2011-W01-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94235, DATE '2011-01-04', DATE '2011-01-05', 2011, 20111, 201101, 2011004, 1, 1, 4, 4, 3, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-02', DATE '2011-01-08', DATE '2011-01-03', DATE '2011-01-09', DATE '2011-01-04', DATE '2011-01-10', DATE '2010-12-29', DATE '2011-01-04', DATE '2010-12-30', DATE '2011-01-05', DATE '2010-12-31', DATE '2011-01-06', DATE '2011-01-01', DATE '2011-01-07', 1032, 3096, 13461, 13462, 13462, 13461, 13461, 13461, 13461, 2455566, 55565, N'2011-01-04', 201101, 1, 2, N'2011-W01', N'2011-W01-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94236, DATE '2011-01-05', DATE '2011-01-06', 2011, 20111, 201101, 2011005, 1, 1, 5, 5, 4, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-02', DATE '2011-01-08', DATE '2011-01-03', DATE '2011-01-09', DATE '2011-01-04', DATE '2011-01-10', DATE '2011-01-05', DATE '2011-01-11', DATE '2010-12-30', DATE '2011-01-05', DATE '2010-12-31', DATE '2011-01-06', DATE '2011-01-01', DATE '2011-01-07', 1032, 3096, 13461, 13462, 13462, 13462, 13461, 13461, 13461, 2455567, 55566, N'2011-01-05', 201101, 1, 3, N'2011-W01', N'2011-W01-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94237, DATE '2011-01-06', DATE '2011-01-07', 2011, 20111, 201101, 2011006, 1, 1, 6, 6, 5, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-02', DATE '2011-01-08', DATE '2011-01-03', DATE '2011-01-09', DATE '2011-01-04', DATE '2011-01-10', DATE '2011-01-05', DATE '2011-01-11', DATE '2011-01-06', DATE '2011-01-12', DATE '2010-12-31', DATE '2011-01-06', DATE '2011-01-01', DATE '2011-01-07', 1032, 3096, 13461, 13462, 13462, 13462, 13462, 13461, 13461, 2455568, 55567, N'2011-01-06', 201101, 1, 4, N'2011-W01', N'2011-W01-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94238, DATE '2011-01-07', DATE '2011-01-08', 2011, 20111, 201101, 2011007, 1, 1, 7, 7, 6, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-02', DATE '2011-01-08', DATE '2011-01-03', DATE '2011-01-09', DATE '2011-01-04', DATE '2011-01-10', DATE '2011-01-05', DATE '2011-01-11', DATE '2011-01-06', DATE '2011-01-12', DATE '2011-01-07', DATE '2011-01-13', DATE '2011-01-01', DATE '2011-01-07', 1032, 3096, 13461, 13462, 13462, 13462, 13462, 13462, 13461, 2455569, 55568, N'2011-01-07', 201101, 1, 5, N'2011-W01', N'2011-W01-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94239, DATE '2011-01-08', DATE '2011-01-09', 2011, 20111, 201101, 2011008, 1, 1, 8, 8, 7, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-02', DATE '2011-01-08', DATE '2011-01-03', DATE '2011-01-09', DATE '2011-01-04', DATE '2011-01-10', DATE '2011-01-05', DATE '2011-01-11', DATE '2011-01-06', DATE '2011-01-12', DATE '2011-01-07', DATE '2011-01-13', DATE '2011-01-08', DATE '2011-01-14', 1032, 3096, 13461, 13462, 13462, 13462, 13462, 13462, 13462, 2455570, 55569, N'2011-01-08', 201101, 1, 6, N'2011-W01', N'2011-W01-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94240, DATE '2011-01-09', DATE '2011-01-10', 2011, 20111, 201101, 2011009, 1, 1, 9, 9, 1, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-09', DATE '2011-01-15', DATE '2011-01-03', DATE '2011-01-09', DATE '2011-01-04', DATE '2011-01-10', DATE '2011-01-05', DATE '2011-01-11', DATE '2011-01-06', DATE '2011-01-12', DATE '2011-01-07', DATE '2011-01-13', DATE '2011-01-08', DATE '2011-01-14', 1032, 3096, 13462, 13462, 13462, 13462, 13462, 13462, 13462, 2455571, 55570, N'2011-01-09', 201101, 1, 7, N'2011-W01', N'2011-W01-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94241, DATE '2011-01-10', DATE '2011-01-11', 2011, 20111, 201101, 2011010, 1, 1, 10, 10, 2, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-09', DATE '2011-01-15', DATE '2011-01-10', DATE '2011-01-16', DATE '2011-01-04', DATE '2011-01-10', DATE '2011-01-05', DATE '2011-01-11', DATE '2011-01-06', DATE '2011-01-12', DATE '2011-01-07', DATE '2011-01-13', DATE '2011-01-08', DATE '2011-01-14', 1032, 3096, 13462, 13463, 13462, 13462, 13462, 13462, 13462, 2455572, 55571, N'2011-01-10', 201102, 2, 1, N'2011-W02', N'2011-W02-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94242, DATE '2011-01-11', DATE '2011-01-12', 2011, 20111, 201101, 2011011, 1, 1, 11, 11, 3, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-09', DATE '2011-01-15', DATE '2011-01-10', DATE '2011-01-16', DATE '2011-01-11', DATE '2011-01-17', DATE '2011-01-05', DATE '2011-01-11', DATE '2011-01-06', DATE '2011-01-12', DATE '2011-01-07', DATE '2011-01-13', DATE '2011-01-08', DATE '2011-01-14', 1032, 3096, 13462, 13463, 13463, 13462, 13462, 13462, 13462, 2455573, 55572, N'2011-01-11', 201102, 2, 2, N'2011-W02', N'2011-W02-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94243, DATE '2011-01-12', DATE '2011-01-13', 2011, 20111, 201101, 2011012, 1, 1, 12, 12, 4, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-09', DATE '2011-01-15', DATE '2011-01-10', DATE '2011-01-16', DATE '2011-01-11', DATE '2011-01-17', DATE '2011-01-12', DATE '2011-01-18', DATE '2011-01-06', DATE '2011-01-12', DATE '2011-01-07', DATE '2011-01-13', DATE '2011-01-08', DATE '2011-01-14', 1032, 3096, 13462, 13463, 13463, 13463, 13462, 13462, 13462, 2455574, 55573, N'2011-01-12', 201102, 2, 3, N'2011-W02', N'2011-W02-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94244, DATE '2011-01-13', DATE '2011-01-14', 2011, 20111, 201101, 2011013, 1, 1, 13, 13, 5, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-09', DATE '2011-01-15', DATE '2011-01-10', DATE '2011-01-16', DATE '2011-01-11', DATE '2011-01-17', DATE '2011-01-12', DATE '2011-01-18', DATE '2011-01-13', DATE '2011-01-19', DATE '2011-01-07', DATE '2011-01-13', DATE '2011-01-08', DATE '2011-01-14', 1032, 3096, 13462, 13463, 13463, 13463, 13463, 13462, 13462, 2455575, 55574, N'2011-01-13', 201102, 2, 4, N'2011-W02', N'2011-W02-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94245, DATE '2011-01-14', DATE '2011-01-15', 2011, 20111, 201101, 2011014, 1, 1, 14, 14, 6, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-09', DATE '2011-01-15', DATE '2011-01-10', DATE '2011-01-16', DATE '2011-01-11', DATE '2011-01-17', DATE '2011-01-12', DATE '2011-01-18', DATE '2011-01-13', DATE '2011-01-19', DATE '2011-01-14', DATE '2011-01-20', DATE '2011-01-08', DATE '2011-01-14', 1032, 3096, 13462, 13463, 13463, 13463, 13463, 13463, 13462, 2455576, 55575, N'2011-01-14', 201102, 2, 5, N'2011-W02', N'2011-W02-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94246, DATE '2011-01-15', DATE '2011-01-16', 2011, 20111, 201101, 2011015, 1, 1, 15, 15, 7, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-09', DATE '2011-01-15', DATE '2011-01-10', DATE '2011-01-16', DATE '2011-01-11', DATE '2011-01-17', DATE '2011-01-12', DATE '2011-01-18', DATE '2011-01-13', DATE '2011-01-19', DATE '2011-01-14', DATE '2011-01-20', DATE '2011-01-15', DATE '2011-01-21', 1032, 3096, 13462, 13463, 13463, 13463, 13463, 13463, 13463, 2455577, 55576, N'2011-01-15', 201102, 2, 6, N'2011-W02', N'2011-W02-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94247, DATE '2011-01-16', DATE '2011-01-17', 2011, 20111, 201101, 2011016, 1, 1, 16, 16, 1, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-16', DATE '2011-01-22', DATE '2011-01-10', DATE '2011-01-16', DATE '2011-01-11', DATE '2011-01-17', DATE '2011-01-12', DATE '2011-01-18', DATE '2011-01-13', DATE '2011-01-19', DATE '2011-01-14', DATE '2011-01-20', DATE '2011-01-15', DATE '2011-01-21', 1032, 3096, 13463, 13463, 13463, 13463, 13463, 13463, 13463, 2455578, 55577, N'2011-01-16', 201102, 2, 7, N'2011-W02', N'2011-W02-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94248, DATE '2011-01-17', DATE '2011-01-18', 2011, 20111, 201101, 2011017, 1, 1, 17, 17, 2, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-16', DATE '2011-01-22', DATE '2011-01-17', DATE '2011-01-23', DATE '2011-01-11', DATE '2011-01-17', DATE '2011-01-12', DATE '2011-01-18', DATE '2011-01-13', DATE '2011-01-19', DATE '2011-01-14', DATE '2011-01-20', DATE '2011-01-15', DATE '2011-01-21', 1032, 3096, 13463, 13464, 13463, 13463, 13463, 13463, 13463, 2455579, 55578, N'2011-01-17', 201103, 3, 1, N'2011-W03', N'2011-W03-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94249, DATE '2011-01-18', DATE '2011-01-19', 2011, 20111, 201101, 2011018, 1, 1, 18, 18, 3, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-16', DATE '2011-01-22', DATE '2011-01-17', DATE '2011-01-23', DATE '2011-01-18', DATE '2011-01-24', DATE '2011-01-12', DATE '2011-01-18', DATE '2011-01-13', DATE '2011-01-19', DATE '2011-01-14', DATE '2011-01-20', DATE '2011-01-15', DATE '2011-01-21', 1032, 3096, 13463, 13464, 13464, 13463, 13463, 13463, 13463, 2455580, 55579, N'2011-01-18', 201103, 3, 2, N'2011-W03', N'2011-W03-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94250, DATE '2011-01-19', DATE '2011-01-20', 2011, 20111, 201101, 2011019, 1, 1, 19, 19, 4, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-16', DATE '2011-01-22', DATE '2011-01-17', DATE '2011-01-23', DATE '2011-01-18', DATE '2011-01-24', DATE '2011-01-19', DATE '2011-01-25', DATE '2011-01-13', DATE '2011-01-19', DATE '2011-01-14', DATE '2011-01-20', DATE '2011-01-15', DATE '2011-01-21', 1032, 3096, 13463, 13464, 13464, 13464, 13463, 13463, 13463, 2455581, 55580, N'2011-01-19', 201103, 3, 3, N'2011-W03', N'2011-W03-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94251, DATE '2011-01-20', DATE '2011-01-21', 2011, 20111, 201101, 2011020, 1, 1, 20, 20, 5, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-16', DATE '2011-01-22', DATE '2011-01-17', DATE '2011-01-23', DATE '2011-01-18', DATE '2011-01-24', DATE '2011-01-19', DATE '2011-01-25', DATE '2011-01-20', DATE '2011-01-26', DATE '2011-01-14', DATE '2011-01-20', DATE '2011-01-15', DATE '2011-01-21', 1032, 3096, 13463, 13464, 13464, 13464, 13464, 13463, 13463, 2455582, 55581, N'2011-01-20', 201103, 3, 4, N'2011-W03', N'2011-W03-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94252, DATE '2011-01-21', DATE '2011-01-22', 2011, 20111, 201101, 2011021, 1, 1, 21, 21, 6, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-16', DATE '2011-01-22', DATE '2011-01-17', DATE '2011-01-23', DATE '2011-01-18', DATE '2011-01-24', DATE '2011-01-19', DATE '2011-01-25', DATE '2011-01-20', DATE '2011-01-26', DATE '2011-01-21', DATE '2011-01-27', DATE '2011-01-15', DATE '2011-01-21', 1032, 3096, 13463, 13464, 13464, 13464, 13464, 13464, 13463, 2455583, 55582, N'2011-01-21', 201103, 3, 5, N'2011-W03', N'2011-W03-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94253, DATE '2011-01-22', DATE '2011-01-23', 2011, 20111, 201101, 2011022, 1, 1, 22, 22, 7, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-16', DATE '2011-01-22', DATE '2011-01-17', DATE '2011-01-23', DATE '2011-01-18', DATE '2011-01-24', DATE '2011-01-19', DATE '2011-01-25', DATE '2011-01-20', DATE '2011-01-26', DATE '2011-01-21', DATE '2011-01-27', DATE '2011-01-22', DATE '2011-01-28', 1032, 3096, 13463, 13464, 13464, 13464, 13464, 13464, 13464, 2455584, 55583, N'2011-01-22', 201103, 3, 6, N'2011-W03', N'2011-W03-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94254, DATE '2011-01-23', DATE '2011-01-24', 2011, 20111, 201101, 2011023, 1, 1, 23, 23, 1, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-23', DATE '2011-01-29', DATE '2011-01-17', DATE '2011-01-23', DATE '2011-01-18', DATE '2011-01-24', DATE '2011-01-19', DATE '2011-01-25', DATE '2011-01-20', DATE '2011-01-26', DATE '2011-01-21', DATE '2011-01-27', DATE '2011-01-22', DATE '2011-01-28', 1032, 3096, 13464, 13464, 13464, 13464, 13464, 13464, 13464, 2455585, 55584, N'2011-01-23', 201103, 3, 7, N'2011-W03', N'2011-W03-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94255, DATE '2011-01-24', DATE '2011-01-25', 2011, 20111, 201101, 2011024, 1, 1, 24, 24, 2, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-23', DATE '2011-01-29', DATE '2011-01-24', DATE '2011-01-30', DATE '2011-01-18', DATE '2011-01-24', DATE '2011-01-19', DATE '2011-01-25', DATE '2011-01-20', DATE '2011-01-26', DATE '2011-01-21', DATE '2011-01-27', DATE '2011-01-22', DATE '2011-01-28', 1032, 3096, 13464, 13465, 13464, 13464, 13464, 13464, 13464, 2455586, 55585, N'2011-01-24', 201104, 4, 1, N'2011-W04', N'2011-W04-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94256, DATE '2011-01-25', DATE '2011-01-26', 2011, 20111, 201101, 2011025, 1, 1, 25, 25, 3, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-23', DATE '2011-01-29', DATE '2011-01-24', DATE '2011-01-30', DATE '2011-01-25', DATE '2011-01-31', DATE '2011-01-19', DATE '2011-01-25', DATE '2011-01-20', DATE '2011-01-26', DATE '2011-01-21', DATE '2011-01-27', DATE '2011-01-22', DATE '2011-01-28', 1032, 3096, 13464, 13465, 13465, 13464, 13464, 13464, 13464, 2455587, 55586, N'2011-01-25', 201104, 4, 2, N'2011-W04', N'2011-W04-2');

INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94257, DATE '2011-01-26', DATE '2011-01-27', 2011, 20111, 201101, 2011026, 1, 1, 26, 26, 4, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-23', DATE '2011-01-29', DATE '2011-01-24', DATE '2011-01-30', DATE '2011-01-25', DATE '2011-01-31', DATE '2011-01-26', DATE '2011-02-01', DATE '2011-01-20', DATE '2011-01-26', DATE '2011-01-21', DATE '2011-01-27', DATE '2011-01-22', DATE '2011-01-28', 1032, 3096, 13464, 13465, 13465, 13465, 13464, 13464, 13464, 2455588, 55587, N'2011-01-26', 201104, 4, 3, N'2011-W04', N'2011-W04-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94258, DATE '2011-01-27', DATE '2011-01-28', 2011, 20111, 201101, 2011027, 1, 1, 27, 27, 5, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-23', DATE '2011-01-29', DATE '2011-01-24', DATE '2011-01-30', DATE '2011-01-25', DATE '2011-01-31', DATE '2011-01-26', DATE '2011-02-01', DATE '2011-01-27', DATE '2011-02-02', DATE '2011-01-21', DATE '2011-01-27', DATE '2011-01-22', DATE '2011-01-28', 1032, 3096, 13464, 13465, 13465, 13465, 13465, 13464, 13464, 2455589, 55588, N'2011-01-27', 201104, 4, 4, N'2011-W04', N'2011-W04-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94259, DATE '2011-01-28', DATE '2011-01-29', 2011, 20111, 201101, 2011028, 1, 1, 28, 28, 6, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-23', DATE '2011-01-29', DATE '2011-01-24', DATE '2011-01-30', DATE '2011-01-25', DATE '2011-01-31', DATE '2011-01-26', DATE '2011-02-01', DATE '2011-01-27', DATE '2011-02-02', DATE '2011-01-28', DATE '2011-02-03', DATE '2011-01-22', DATE '2011-01-28', 1032, 3096, 13464, 13465, 13465, 13465, 13465, 13465, 13464, 2455590, 55589, N'2011-01-28', 201104, 4, 5, N'2011-W04', N'2011-W04-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94260, DATE '2011-01-29', DATE '2011-01-30', 2011, 20111, 201101, 2011029, 1, 1, 29, 29, 7, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-23', DATE '2011-01-29', DATE '2011-01-24', DATE '2011-01-30', DATE '2011-01-25', DATE '2011-01-31', DATE '2011-01-26', DATE '2011-02-01', DATE '2011-01-27', DATE '2011-02-02', DATE '2011-01-28', DATE '2011-02-03', DATE '2011-01-29', DATE '2011-02-04', 1032, 3096, 13464, 13465, 13465, 13465, 13465, 13465, 13465, 2455591, 55590, N'2011-01-29', 201104, 4, 6, N'2011-W04', N'2011-W04-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94261, DATE '2011-01-30', DATE '2011-01-31', 2011, 20111, 201101, 2011030, 1, 1, 30, 30, 1, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-30', DATE '2011-02-05', DATE '2011-01-24', DATE '2011-01-30', DATE '2011-01-25', DATE '2011-01-31', DATE '2011-01-26', DATE '2011-02-01', DATE '2011-01-27', DATE '2011-02-02', DATE '2011-01-28', DATE '2011-02-03', DATE '2011-01-29', DATE '2011-02-04', 1032, 3096, 13465, 13465, 13465, 13465, 13465, 13465, 13465, 2455592, 55591, N'2011-01-30', 201104, 4, 7, N'2011-W04', N'2011-W04-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94262, DATE '2011-01-31', DATE '2011-02-01', 2011, 20111, 201101, 2011031, 1, 1, 31, 31, 2, N'2011', N'2011 Q1', N'2011 Jan', N'Jan', N'January', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-01-01', DATE '2011-01-31', DATE '2011-01-30', DATE '2011-02-05', DATE '2011-01-31', DATE '2011-02-06', DATE '2011-01-25', DATE '2011-01-31', DATE '2011-01-26', DATE '2011-02-01', DATE '2011-01-27', DATE '2011-02-02', DATE '2011-01-28', DATE '2011-02-03', DATE '2011-01-29', DATE '2011-02-04', 1032, 3096, 13465, 13466, 13465, 13465, 13465, 13465, 13465, 2455593, 55592, N'2011-01-31', 201105, 5, 1, N'2011-W05', N'2011-W05-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94263, DATE '2011-02-01', DATE '2011-02-02', 2011, 20111, 201102, 2011032, 1, 2, 32, 1, 3, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-01-30', DATE '2011-02-05', DATE '2011-01-31', DATE '2011-02-06', DATE '2011-02-01', DATE '2011-02-07', DATE '2011-01-26', DATE '2011-02-01', DATE '2011-01-27', DATE '2011-02-02', DATE '2011-01-28', DATE '2011-02-03', DATE '2011-01-29', DATE '2011-02-04', 1032, 3097, 13465, 13466, 13466, 13465, 13465, 13465, 13465, 2455594, 55593, N'2011-02-01', 201105, 5, 2, N'2011-W05', N'2011-W05-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94264, DATE '2011-02-02', DATE '2011-02-03', 2011, 20111, 201102, 2011033, 1, 2, 33, 2, 4, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-01-30', DATE '2011-02-05', DATE '2011-01-31', DATE '2011-02-06', DATE '2011-02-01', DATE '2011-02-07', DATE '2011-02-02', DATE '2011-02-08', DATE '2011-01-27', DATE '2011-02-02', DATE '2011-01-28', DATE '2011-02-03', DATE '2011-01-29', DATE '2011-02-04', 1032, 3097, 13465, 13466, 13466, 13466, 13465, 13465, 13465, 2455595, 55594, N'2011-02-02', 201105, 5, 3, N'2011-W05', N'2011-W05-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94265, DATE '2011-02-03', DATE '2011-02-04', 2011, 20111, 201102, 2011034, 1, 2, 34, 3, 5, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-01-30', DATE '2011-02-05', DATE '2011-01-31', DATE '2011-02-06', DATE '2011-02-01', DATE '2011-02-07', DATE '2011-02-02', DATE '2011-02-08', DATE '2011-02-03', DATE '2011-02-09', DATE '2011-01-28', DATE '2011-02-03', DATE '2011-01-29', DATE '2011-02-04', 1032, 3097, 13465, 13466, 13466, 13466, 13466, 13465, 13465, 2455596, 55595, N'2011-02-03', 201105, 5, 4, N'2011-W05', N'2011-W05-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94266, DATE '2011-02-04', DATE '2011-02-05', 2011, 20111, 201102, 2011035, 1, 2, 35, 4, 6, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-01-30', DATE '2011-02-05', DATE '2011-01-31', DATE '2011-02-06', DATE '2011-02-01', DATE '2011-02-07', DATE '2011-02-02', DATE '2011-02-08', DATE '2011-02-03', DATE '2011-02-09', DATE '2011-02-04', DATE '2011-02-10', DATE '2011-01-29', DATE '2011-02-04', 1032, 3097, 13465, 13466, 13466, 13466, 13466, 13466, 13465, 2455597, 55596, N'2011-02-04', 201105, 5, 5, N'2011-W05', N'2011-W05-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94267, DATE '2011-02-05', DATE '2011-02-06', 2011, 20111, 201102, 2011036, 1, 2, 36, 5, 7, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-01-30', DATE '2011-02-05', DATE '2011-01-31', DATE '2011-02-06', DATE '2011-02-01', DATE '2011-02-07', DATE '2011-02-02', DATE '2011-02-08', DATE '2011-02-03', DATE '2011-02-09', DATE '2011-02-04', DATE '2011-02-10', DATE '2011-02-05', DATE '2011-02-11', 1032, 3097, 13465, 13466, 13466, 13466, 13466, 13466, 13466, 2455598, 55597, N'2011-02-05', 201105, 5, 6, N'2011-W05', N'2011-W05-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94268, DATE '2011-02-06', DATE '2011-02-07', 2011, 20111, 201102, 2011037, 1, 2, 37, 6, 1, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-06', DATE '2011-02-12', DATE '2011-01-31', DATE '2011-02-06', DATE '2011-02-01', DATE '2011-02-07', DATE '2011-02-02', DATE '2011-02-08', DATE '2011-02-03', DATE '2011-02-09', DATE '2011-02-04', DATE '2011-02-10', DATE '2011-02-05', DATE '2011-02-11', 1032, 3097, 13466, 13466, 13466, 13466, 13466, 13466, 13466, 2455599, 55598, N'2011-02-06', 201105, 5, 7, N'2011-W05', N'2011-W05-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94269, DATE '2011-02-07', DATE '2011-02-08', 2011, 20111, 201102, 2011038, 1, 2, 38, 7, 2, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-06', DATE '2011-02-12', DATE '2011-02-07', DATE '2011-02-13', DATE '2011-02-01', DATE '2011-02-07', DATE '2011-02-02', DATE '2011-02-08', DATE '2011-02-03', DATE '2011-02-09', DATE '2011-02-04', DATE '2011-02-10', DATE '2011-02-05', DATE '2011-02-11', 1032, 3097, 13466, 13467, 13466, 13466, 13466, 13466, 13466, 2455600, 55599, N'2011-02-07', 201106, 6, 1, N'2011-W06', N'2011-W06-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94270, DATE '2011-02-08', DATE '2011-02-09', 2011, 20111, 201102, 2011039, 1, 2, 39, 8, 3, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-06', DATE '2011-02-12', DATE '2011-02-07', DATE '2011-02-13', DATE '2011-02-08', DATE '2011-02-14', DATE '2011-02-02', DATE '2011-02-08', DATE '2011-02-03', DATE '2011-02-09', DATE '2011-02-04', DATE '2011-02-10', DATE '2011-02-05', DATE '2011-02-11', 1032, 3097, 13466, 13467, 13467, 13466, 13466, 13466, 13466, 2455601, 55600, N'2011-02-08', 201106, 6, 2, N'2011-W06', N'2011-W06-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94271, DATE '2011-02-09', DATE '2011-02-10', 2011, 20111, 201102, 2011040, 1, 2, 40, 9, 4, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-06', DATE '2011-02-12', DATE '2011-02-07', DATE '2011-02-13', DATE '2011-02-08', DATE '2011-02-14', DATE '2011-02-09', DATE '2011-02-15', DATE '2011-02-03', DATE '2011-02-09', DATE '2011-02-04', DATE '2011-02-10', DATE '2011-02-05', DATE '2011-02-11', 1032, 3097, 13466, 13467, 13467, 13467, 13466, 13466, 13466, 2455602, 55601, N'2011-02-09', 201106, 6, 3, N'2011-W06', N'2011-W06-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94272, DATE '2011-02-10', DATE '2011-02-11', 2011, 20111, 201102, 2011041, 1, 2, 41, 10, 5, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-06', DATE '2011-02-12', DATE '2011-02-07', DATE '2011-02-13', DATE '2011-02-08', DATE '2011-02-14', DATE '2011-02-09', DATE '2011-02-15', DATE '2011-02-10', DATE '2011-02-16', DATE '2011-02-04', DATE '2011-02-10', DATE '2011-02-05', DATE '2011-02-11', 1032, 3097, 13466, 13467, 13467, 13467, 13467, 13466, 13466, 2455603, 55602, N'2011-02-10', 201106, 6, 4, N'2011-W06', N'2011-W06-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94273, DATE '2011-02-11', DATE '2011-02-12', 2011, 20111, 201102, 2011042, 1, 2, 42, 11, 6, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-06', DATE '2011-02-12', DATE '2011-02-07', DATE '2011-02-13', DATE '2011-02-08', DATE '2011-02-14', DATE '2011-02-09', DATE '2011-02-15', DATE '2011-02-10', DATE '2011-02-16', DATE '2011-02-11', DATE '2011-02-17', DATE '2011-02-05', DATE '2011-02-11', 1032, 3097, 13466, 13467, 13467, 13467, 13467, 13467, 13466, 2455604, 55603, N'2011-02-11', 201106, 6, 5, N'2011-W06', N'2011-W06-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94274, DATE '2011-02-12', DATE '2011-02-13', 2011, 20111, 201102, 2011043, 1, 2, 43, 12, 7, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-06', DATE '2011-02-12', DATE '2011-02-07', DATE '2011-02-13', DATE '2011-02-08', DATE '2011-02-14', DATE '2011-02-09', DATE '2011-02-15', DATE '2011-02-10', DATE '2011-02-16', DATE '2011-02-11', DATE '2011-02-17', DATE '2011-02-12', DATE '2011-02-18', 1032, 3097, 13466, 13467, 13467, 13467, 13467, 13467, 13467, 2455605, 55604, N'2011-02-12', 201106, 6, 6, N'2011-W06', N'2011-W06-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94275, DATE '2011-02-13', DATE '2011-02-14', 2011, 20111, 201102, 2011044, 1, 2, 44, 13, 1, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-13', DATE '2011-02-19', DATE '2011-02-07', DATE '2011-02-13', DATE '2011-02-08', DATE '2011-02-14', DATE '2011-02-09', DATE '2011-02-15', DATE '2011-02-10', DATE '2011-02-16', DATE '2011-02-11', DATE '2011-02-17', DATE '2011-02-12', DATE '2011-02-18', 1032, 3097, 13467, 13467, 13467, 13467, 13467, 13467, 13467, 2455606, 55605, N'2011-02-13', 201106, 6, 7, N'2011-W06', N'2011-W06-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94276, DATE '2011-02-14', DATE '2011-02-15', 2011, 20111, 201102, 2011045, 1, 2, 45, 14, 2, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-13', DATE '2011-02-19', DATE '2011-02-14', DATE '2011-02-20', DATE '2011-02-08', DATE '2011-02-14', DATE '2011-02-09', DATE '2011-02-15', DATE '2011-02-10', DATE '2011-02-16', DATE '2011-02-11', DATE '2011-02-17', DATE '2011-02-12', DATE '2011-02-18', 1032, 3097, 13467, 13468, 13467, 13467, 13467, 13467, 13467, 2455607, 55606, N'2011-02-14', 201107, 7, 1, N'2011-W07', N'2011-W07-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94277, DATE '2011-02-15', DATE '2011-02-16', 2011, 20111, 201102, 2011046, 1, 2, 46, 15, 3, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-13', DATE '2011-02-19', DATE '2011-02-14', DATE '2011-02-20', DATE '2011-02-15', DATE '2011-02-21', DATE '2011-02-09', DATE '2011-02-15', DATE '2011-02-10', DATE '2011-02-16', DATE '2011-02-11', DATE '2011-02-17', DATE '2011-02-12', DATE '2011-02-18', 1032, 3097, 13467, 13468, 13468, 13467, 13467, 13467, 13467, 2455608, 55607, N'2011-02-15', 201107, 7, 2, N'2011-W07', N'2011-W07-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94278, DATE '2011-02-16', DATE '2011-02-17', 2011, 20111, 201102, 2011047, 1, 2, 47, 16, 4, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-13', DATE '2011-02-19', DATE '2011-02-14', DATE '2011-02-20', DATE '2011-02-15', DATE '2011-02-21', DATE '2011-02-16', DATE '2011-02-22', DATE '2011-02-10', DATE '2011-02-16', DATE '2011-02-11', DATE '2011-02-17', DATE '2011-02-12', DATE '2011-02-18', 1032, 3097, 13467, 13468, 13468, 13468, 13467, 13467, 13467, 2455609, 55608, N'2011-02-16', 201107, 7, 3, N'2011-W07', N'2011-W07-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94279, DATE '2011-02-17', DATE '2011-02-18', 2011, 20111, 201102, 2011048, 1, 2, 48, 17, 5, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-13', DATE '2011-02-19', DATE '2011-02-14', DATE '2011-02-20', DATE '2011-02-15', DATE '2011-02-21', DATE '2011-02-16', DATE '2011-02-22', DATE '2011-02-17', DATE '2011-02-23', DATE '2011-02-11', DATE '2011-02-17', DATE '2011-02-12', DATE '2011-02-18', 1032, 3097, 13467, 13468, 13468, 13468, 13468, 13467, 13467, 2455610, 55609, N'2011-02-17', 201107, 7, 4, N'2011-W07', N'2011-W07-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94280, DATE '2011-02-18', DATE '2011-02-19', 2011, 20111, 201102, 2011049, 1, 2, 49, 18, 6, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-13', DATE '2011-02-19', DATE '2011-02-14', DATE '2011-02-20', DATE '2011-02-15', DATE '2011-02-21', DATE '2011-02-16', DATE '2011-02-22', DATE '2011-02-17', DATE '2011-02-23', DATE '2011-02-18', DATE '2011-02-24', DATE '2011-02-12', DATE '2011-02-18', 1032, 3097, 13467, 13468, 13468, 13468, 13468, 13468, 13467, 2455611, 55610, N'2011-02-18', 201107, 7, 5, N'2011-W07', N'2011-W07-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94281, DATE '2011-02-19', DATE '2011-02-20', 2011, 20111, 201102, 2011050, 1, 2, 50, 19, 7, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-13', DATE '2011-02-19', DATE '2011-02-14', DATE '2011-02-20', DATE '2011-02-15', DATE '2011-02-21', DATE '2011-02-16', DATE '2011-02-22', DATE '2011-02-17', DATE '2011-02-23', DATE '2011-02-18', DATE '2011-02-24', DATE '2011-02-19', DATE '2011-02-25', 1032, 3097, 13467, 13468, 13468, 13468, 13468, 13468, 13468, 2455612, 55611, N'2011-02-19', 201107, 7, 6, N'2011-W07', N'2011-W07-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94282, DATE '2011-02-20', DATE '2011-02-21', 2011, 20111, 201102, 2011051, 1, 2, 51, 20, 1, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-20', DATE '2011-02-26', DATE '2011-02-14', DATE '2011-02-20', DATE '2011-02-15', DATE '2011-02-21', DATE '2011-02-16', DATE '2011-02-22', DATE '2011-02-17', DATE '2011-02-23', DATE '2011-02-18', DATE '2011-02-24', DATE '2011-02-19', DATE '2011-02-25', 1032, 3097, 13468, 13468, 13468, 13468, 13468, 13468, 13468, 2455613, 55612, N'2011-02-20', 201107, 7, 7, N'2011-W07', N'2011-W07-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94283, DATE '2011-02-21', DATE '2011-02-22', 2011, 20111, 201102, 2011052, 1, 2, 52, 21, 2, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-20', DATE '2011-02-26', DATE '2011-02-21', DATE '2011-02-27', DATE '2011-02-15', DATE '2011-02-21', DATE '2011-02-16', DATE '2011-02-22', DATE '2011-02-17', DATE '2011-02-23', DATE '2011-02-18', DATE '2011-02-24', DATE '2011-02-19', DATE '2011-02-25', 1032, 3097, 13468, 13469, 13468, 13468, 13468, 13468, 13468, 2455614, 55613, N'2011-02-21', 201108, 8, 1, N'2011-W08', N'2011-W08-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94284, DATE '2011-02-22', DATE '2011-02-23', 2011, 20111, 201102, 2011053, 1, 2, 53, 22, 3, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-20', DATE '2011-02-26', DATE '2011-02-21', DATE '2011-02-27', DATE '2011-02-22', DATE '2011-02-28', DATE '2011-02-16', DATE '2011-02-22', DATE '2011-02-17', DATE '2011-02-23', DATE '2011-02-18', DATE '2011-02-24', DATE '2011-02-19', DATE '2011-02-25', 1032, 3097, 13468, 13469, 13469, 13468, 13468, 13468, 13468, 2455615, 55614, N'2011-02-22', 201108, 8, 2, N'2011-W08', N'2011-W08-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94285, DATE '2011-02-23', DATE '2011-02-24', 2011, 20111, 201102, 2011054, 1, 2, 54, 23, 4, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-20', DATE '2011-02-26', DATE '2011-02-21', DATE '2011-02-27', DATE '2011-02-22', DATE '2011-02-28', DATE '2011-02-23', DATE '2011-03-01', DATE '2011-02-17', DATE '2011-02-23', DATE '2011-02-18', DATE '2011-02-24', DATE '2011-02-19', DATE '2011-02-25', 1032, 3097, 13468, 13469, 13469, 13469, 13468, 13468, 13468, 2455616, 55615, N'2011-02-23', 201108, 8, 3, N'2011-W08', N'2011-W08-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94286, DATE '2011-02-24', DATE '2011-02-25', 2011, 20111, 201102, 2011055, 1, 2, 55, 24, 5, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-20', DATE '2011-02-26', DATE '2011-02-21', DATE '2011-02-27', DATE '2011-02-22', DATE '2011-02-28', DATE '2011-02-23', DATE '2011-03-01', DATE '2011-02-24', DATE '2011-03-02', DATE '2011-02-18', DATE '2011-02-24', DATE '2011-02-19', DATE '2011-02-25', 1032, 3097, 13468, 13469, 13469, 13469, 13469, 13468, 13468, 2455617, 55616, N'2011-02-24', 201108, 8, 4, N'2011-W08', N'2011-W08-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94287, DATE '2011-02-25', DATE '2011-02-26', 2011, 20111, 201102, 2011056, 1, 2, 56, 25, 6, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-20', DATE '2011-02-26', DATE '2011-02-21', DATE '2011-02-27', DATE '2011-02-22', DATE '2011-02-28', DATE '2011-02-23', DATE '2011-03-01', DATE '2011-02-24', DATE '2011-03-02', DATE '2011-02-25', DATE '2011-03-03', DATE '2011-02-19', DATE '2011-02-25', 1032, 3097, 13468, 13469, 13469, 13469, 13469, 13469, 13468, 2455618, 55617, N'2011-02-25', 201108, 8, 5, N'2011-W08', N'2011-W08-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94288, DATE '2011-02-26', DATE '2011-02-27', 2011, 20111, 201102, 2011057, 1, 2, 57, 26, 7, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-20', DATE '2011-02-26', DATE '2011-02-21', DATE '2011-02-27', DATE '2011-02-22', DATE '2011-02-28', DATE '2011-02-23', DATE '2011-03-01', DATE '2011-02-24', DATE '2011-03-02', DATE '2011-02-25', DATE '2011-03-03', DATE '2011-02-26', DATE '2011-03-04', 1032, 3097, 13468, 13469, 13469, 13469, 13469, 13469, 13469, 2455619, 55618, N'2011-02-26', 201108, 8, 6, N'2011-W08', N'2011-W08-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94289, DATE '2011-02-27', DATE '2011-02-28', 2011, 20111, 201102, 2011058, 1, 2, 58, 27, 1, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-27', DATE '2011-03-05', DATE '2011-02-21', DATE '2011-02-27', DATE '2011-02-22', DATE '2011-02-28', DATE '2011-02-23', DATE '2011-03-01', DATE '2011-02-24', DATE '2011-03-02', DATE '2011-02-25', DATE '2011-03-03', DATE '2011-02-26', DATE '2011-03-04', 1032, 3097, 13469, 13469, 13469, 13469, 13469, 13469, 13469, 2455620, 55619, N'2011-02-27', 201108, 8, 7, N'2011-W08', N'2011-W08-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94290, DATE '2011-02-28', DATE '2011-03-01', 2011, 20111, 201102, 2011059, 1, 2, 59, 28, 2, N'2011', N'2011 Q1', N'2011 Feb', N'Feb', N'February', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-02-01', DATE '2011-02-28', DATE '2011-02-27', DATE '2011-03-05', DATE '2011-02-28', DATE '2011-03-06', DATE '2011-02-22', DATE '2011-02-28', DATE '2011-02-23', DATE '2011-03-01', DATE '2011-02-24', DATE '2011-03-02', DATE '2011-02-25', DATE '2011-03-03', DATE '2011-02-26', DATE '2011-03-04', 1032, 3097, 13469, 13470, 13469, 13469, 13469, 13469, 13469, 2455621, 55620, N'2011-02-28', 201109, 9, 1, N'2011-W09', N'2011-W09-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94291, DATE '2011-03-01', DATE '2011-03-02', 2011, 20111, 201103, 2011060, 1, 3, 60, 1, 3, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-02-27', DATE '2011-03-05', DATE '2011-02-28', DATE '2011-03-06', DATE '2011-03-01', DATE '2011-03-07', DATE '2011-02-23', DATE '2011-03-01', DATE '2011-02-24', DATE '2011-03-02', DATE '2011-02-25', DATE '2011-03-03', DATE '2011-02-26', DATE '2011-03-04', 1032, 3098, 13469, 13470, 13470, 13469, 13469, 13469, 13469, 2455622, 55621, N'2011-03-01', 201109, 9, 2, N'2011-W09', N'2011-W09-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94292, DATE '2011-03-02', DATE '2011-03-03', 2011, 20111, 201103, 2011061, 1, 3, 61, 2, 4, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-02-27', DATE '2011-03-05', DATE '2011-02-28', DATE '2011-03-06', DATE '2011-03-01', DATE '2011-03-07', DATE '2011-03-02', DATE '2011-03-08', DATE '2011-02-24', DATE '2011-03-02', DATE '2011-02-25', DATE '2011-03-03', DATE '2011-02-26', DATE '2011-03-04', 1032, 3098, 13469, 13470, 13470, 13470, 13469, 13469, 13469, 2455623, 55622, N'2011-03-02', 201109, 9, 3, N'2011-W09', N'2011-W09-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94293, DATE '2011-03-03', DATE '2011-03-04', 2011, 20111, 201103, 2011062, 1, 3, 62, 3, 5, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-02-27', DATE '2011-03-05', DATE '2011-02-28', DATE '2011-03-06', DATE '2011-03-01', DATE '2011-03-07', DATE '2011-03-02', DATE '2011-03-08', DATE '2011-03-03', DATE '2011-03-09', DATE '2011-02-25', DATE '2011-03-03', DATE '2011-02-26', DATE '2011-03-04', 1032, 3098, 13469, 13470, 13470, 13470, 13470, 13469, 13469, 2455624, 55623, N'2011-03-03', 201109, 9, 4, N'2011-W09', N'2011-W09-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94294, DATE '2011-03-04', DATE '2011-03-05', 2011, 20111, 201103, 2011063, 1, 3, 63, 4, 6, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-02-27', DATE '2011-03-05', DATE '2011-02-28', DATE '2011-03-06', DATE '2011-03-01', DATE '2011-03-07', DATE '2011-03-02', DATE '2011-03-08', DATE '2011-03-03', DATE '2011-03-09', DATE '2011-03-04', DATE '2011-03-10', DATE '2011-02-26', DATE '2011-03-04', 1032, 3098, 13469, 13470, 13470, 13470, 13470, 13470, 13469, 2455625, 55624, N'2011-03-04', 201109, 9, 5, N'2011-W09', N'2011-W09-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94295, DATE '2011-03-05', DATE '2011-03-06', 2011, 20111, 201103, 2011064, 1, 3, 64, 5, 7, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-02-27', DATE '2011-03-05', DATE '2011-02-28', DATE '2011-03-06', DATE '2011-03-01', DATE '2011-03-07', DATE '2011-03-02', DATE '2011-03-08', DATE '2011-03-03', DATE '2011-03-09', DATE '2011-03-04', DATE '2011-03-10', DATE '2011-03-05', DATE '2011-03-11', 1032, 3098, 13469, 13470, 13470, 13470, 13470, 13470, 13470, 2455626, 55625, N'2011-03-05', 201109, 9, 6, N'2011-W09', N'2011-W09-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94296, DATE '2011-03-06', DATE '2011-03-07', 2011, 20111, 201103, 2011065, 1, 3, 65, 6, 1, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-06', DATE '2011-03-12', DATE '2011-02-28', DATE '2011-03-06', DATE '2011-03-01', DATE '2011-03-07', DATE '2011-03-02', DATE '2011-03-08', DATE '2011-03-03', DATE '2011-03-09', DATE '2011-03-04', DATE '2011-03-10', DATE '2011-03-05', DATE '2011-03-11', 1032, 3098, 13470, 13470, 13470, 13470, 13470, 13470, 13470, 2455627, 55626, N'2011-03-06', 201109, 9, 7, N'2011-W09', N'2011-W09-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94297, DATE '2011-03-07', DATE '2011-03-08', 2011, 20111, 201103, 2011066, 1, 3, 66, 7, 2, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-06', DATE '2011-03-12', DATE '2011-03-07', DATE '2011-03-13', DATE '2011-03-01', DATE '2011-03-07', DATE '2011-03-02', DATE '2011-03-08', DATE '2011-03-03', DATE '2011-03-09', DATE '2011-03-04', DATE '2011-03-10', DATE '2011-03-05', DATE '2011-03-11', 1032, 3098, 13470, 13471, 13470, 13470, 13470, 13470, 13470, 2455628, 55627, N'2011-03-07', 201110, 10, 1, N'2011-W10', N'2011-W10-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94298, DATE '2011-03-08', DATE '2011-03-09', 2011, 20111, 201103, 2011067, 1, 3, 67, 8, 3, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-06', DATE '2011-03-12', DATE '2011-03-07', DATE '2011-03-13', DATE '2011-03-08', DATE '2011-03-14', DATE '2011-03-02', DATE '2011-03-08', DATE '2011-03-03', DATE '2011-03-09', DATE '2011-03-04', DATE '2011-03-10', DATE '2011-03-05', DATE '2011-03-11', 1032, 3098, 13470, 13471, 13471, 13470, 13470, 13470, 13470, 2455629, 55628, N'2011-03-08', 201110, 10, 2, N'2011-W10', N'2011-W10-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94299, DATE '2011-03-09', DATE '2011-03-10', 2011, 20111, 201103, 2011068, 1, 3, 68, 9, 4, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-06', DATE '2011-03-12', DATE '2011-03-07', DATE '2011-03-13', DATE '2011-03-08', DATE '2011-03-14', DATE '2011-03-09', DATE '2011-03-15', DATE '2011-03-03', DATE '2011-03-09', DATE '2011-03-04', DATE '2011-03-10', DATE '2011-03-05', DATE '2011-03-11', 1032, 3098, 13470, 13471, 13471, 13471, 13470, 13470, 13470, 2455630, 55629, N'2011-03-09', 201110, 10, 3, N'2011-W10', N'2011-W10-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94300, DATE '2011-03-10', DATE '2011-03-11', 2011, 20111, 201103, 2011069, 1, 3, 69, 10, 5, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-06', DATE '2011-03-12', DATE '2011-03-07', DATE '2011-03-13', DATE '2011-03-08', DATE '2011-03-14', DATE '2011-03-09', DATE '2011-03-15', DATE '2011-03-10', DATE '2011-03-16', DATE '2011-03-04', DATE '2011-03-10', DATE '2011-03-05', DATE '2011-03-11', 1032, 3098, 13470, 13471, 13471, 13471, 13471, 13470, 13470, 2455631, 55630, N'2011-03-10', 201110, 10, 4, N'2011-W10', N'2011-W10-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94301, DATE '2011-03-11', DATE '2011-03-12', 2011, 20111, 201103, 2011070, 1, 3, 70, 11, 6, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-06', DATE '2011-03-12', DATE '2011-03-07', DATE '2011-03-13', DATE '2011-03-08', DATE '2011-03-14', DATE '2011-03-09', DATE '2011-03-15', DATE '2011-03-10', DATE '2011-03-16', DATE '2011-03-11', DATE '2011-03-17', DATE '2011-03-05', DATE '2011-03-11', 1032, 3098, 13470, 13471, 13471, 13471, 13471, 13471, 13470, 2455632, 55631, N'2011-03-11', 201110, 10, 5, N'2011-W10', N'2011-W10-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94302, DATE '2011-03-12', DATE '2011-03-13', 2011, 20111, 201103, 2011071, 1, 3, 71, 12, 7, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-06', DATE '2011-03-12', DATE '2011-03-07', DATE '2011-03-13', DATE '2011-03-08', DATE '2011-03-14', DATE '2011-03-09', DATE '2011-03-15', DATE '2011-03-10', DATE '2011-03-16', DATE '2011-03-11', DATE '2011-03-17', DATE '2011-03-12', DATE '2011-03-18', 1032, 3098, 13470, 13471, 13471, 13471, 13471, 13471, 13471, 2455633, 55632, N'2011-03-12', 201110, 10, 6, N'2011-W10', N'2011-W10-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94303, DATE '2011-03-13', DATE '2011-03-14', 2011, 20111, 201103, 2011072, 1, 3, 72, 13, 1, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-13', DATE '2011-03-19', DATE '2011-03-07', DATE '2011-03-13', DATE '2011-03-08', DATE '2011-03-14', DATE '2011-03-09', DATE '2011-03-15', DATE '2011-03-10', DATE '2011-03-16', DATE '2011-03-11', DATE '2011-03-17', DATE '2011-03-12', DATE '2011-03-18', 1032, 3098, 13471, 13471, 13471, 13471, 13471, 13471, 13471, 2455634, 55633, N'2011-03-13', 201110, 10, 7, N'2011-W10', N'2011-W10-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94304, DATE '2011-03-14', DATE '2011-03-15', 2011, 20111, 201103, 2011073, 1, 3, 73, 14, 2, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-13', DATE '2011-03-19', DATE '2011-03-14', DATE '2011-03-20', DATE '2011-03-08', DATE '2011-03-14', DATE '2011-03-09', DATE '2011-03-15', DATE '2011-03-10', DATE '2011-03-16', DATE '2011-03-11', DATE '2011-03-17', DATE '2011-03-12', DATE '2011-03-18', 1032, 3098, 13471, 13472, 13471, 13471, 13471, 13471, 13471, 2455635, 55634, N'2011-03-14', 201111, 11, 1, N'2011-W11', N'2011-W11-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94305, DATE '2011-03-15', DATE '2011-03-16', 2011, 20111, 201103, 2011074, 1, 3, 74, 15, 3, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-13', DATE '2011-03-19', DATE '2011-03-14', DATE '2011-03-20', DATE '2011-03-15', DATE '2011-03-21', DATE '2011-03-09', DATE '2011-03-15', DATE '2011-03-10', DATE '2011-03-16', DATE '2011-03-11', DATE '2011-03-17', DATE '2011-03-12', DATE '2011-03-18', 1032, 3098, 13471, 13472, 13472, 13471, 13471, 13471, 13471, 2455636, 55635, N'2011-03-15', 201111, 11, 2, N'2011-W11', N'2011-W11-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94306, DATE '2011-03-16', DATE '2011-03-17', 2011, 20111, 201103, 2011075, 1, 3, 75, 16, 4, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-13', DATE '2011-03-19', DATE '2011-03-14', DATE '2011-03-20', DATE '2011-03-15', DATE '2011-03-21', DATE '2011-03-16', DATE '2011-03-22', DATE '2011-03-10', DATE '2011-03-16', DATE '2011-03-11', DATE '2011-03-17', DATE '2011-03-12', DATE '2011-03-18', 1032, 3098, 13471, 13472, 13472, 13472, 13471, 13471, 13471, 2455637, 55636, N'2011-03-16', 201111, 11, 3, N'2011-W11', N'2011-W11-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94307, DATE '2011-03-17', DATE '2011-03-18', 2011, 20111, 201103, 2011076, 1, 3, 76, 17, 5, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-13', DATE '2011-03-19', DATE '2011-03-14', DATE '2011-03-20', DATE '2011-03-15', DATE '2011-03-21', DATE '2011-03-16', DATE '2011-03-22', DATE '2011-03-17', DATE '2011-03-23', DATE '2011-03-11', DATE '2011-03-17', DATE '2011-03-12', DATE '2011-03-18', 1032, 3098, 13471, 13472, 13472, 13472, 13472, 13471, 13471, 2455638, 55637, N'2011-03-17', 201111, 11, 4, N'2011-W11', N'2011-W11-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94308, DATE '2011-03-18', DATE '2011-03-19', 2011, 20111, 201103, 2011077, 1, 3, 77, 18, 6, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-13', DATE '2011-03-19', DATE '2011-03-14', DATE '2011-03-20', DATE '2011-03-15', DATE '2011-03-21', DATE '2011-03-16', DATE '2011-03-22', DATE '2011-03-17', DATE '2011-03-23', DATE '2011-03-18', DATE '2011-03-24', DATE '2011-03-12', DATE '2011-03-18', 1032, 3098, 13471, 13472, 13472, 13472, 13472, 13472, 13471, 2455639, 55638, N'2011-03-18', 201111, 11, 5, N'2011-W11', N'2011-W11-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94309, DATE '2011-03-19', DATE '2011-03-20', 2011, 20111, 201103, 2011078, 1, 3, 78, 19, 7, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-13', DATE '2011-03-19', DATE '2011-03-14', DATE '2011-03-20', DATE '2011-03-15', DATE '2011-03-21', DATE '2011-03-16', DATE '2011-03-22', DATE '2011-03-17', DATE '2011-03-23', DATE '2011-03-18', DATE '2011-03-24', DATE '2011-03-19', DATE '2011-03-25', 1032, 3098, 13471, 13472, 13472, 13472, 13472, 13472, 13472, 2455640, 55639, N'2011-03-19', 201111, 11, 6, N'2011-W11', N'2011-W11-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94310, DATE '2011-03-20', DATE '2011-03-21', 2011, 20111, 201103, 2011079, 1, 3, 79, 20, 1, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-20', DATE '2011-03-26', DATE '2011-03-14', DATE '2011-03-20', DATE '2011-03-15', DATE '2011-03-21', DATE '2011-03-16', DATE '2011-03-22', DATE '2011-03-17', DATE '2011-03-23', DATE '2011-03-18', DATE '2011-03-24', DATE '2011-03-19', DATE '2011-03-25', 1032, 3098, 13472, 13472, 13472, 13472, 13472, 13472, 13472, 2455641, 55640, N'2011-03-20', 201111, 11, 7, N'2011-W11', N'2011-W11-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94311, DATE '2011-03-21', DATE '2011-03-22', 2011, 20111, 201103, 2011080, 1, 3, 80, 21, 2, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-20', DATE '2011-03-26', DATE '2011-03-21', DATE '2011-03-27', DATE '2011-03-15', DATE '2011-03-21', DATE '2011-03-16', DATE '2011-03-22', DATE '2011-03-17', DATE '2011-03-23', DATE '2011-03-18', DATE '2011-03-24', DATE '2011-03-19', DATE '2011-03-25', 1032, 3098, 13472, 13473, 13472, 13472, 13472, 13472, 13472, 2455642, 55641, N'2011-03-21', 201112, 12, 1, N'2011-W12', N'2011-W12-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94312, DATE '2011-03-22', DATE '2011-03-23', 2011, 20111, 201103, 2011081, 1, 3, 81, 22, 3, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-20', DATE '2011-03-26', DATE '2011-03-21', DATE '2011-03-27', DATE '2011-03-22', DATE '2011-03-28', DATE '2011-03-16', DATE '2011-03-22', DATE '2011-03-17', DATE '2011-03-23', DATE '2011-03-18', DATE '2011-03-24', DATE '2011-03-19', DATE '2011-03-25', 1032, 3098, 13472, 13473, 13473, 13472, 13472, 13472, 13472, 2455643, 55642, N'2011-03-22', 201112, 12, 2, N'2011-W12', N'2011-W12-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94313, DATE '2011-03-23', DATE '2011-03-24', 2011, 20111, 201103, 2011082, 1, 3, 82, 23, 4, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-20', DATE '2011-03-26', DATE '2011-03-21', DATE '2011-03-27', DATE '2011-03-22', DATE '2011-03-28', DATE '2011-03-23', DATE '2011-03-29', DATE '2011-03-17', DATE '2011-03-23', DATE '2011-03-18', DATE '2011-03-24', DATE '2011-03-19', DATE '2011-03-25', 1032, 3098, 13472, 13473, 13473, 13473, 13472, 13472, 13472, 2455644, 55643, N'2011-03-23', 201112, 12, 3, N'2011-W12', N'2011-W12-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94314, DATE '2011-03-24', DATE '2011-03-25', 2011, 20111, 201103, 2011083, 1, 3, 83, 24, 5, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-20', DATE '2011-03-26', DATE '2011-03-21', DATE '2011-03-27', DATE '2011-03-22', DATE '2011-03-28', DATE '2011-03-23', DATE '2011-03-29', DATE '2011-03-24', DATE '2011-03-30', DATE '2011-03-18', DATE '2011-03-24', DATE '2011-03-19', DATE '2011-03-25', 1032, 3098, 13472, 13473, 13473, 13473, 13473, 13472, 13472, 2455645, 55644, N'2011-03-24', 201112, 12, 4, N'2011-W12', N'2011-W12-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94315, DATE '2011-03-25', DATE '2011-03-26', 2011, 20111, 201103, 2011084, 1, 3, 84, 25, 6, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-20', DATE '2011-03-26', DATE '2011-03-21', DATE '2011-03-27', DATE '2011-03-22', DATE '2011-03-28', DATE '2011-03-23', DATE '2011-03-29', DATE '2011-03-24', DATE '2011-03-30', DATE '2011-03-25', DATE '2011-03-31', DATE '2011-03-19', DATE '2011-03-25', 1032, 3098, 13472, 13473, 13473, 13473, 13473, 13473, 13472, 2455646, 55645, N'2011-03-25', 201112, 12, 5, N'2011-W12', N'2011-W12-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94316, DATE '2011-03-26', DATE '2011-03-27', 2011, 20111, 201103, 2011085, 1, 3, 85, 26, 7, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-20', DATE '2011-03-26', DATE '2011-03-21', DATE '2011-03-27', DATE '2011-03-22', DATE '2011-03-28', DATE '2011-03-23', DATE '2011-03-29', DATE '2011-03-24', DATE '2011-03-30', DATE '2011-03-25', DATE '2011-03-31', DATE '2011-03-26', DATE '2011-04-01', 1032, 3098, 13472, 13473, 13473, 13473, 13473, 13473, 13473, 2455647, 55646, N'2011-03-26', 201112, 12, 6, N'2011-W12', N'2011-W12-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94317, DATE '2011-03-27', DATE '2011-03-28', 2011, 20111, 201103, 2011086, 1, 3, 86, 27, 1, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-27', DATE '2011-04-02', DATE '2011-03-21', DATE '2011-03-27', DATE '2011-03-22', DATE '2011-03-28', DATE '2011-03-23', DATE '2011-03-29', DATE '2011-03-24', DATE '2011-03-30', DATE '2011-03-25', DATE '2011-03-31', DATE '2011-03-26', DATE '2011-04-01', 1032, 3098, 13473, 13473, 13473, 13473, 13473, 13473, 13473, 2455648, 55647, N'2011-03-27', 201112, 12, 7, N'2011-W12', N'2011-W12-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94318, DATE '2011-03-28', DATE '2011-03-29', 2011, 20111, 201103, 2011087, 1, 3, 87, 28, 2, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-27', DATE '2011-04-02', DATE '2011-03-28', DATE '2011-04-03', DATE '2011-03-22', DATE '2011-03-28', DATE '2011-03-23', DATE '2011-03-29', DATE '2011-03-24', DATE '2011-03-30', DATE '2011-03-25', DATE '2011-03-31', DATE '2011-03-26', DATE '2011-04-01', 1032, 3098, 13473, 13474, 13473, 13473, 13473, 13473, 13473, 2455649, 55648, N'2011-03-28', 201113, 13, 1, N'2011-W13', N'2011-W13-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94319, DATE '2011-03-29', DATE '2011-03-30', 2011, 20111, 201103, 2011088, 1, 3, 88, 29, 3, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-27', DATE '2011-04-02', DATE '2011-03-28', DATE '2011-04-03', DATE '2011-03-29', DATE '2011-04-04', DATE '2011-03-23', DATE '2011-03-29', DATE '2011-03-24', DATE '2011-03-30', DATE '2011-03-25', DATE '2011-03-31', DATE '2011-03-26', DATE '2011-04-01', 1032, 3098, 13473, 13474, 13474, 13473, 13473, 13473, 13473, 2455650, 55649, N'2011-03-29', 201113, 13, 2, N'2011-W13', N'2011-W13-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94320, DATE '2011-03-30', DATE '2011-03-31', 2011, 20111, 201103, 2011089, 1, 3, 89, 30, 4, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-27', DATE '2011-04-02', DATE '2011-03-28', DATE '2011-04-03', DATE '2011-03-29', DATE '2011-04-04', DATE '2011-03-30', DATE '2011-04-05', DATE '2011-03-24', DATE '2011-03-30', DATE '2011-03-25', DATE '2011-03-31', DATE '2011-03-26', DATE '2011-04-01', 1032, 3098, 13473, 13474, 13474, 13474, 13473, 13473, 13473, 2455651, 55650, N'2011-03-30', 201113, 13, 3, N'2011-W13', N'2011-W13-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94321, DATE '2011-03-31', DATE '2011-04-01', 2011, 20111, 201103, 2011090, 1, 3, 90, 31, 5, N'2011', N'2011 Q1', N'2011 Mar', N'Mar', N'March', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-01-01', DATE '2011-03-31', DATE '2011-03-01', DATE '2011-03-31', DATE '2011-03-27', DATE '2011-04-02', DATE '2011-03-28', DATE '2011-04-03', DATE '2011-03-29', DATE '2011-04-04', DATE '2011-03-30', DATE '2011-04-05', DATE '2011-03-31', DATE '2011-04-06', DATE '2011-03-25', DATE '2011-03-31', DATE '2011-03-26', DATE '2011-04-01', 1032, 3098, 13473, 13474, 13474, 13474, 13474, 13473, 13473, 2455652, 55651, N'2011-03-31', 201113, 13, 4, N'2011-W13', N'2011-W13-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94322, DATE '2011-04-01', DATE '2011-04-02', 2011, 20112, 201104, 2011091, 2, 4, 91, 1, 6, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-03-27', DATE '2011-04-02', DATE '2011-03-28', DATE '2011-04-03', DATE '2011-03-29', DATE '2011-04-04', DATE '2011-03-30', DATE '2011-04-05', DATE '2011-03-31', DATE '2011-04-06', DATE '2011-04-01', DATE '2011-04-07', DATE '2011-03-26', DATE '2011-04-01', 1033, 3099, 13473, 13474, 13474, 13474, 13474, 13474, 13473, 2455653, 55652, N'2011-04-01', 201113, 13, 5, N'2011-W13', N'2011-W13-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94323, DATE '2011-04-02', DATE '2011-04-03', 2011, 20112, 201104, 2011092, 2, 4, 92, 2, 7, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-03-27', DATE '2011-04-02', DATE '2011-03-28', DATE '2011-04-03', DATE '2011-03-29', DATE '2011-04-04', DATE '2011-03-30', DATE '2011-04-05', DATE '2011-03-31', DATE '2011-04-06', DATE '2011-04-01', DATE '2011-04-07', DATE '2011-04-02', DATE '2011-04-08', 1033, 3099, 13473, 13474, 13474, 13474, 13474, 13474, 13474, 2455654, 55653, N'2011-04-02', 201113, 13, 6, N'2011-W13', N'2011-W13-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94324, DATE '2011-04-03', DATE '2011-04-04', 2011, 20112, 201104, 2011093, 2, 4, 93, 3, 1, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-03', DATE '2011-04-09', DATE '2011-03-28', DATE '2011-04-03', DATE '2011-03-29', DATE '2011-04-04', DATE '2011-03-30', DATE '2011-04-05', DATE '2011-03-31', DATE '2011-04-06', DATE '2011-04-01', DATE '2011-04-07', DATE '2011-04-02', DATE '2011-04-08', 1033, 3099, 13474, 13474, 13474, 13474, 13474, 13474, 13474, 2455655, 55654, N'2011-04-03', 201113, 13, 7, N'2011-W13', N'2011-W13-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94325, DATE '2011-04-04', DATE '2011-04-05', 2011, 20112, 201104, 2011094, 2, 4, 94, 4, 2, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-03', DATE '2011-04-09', DATE '2011-04-04', DATE '2011-04-10', DATE '2011-03-29', DATE '2011-04-04', DATE '2011-03-30', DATE '2011-04-05', DATE '2011-03-31', DATE '2011-04-06', DATE '2011-04-01', DATE '2011-04-07', DATE '2011-04-02', DATE '2011-04-08', 1033, 3099, 13474, 13475, 13474, 13474, 13474, 13474, 13474, 2455656, 55655, N'2011-04-04', 201114, 14, 1, N'2011-W14', N'2011-W14-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94326, DATE '2011-04-05', DATE '2011-04-06', 2011, 20112, 201104, 2011095, 2, 4, 95, 5, 3, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-03', DATE '2011-04-09', DATE '2011-04-04', DATE '2011-04-10', DATE '2011-04-05', DATE '2011-04-11', DATE '2011-03-30', DATE '2011-04-05', DATE '2011-03-31', DATE '2011-04-06', DATE '2011-04-01', DATE '2011-04-07', DATE '2011-04-02', DATE '2011-04-08', 1033, 3099, 13474, 13475, 13475, 13474, 13474, 13474, 13474, 2455657, 55656, N'2011-04-05', 201114, 14, 2, N'2011-W14', N'2011-W14-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94327, DATE '2011-04-06', DATE '2011-04-07', 2011, 20112, 201104, 2011096, 2, 4, 96, 6, 4, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-03', DATE '2011-04-09', DATE '2011-04-04', DATE '2011-04-10', DATE '2011-04-05', DATE '2011-04-11', DATE '2011-04-06', DATE '2011-04-12', DATE '2011-03-31', DATE '2011-04-06', DATE '2011-04-01', DATE '2011-04-07', DATE '2011-04-02', DATE '2011-04-08', 1033, 3099, 13474, 13475, 13475, 13475, 13474, 13474, 13474, 2455658, 55657, N'2011-04-06', 201114, 14, 3, N'2011-W14', N'2011-W14-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94328, DATE '2011-04-07', DATE '2011-04-08', 2011, 20112, 201104, 2011097, 2, 4, 97, 7, 5, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-03', DATE '2011-04-09', DATE '2011-04-04', DATE '2011-04-10', DATE '2011-04-05', DATE '2011-04-11', DATE '2011-04-06', DATE '2011-04-12', DATE '2011-04-07', DATE '2011-04-13', DATE '2011-04-01', DATE '2011-04-07', DATE '2011-04-02', DATE '2011-04-08', 1033, 3099, 13474, 13475, 13475, 13475, 13475, 13474, 13474, 2455659, 55658, N'2011-04-07', 201114, 14, 4, N'2011-W14', N'2011-W14-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94329, DATE '2011-04-08', DATE '2011-04-09', 2011, 20112, 201104, 2011098, 2, 4, 98, 8, 6, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-03', DATE '2011-04-09', DATE '2011-04-04', DATE '2011-04-10', DATE '2011-04-05', DATE '2011-04-11', DATE '2011-04-06', DATE '2011-04-12', DATE '2011-04-07', DATE '2011-04-13', DATE '2011-04-08', DATE '2011-04-14', DATE '2011-04-02', DATE '2011-04-08', 1033, 3099, 13474, 13475, 13475, 13475, 13475, 13475, 13474, 2455660, 55659, N'2011-04-08', 201114, 14, 5, N'2011-W14', N'2011-W14-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94330, DATE '2011-04-09', DATE '2011-04-10', 2011, 20112, 201104, 2011099, 2, 4, 99, 9, 7, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-03', DATE '2011-04-09', DATE '2011-04-04', DATE '2011-04-10', DATE '2011-04-05', DATE '2011-04-11', DATE '2011-04-06', DATE '2011-04-12', DATE '2011-04-07', DATE '2011-04-13', DATE '2011-04-08', DATE '2011-04-14', DATE '2011-04-09', DATE '2011-04-15', 1033, 3099, 13474, 13475, 13475, 13475, 13475, 13475, 13475, 2455661, 55660, N'2011-04-09', 201114, 14, 6, N'2011-W14', N'2011-W14-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94331, DATE '2011-04-10', DATE '2011-04-11', 2011, 20112, 201104, 2011100, 2, 4, 100, 10, 1, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-10', DATE '2011-04-16', DATE '2011-04-04', DATE '2011-04-10', DATE '2011-04-05', DATE '2011-04-11', DATE '2011-04-06', DATE '2011-04-12', DATE '2011-04-07', DATE '2011-04-13', DATE '2011-04-08', DATE '2011-04-14', DATE '2011-04-09', DATE '2011-04-15', 1033, 3099, 13475, 13475, 13475, 13475, 13475, 13475, 13475, 2455662, 55661, N'2011-04-10', 201114, 14, 7, N'2011-W14', N'2011-W14-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94332, DATE '2011-04-11', DATE '2011-04-12', 2011, 20112, 201104, 2011101, 2, 4, 101, 11, 2, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-10', DATE '2011-04-16', DATE '2011-04-11', DATE '2011-04-17', DATE '2011-04-05', DATE '2011-04-11', DATE '2011-04-06', DATE '2011-04-12', DATE '2011-04-07', DATE '2011-04-13', DATE '2011-04-08', DATE '2011-04-14', DATE '2011-04-09', DATE '2011-04-15', 1033, 3099, 13475, 13476, 13475, 13475, 13475, 13475, 13475, 2455663, 55662, N'2011-04-11', 201115, 15, 1, N'2011-W15', N'2011-W15-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94333, DATE '2011-04-12', DATE '2011-04-13', 2011, 20112, 201104, 2011102, 2, 4, 102, 12, 3, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-10', DATE '2011-04-16', DATE '2011-04-11', DATE '2011-04-17', DATE '2011-04-12', DATE '2011-04-18', DATE '2011-04-06', DATE '2011-04-12', DATE '2011-04-07', DATE '2011-04-13', DATE '2011-04-08', DATE '2011-04-14', DATE '2011-04-09', DATE '2011-04-15', 1033, 3099, 13475, 13476, 13476, 13475, 13475, 13475, 13475, 2455664, 55663, N'2011-04-12', 201115, 15, 2, N'2011-W15', N'2011-W15-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94334, DATE '2011-04-13', DATE '2011-04-14', 2011, 20112, 201104, 2011103, 2, 4, 103, 13, 4, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-10', DATE '2011-04-16', DATE '2011-04-11', DATE '2011-04-17', DATE '2011-04-12', DATE '2011-04-18', DATE '2011-04-13', DATE '2011-04-19', DATE '2011-04-07', DATE '2011-04-13', DATE '2011-04-08', DATE '2011-04-14', DATE '2011-04-09', DATE '2011-04-15', 1033, 3099, 13475, 13476, 13476, 13476, 13475, 13475, 13475, 2455665, 55664, N'2011-04-13', 201115, 15, 3, N'2011-W15', N'2011-W15-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94335, DATE '2011-04-14', DATE '2011-04-15', 2011, 20112, 201104, 2011104, 2, 4, 104, 14, 5, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-10', DATE '2011-04-16', DATE '2011-04-11', DATE '2011-04-17', DATE '2011-04-12', DATE '2011-04-18', DATE '2011-04-13', DATE '2011-04-19', DATE '2011-04-14', DATE '2011-04-20', DATE '2011-04-08', DATE '2011-04-14', DATE '2011-04-09', DATE '2011-04-15', 1033, 3099, 13475, 13476, 13476, 13476, 13476, 13475, 13475, 2455666, 55665, N'2011-04-14', 201115, 15, 4, N'2011-W15', N'2011-W15-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94336, DATE '2011-04-15', DATE '2011-04-16', 2011, 20112, 201104, 2011105, 2, 4, 105, 15, 6, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-10', DATE '2011-04-16', DATE '2011-04-11', DATE '2011-04-17', DATE '2011-04-12', DATE '2011-04-18', DATE '2011-04-13', DATE '2011-04-19', DATE '2011-04-14', DATE '2011-04-20', DATE '2011-04-15', DATE '2011-04-21', DATE '2011-04-09', DATE '2011-04-15', 1033, 3099, 13475, 13476, 13476, 13476, 13476, 13476, 13475, 2455667, 55666, N'2011-04-15', 201115, 15, 5, N'2011-W15', N'2011-W15-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94337, DATE '2011-04-16', DATE '2011-04-17', 2011, 20112, 201104, 2011106, 2, 4, 106, 16, 7, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-10', DATE '2011-04-16', DATE '2011-04-11', DATE '2011-04-17', DATE '2011-04-12', DATE '2011-04-18', DATE '2011-04-13', DATE '2011-04-19', DATE '2011-04-14', DATE '2011-04-20', DATE '2011-04-15', DATE '2011-04-21', DATE '2011-04-16', DATE '2011-04-22', 1033, 3099, 13475, 13476, 13476, 13476, 13476, 13476, 13476, 2455668, 55667, N'2011-04-16', 201115, 15, 6, N'2011-W15', N'2011-W15-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94338, DATE '2011-04-17', DATE '2011-04-18', 2011, 20112, 201104, 2011107, 2, 4, 107, 17, 1, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-17', DATE '2011-04-23', DATE '2011-04-11', DATE '2011-04-17', DATE '2011-04-12', DATE '2011-04-18', DATE '2011-04-13', DATE '2011-04-19', DATE '2011-04-14', DATE '2011-04-20', DATE '2011-04-15', DATE '2011-04-21', DATE '2011-04-16', DATE '2011-04-22', 1033, 3099, 13476, 13476, 13476, 13476, 13476, 13476, 13476, 2455669, 55668, N'2011-04-17', 201115, 15, 7, N'2011-W15', N'2011-W15-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94339, DATE '2011-04-18', DATE '2011-04-19', 2011, 20112, 201104, 2011108, 2, 4, 108, 18, 2, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-17', DATE '2011-04-23', DATE '2011-04-18', DATE '2011-04-24', DATE '2011-04-12', DATE '2011-04-18', DATE '2011-04-13', DATE '2011-04-19', DATE '2011-04-14', DATE '2011-04-20', DATE '2011-04-15', DATE '2011-04-21', DATE '2011-04-16', DATE '2011-04-22', 1033, 3099, 13476, 13477, 13476, 13476, 13476, 13476, 13476, 2455670, 55669, N'2011-04-18', 201116, 16, 1, N'2011-W16', N'2011-W16-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94340, DATE '2011-04-19', DATE '2011-04-20', 2011, 20112, 201104, 2011109, 2, 4, 109, 19, 3, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-17', DATE '2011-04-23', DATE '2011-04-18', DATE '2011-04-24', DATE '2011-04-19', DATE '2011-04-25', DATE '2011-04-13', DATE '2011-04-19', DATE '2011-04-14', DATE '2011-04-20', DATE '2011-04-15', DATE '2011-04-21', DATE '2011-04-16', DATE '2011-04-22', 1033, 3099, 13476, 13477, 13477, 13476, 13476, 13476, 13476, 2455671, 55670, N'2011-04-19', 201116, 16, 2, N'2011-W16', N'2011-W16-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94341, DATE '2011-04-20', DATE '2011-04-21', 2011, 20112, 201104, 2011110, 2, 4, 110, 20, 4, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-17', DATE '2011-04-23', DATE '2011-04-18', DATE '2011-04-24', DATE '2011-04-19', DATE '2011-04-25', DATE '2011-04-20', DATE '2011-04-26', DATE '2011-04-14', DATE '2011-04-20', DATE '2011-04-15', DATE '2011-04-21', DATE '2011-04-16', DATE '2011-04-22', 1033, 3099, 13476, 13477, 13477, 13477, 13476, 13476, 13476, 2455672, 55671, N'2011-04-20', 201116, 16, 3, N'2011-W16', N'2011-W16-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94342, DATE '2011-04-21', DATE '2011-04-22', 2011, 20112, 201104, 2011111, 2, 4, 111, 21, 5, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-17', DATE '2011-04-23', DATE '2011-04-18', DATE '2011-04-24', DATE '2011-04-19', DATE '2011-04-25', DATE '2011-04-20', DATE '2011-04-26', DATE '2011-04-21', DATE '2011-04-27', DATE '2011-04-15', DATE '2011-04-21', DATE '2011-04-16', DATE '2011-04-22', 1033, 3099, 13476, 13477, 13477, 13477, 13477, 13476, 13476, 2455673, 55672, N'2011-04-21', 201116, 16, 4, N'2011-W16', N'2011-W16-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94343, DATE '2011-04-22', DATE '2011-04-23', 2011, 20112, 201104, 2011112, 2, 4, 112, 22, 6, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-17', DATE '2011-04-23', DATE '2011-04-18', DATE '2011-04-24', DATE '2011-04-19', DATE '2011-04-25', DATE '2011-04-20', DATE '2011-04-26', DATE '2011-04-21', DATE '2011-04-27', DATE '2011-04-22', DATE '2011-04-28', DATE '2011-04-16', DATE '2011-04-22', 1033, 3099, 13476, 13477, 13477, 13477, 13477, 13477, 13476, 2455674, 55673, N'2011-04-22', 201116, 16, 5, N'2011-W16', N'2011-W16-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94344, DATE '2011-04-23', DATE '2011-04-24', 2011, 20112, 201104, 2011113, 2, 4, 113, 23, 7, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-17', DATE '2011-04-23', DATE '2011-04-18', DATE '2011-04-24', DATE '2011-04-19', DATE '2011-04-25', DATE '2011-04-20', DATE '2011-04-26', DATE '2011-04-21', DATE '2011-04-27', DATE '2011-04-22', DATE '2011-04-28', DATE '2011-04-23', DATE '2011-04-29', 1033, 3099, 13476, 13477, 13477, 13477, 13477, 13477, 13477, 2455675, 55674, N'2011-04-23', 201116, 16, 6, N'2011-W16', N'2011-W16-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94345, DATE '2011-04-24', DATE '2011-04-25', 2011, 20112, 201104, 2011114, 2, 4, 114, 24, 1, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-24', DATE '2011-04-30', DATE '2011-04-18', DATE '2011-04-24', DATE '2011-04-19', DATE '2011-04-25', DATE '2011-04-20', DATE '2011-04-26', DATE '2011-04-21', DATE '2011-04-27', DATE '2011-04-22', DATE '2011-04-28', DATE '2011-04-23', DATE '2011-04-29', 1033, 3099, 13477, 13477, 13477, 13477, 13477, 13477, 13477, 2455676, 55675, N'2011-04-24', 201116, 16, 7, N'2011-W16', N'2011-W16-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94346, DATE '2011-04-25', DATE '2011-04-26', 2011, 20112, 201104, 2011115, 2, 4, 115, 25, 2, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-24', DATE '2011-04-30', DATE '2011-04-25', DATE '2011-05-01', DATE '2011-04-19', DATE '2011-04-25', DATE '2011-04-20', DATE '2011-04-26', DATE '2011-04-21', DATE '2011-04-27', DATE '2011-04-22', DATE '2011-04-28', DATE '2011-04-23', DATE '2011-04-29', 1033, 3099, 13477, 13478, 13477, 13477, 13477, 13477, 13477, 2455677, 55676, N'2011-04-25', 201117, 17, 1, N'2011-W17', N'2011-W17-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94347, DATE '2011-04-26', DATE '2011-04-27', 2011, 20112, 201104, 2011116, 2, 4, 116, 26, 3, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-24', DATE '2011-04-30', DATE '2011-04-25', DATE '2011-05-01', DATE '2011-04-26', DATE '2011-05-02', DATE '2011-04-20', DATE '2011-04-26', DATE '2011-04-21', DATE '2011-04-27', DATE '2011-04-22', DATE '2011-04-28', DATE '2011-04-23', DATE '2011-04-29', 1033, 3099, 13477, 13478, 13478, 13477, 13477, 13477, 13477, 2455678, 55677, N'2011-04-26', 201117, 17, 2, N'2011-W17', N'2011-W17-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94348, DATE '2011-04-27', DATE '2011-04-28', 2011, 20112, 201104, 2011117, 2, 4, 117, 27, 4, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-24', DATE '2011-04-30', DATE '2011-04-25', DATE '2011-05-01', DATE '2011-04-26', DATE '2011-05-02', DATE '2011-04-27', DATE '2011-05-03', DATE '2011-04-21', DATE '2011-04-27', DATE '2011-04-22', DATE '2011-04-28', DATE '2011-04-23', DATE '2011-04-29', 1033, 3099, 13477, 13478, 13478, 13478, 13477, 13477, 13477, 2455679, 55678, N'2011-04-27', 201117, 17, 3, N'2011-W17', N'2011-W17-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94349, DATE '2011-04-28', DATE '2011-04-29', 2011, 20112, 201104, 2011118, 2, 4, 118, 28, 5, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-24', DATE '2011-04-30', DATE '2011-04-25', DATE '2011-05-01', DATE '2011-04-26', DATE '2011-05-02', DATE '2011-04-27', DATE '2011-05-03', DATE '2011-04-28', DATE '2011-05-04', DATE '2011-04-22', DATE '2011-04-28', DATE '2011-04-23', DATE '2011-04-29', 1033, 3099, 13477, 13478, 13478, 13478, 13478, 13477, 13477, 2455680, 55679, N'2011-04-28', 201117, 17, 4, N'2011-W17', N'2011-W17-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94350, DATE '2011-04-29', DATE '2011-04-30', 2011, 20112, 201104, 2011119, 2, 4, 119, 29, 6, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-24', DATE '2011-04-30', DATE '2011-04-25', DATE '2011-05-01', DATE '2011-04-26', DATE '2011-05-02', DATE '2011-04-27', DATE '2011-05-03', DATE '2011-04-28', DATE '2011-05-04', DATE '2011-04-29', DATE '2011-05-05', DATE '2011-04-23', DATE '2011-04-29', 1033, 3099, 13477, 13478, 13478, 13478, 13478, 13478, 13477, 2455681, 55680, N'2011-04-29', 201117, 17, 5, N'2011-W17', N'2011-W17-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94351, DATE '2011-04-30', DATE '2011-05-01', 2011, 20112, 201104, 2011120, 2, 4, 120, 30, 7, N'2011', N'2011 Q2', N'2011 Apr', N'Apr', N'April', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-04-01', DATE '2011-04-30', DATE '2011-04-24', DATE '2011-04-30', DATE '2011-04-25', DATE '2011-05-01', DATE '2011-04-26', DATE '2011-05-02', DATE '2011-04-27', DATE '2011-05-03', DATE '2011-04-28', DATE '2011-05-04', DATE '2011-04-29', DATE '2011-05-05', DATE '2011-04-30', DATE '2011-05-06', 1033, 3099, 13477, 13478, 13478, 13478, 13478, 13478, 13478, 2455682, 55681, N'2011-04-30', 201117, 17, 6, N'2011-W17', N'2011-W17-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94352, DATE '2011-05-01', DATE '2011-05-02', 2011, 20112, 201105, 2011121, 2, 5, 121, 1, 1, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-01', DATE '2011-05-07', DATE '2011-04-25', DATE '2011-05-01', DATE '2011-04-26', DATE '2011-05-02', DATE '2011-04-27', DATE '2011-05-03', DATE '2011-04-28', DATE '2011-05-04', DATE '2011-04-29', DATE '2011-05-05', DATE '2011-04-30', DATE '2011-05-06', 1033, 3100, 13478, 13478, 13478, 13478, 13478, 13478, 13478, 2455683, 55682, N'2011-05-01', 201117, 17, 7, N'2011-W17', N'2011-W17-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94353, DATE '2011-05-02', DATE '2011-05-03', 2011, 20112, 201105, 2011122, 2, 5, 122, 2, 2, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-01', DATE '2011-05-07', DATE '2011-05-02', DATE '2011-05-08', DATE '2011-04-26', DATE '2011-05-02', DATE '2011-04-27', DATE '2011-05-03', DATE '2011-04-28', DATE '2011-05-04', DATE '2011-04-29', DATE '2011-05-05', DATE '2011-04-30', DATE '2011-05-06', 1033, 3100, 13478, 13479, 13478, 13478, 13478, 13478, 13478, 2455684, 55683, N'2011-05-02', 201118, 18, 1, N'2011-W18', N'2011-W18-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94354, DATE '2011-05-03', DATE '2011-05-04', 2011, 20112, 201105, 2011123, 2, 5, 123, 3, 3, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-01', DATE '2011-05-07', DATE '2011-05-02', DATE '2011-05-08', DATE '2011-05-03', DATE '2011-05-09', DATE '2011-04-27', DATE '2011-05-03', DATE '2011-04-28', DATE '2011-05-04', DATE '2011-04-29', DATE '2011-05-05', DATE '2011-04-30', DATE '2011-05-06', 1033, 3100, 13478, 13479, 13479, 13478, 13478, 13478, 13478, 2455685, 55684, N'2011-05-03', 201118, 18, 2, N'2011-W18', N'2011-W18-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94355, DATE '2011-05-04', DATE '2011-05-05', 2011, 20112, 201105, 2011124, 2, 5, 124, 4, 4, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-01', DATE '2011-05-07', DATE '2011-05-02', DATE '2011-05-08', DATE '2011-05-03', DATE '2011-05-09', DATE '2011-05-04', DATE '2011-05-10', DATE '2011-04-28', DATE '2011-05-04', DATE '2011-04-29', DATE '2011-05-05', DATE '2011-04-30', DATE '2011-05-06', 1033, 3100, 13478, 13479, 13479, 13479, 13478, 13478, 13478, 2455686, 55685, N'2011-05-04', 201118, 18, 3, N'2011-W18', N'2011-W18-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94356, DATE '2011-05-05', DATE '2011-05-06', 2011, 20112, 201105, 2011125, 2, 5, 125, 5, 5, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-01', DATE '2011-05-07', DATE '2011-05-02', DATE '2011-05-08', DATE '2011-05-03', DATE '2011-05-09', DATE '2011-05-04', DATE '2011-05-10', DATE '2011-05-05', DATE '2011-05-11', DATE '2011-04-29', DATE '2011-05-05', DATE '2011-04-30', DATE '2011-05-06', 1033, 3100, 13478, 13479, 13479, 13479, 13479, 13478, 13478, 2455687, 55686, N'2011-05-05', 201118, 18, 4, N'2011-W18', N'2011-W18-4');

INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94357, DATE '2011-05-06', DATE '2011-05-07', 2011, 20112, 201105, 2011126, 2, 5, 126, 6, 6, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-01', DATE '2011-05-07', DATE '2011-05-02', DATE '2011-05-08', DATE '2011-05-03', DATE '2011-05-09', DATE '2011-05-04', DATE '2011-05-10', DATE '2011-05-05', DATE '2011-05-11', DATE '2011-05-06', DATE '2011-05-12', DATE '2011-04-30', DATE '2011-05-06', 1033, 3100, 13478, 13479, 13479, 13479, 13479, 13479, 13478, 2455688, 55687, N'2011-05-06', 201118, 18, 5, N'2011-W18', N'2011-W18-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94358, DATE '2011-05-07', DATE '2011-05-08', 2011, 20112, 201105, 2011127, 2, 5, 127, 7, 7, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-01', DATE '2011-05-07', DATE '2011-05-02', DATE '2011-05-08', DATE '2011-05-03', DATE '2011-05-09', DATE '2011-05-04', DATE '2011-05-10', DATE '2011-05-05', DATE '2011-05-11', DATE '2011-05-06', DATE '2011-05-12', DATE '2011-05-07', DATE '2011-05-13', 1033, 3100, 13478, 13479, 13479, 13479, 13479, 13479, 13479, 2455689, 55688, N'2011-05-07', 201118, 18, 6, N'2011-W18', N'2011-W18-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94359, DATE '2011-05-08', DATE '2011-05-09', 2011, 20112, 201105, 2011128, 2, 5, 128, 8, 1, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-08', DATE '2011-05-14', DATE '2011-05-02', DATE '2011-05-08', DATE '2011-05-03', DATE '2011-05-09', DATE '2011-05-04', DATE '2011-05-10', DATE '2011-05-05', DATE '2011-05-11', DATE '2011-05-06', DATE '2011-05-12', DATE '2011-05-07', DATE '2011-05-13', 1033, 3100, 13479, 13479, 13479, 13479, 13479, 13479, 13479, 2455690, 55689, N'2011-05-08', 201118, 18, 7, N'2011-W18', N'2011-W18-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94360, DATE '2011-05-09', DATE '2011-05-10', 2011, 20112, 201105, 2011129, 2, 5, 129, 9, 2, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-08', DATE '2011-05-14', DATE '2011-05-09', DATE '2011-05-15', DATE '2011-05-03', DATE '2011-05-09', DATE '2011-05-04', DATE '2011-05-10', DATE '2011-05-05', DATE '2011-05-11', DATE '2011-05-06', DATE '2011-05-12', DATE '2011-05-07', DATE '2011-05-13', 1033, 3100, 13479, 13480, 13479, 13479, 13479, 13479, 13479, 2455691, 55690, N'2011-05-09', 201119, 19, 1, N'2011-W19', N'2011-W19-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94361, DATE '2011-05-10', DATE '2011-05-11', 2011, 20112, 201105, 2011130, 2, 5, 130, 10, 3, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-08', DATE '2011-05-14', DATE '2011-05-09', DATE '2011-05-15', DATE '2011-05-10', DATE '2011-05-16', DATE '2011-05-04', DATE '2011-05-10', DATE '2011-05-05', DATE '2011-05-11', DATE '2011-05-06', DATE '2011-05-12', DATE '2011-05-07', DATE '2011-05-13', 1033, 3100, 13479, 13480, 13480, 13479, 13479, 13479, 13479, 2455692, 55691, N'2011-05-10', 201119, 19, 2, N'2011-W19', N'2011-W19-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94362, DATE '2011-05-11', DATE '2011-05-12', 2011, 20112, 201105, 2011131, 2, 5, 131, 11, 4, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-08', DATE '2011-05-14', DATE '2011-05-09', DATE '2011-05-15', DATE '2011-05-10', DATE '2011-05-16', DATE '2011-05-11', DATE '2011-05-17', DATE '2011-05-05', DATE '2011-05-11', DATE '2011-05-06', DATE '2011-05-12', DATE '2011-05-07', DATE '2011-05-13', 1033, 3100, 13479, 13480, 13480, 13480, 13479, 13479, 13479, 2455693, 55692, N'2011-05-11', 201119, 19, 3, N'2011-W19', N'2011-W19-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94363, DATE '2011-05-12', DATE '2011-05-13', 2011, 20112, 201105, 2011132, 2, 5, 132, 12, 5, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-08', DATE '2011-05-14', DATE '2011-05-09', DATE '2011-05-15', DATE '2011-05-10', DATE '2011-05-16', DATE '2011-05-11', DATE '2011-05-17', DATE '2011-05-12', DATE '2011-05-18', DATE '2011-05-06', DATE '2011-05-12', DATE '2011-05-07', DATE '2011-05-13', 1033, 3100, 13479, 13480, 13480, 13480, 13480, 13479, 13479, 2455694, 55693, N'2011-05-12', 201119, 19, 4, N'2011-W19', N'2011-W19-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94364, DATE '2011-05-13', DATE '2011-05-14', 2011, 20112, 201105, 2011133, 2, 5, 133, 13, 6, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-08', DATE '2011-05-14', DATE '2011-05-09', DATE '2011-05-15', DATE '2011-05-10', DATE '2011-05-16', DATE '2011-05-11', DATE '2011-05-17', DATE '2011-05-12', DATE '2011-05-18', DATE '2011-05-13', DATE '2011-05-19', DATE '2011-05-07', DATE '2011-05-13', 1033, 3100, 13479, 13480, 13480, 13480, 13480, 13480, 13479, 2455695, 55694, N'2011-05-13', 201119, 19, 5, N'2011-W19', N'2011-W19-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94365, DATE '2011-05-14', DATE '2011-05-15', 2011, 20112, 201105, 2011134, 2, 5, 134, 14, 7, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-08', DATE '2011-05-14', DATE '2011-05-09', DATE '2011-05-15', DATE '2011-05-10', DATE '2011-05-16', DATE '2011-05-11', DATE '2011-05-17', DATE '2011-05-12', DATE '2011-05-18', DATE '2011-05-13', DATE '2011-05-19', DATE '2011-05-14', DATE '2011-05-20', 1033, 3100, 13479, 13480, 13480, 13480, 13480, 13480, 13480, 2455696, 55695, N'2011-05-14', 201119, 19, 6, N'2011-W19', N'2011-W19-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94366, DATE '2011-05-15', DATE '2011-05-16', 2011, 20112, 201105, 2011135, 2, 5, 135, 15, 1, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-15', DATE '2011-05-21', DATE '2011-05-09', DATE '2011-05-15', DATE '2011-05-10', DATE '2011-05-16', DATE '2011-05-11', DATE '2011-05-17', DATE '2011-05-12', DATE '2011-05-18', DATE '2011-05-13', DATE '2011-05-19', DATE '2011-05-14', DATE '2011-05-20', 1033, 3100, 13480, 13480, 13480, 13480, 13480, 13480, 13480, 2455697, 55696, N'2011-05-15', 201119, 19, 7, N'2011-W19', N'2011-W19-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94367, DATE '2011-05-16', DATE '2011-05-17', 2011, 20112, 201105, 2011136, 2, 5, 136, 16, 2, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-15', DATE '2011-05-21', DATE '2011-05-16', DATE '2011-05-22', DATE '2011-05-10', DATE '2011-05-16', DATE '2011-05-11', DATE '2011-05-17', DATE '2011-05-12', DATE '2011-05-18', DATE '2011-05-13', DATE '2011-05-19', DATE '2011-05-14', DATE '2011-05-20', 1033, 3100, 13480, 13481, 13480, 13480, 13480, 13480, 13480, 2455698, 55697, N'2011-05-16', 201120, 20, 1, N'2011-W20', N'2011-W20-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94368, DATE '2011-05-17', DATE '2011-05-18', 2011, 20112, 201105, 2011137, 2, 5, 137, 17, 3, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-15', DATE '2011-05-21', DATE '2011-05-16', DATE '2011-05-22', DATE '2011-05-17', DATE '2011-05-23', DATE '2011-05-11', DATE '2011-05-17', DATE '2011-05-12', DATE '2011-05-18', DATE '2011-05-13', DATE '2011-05-19', DATE '2011-05-14', DATE '2011-05-20', 1033, 3100, 13480, 13481, 13481, 13480, 13480, 13480, 13480, 2455699, 55698, N'2011-05-17', 201120, 20, 2, N'2011-W20', N'2011-W20-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94369, DATE '2011-05-18', DATE '2011-05-19', 2011, 20112, 201105, 2011138, 2, 5, 138, 18, 4, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-15', DATE '2011-05-21', DATE '2011-05-16', DATE '2011-05-22', DATE '2011-05-17', DATE '2011-05-23', DATE '2011-05-18', DATE '2011-05-24', DATE '2011-05-12', DATE '2011-05-18', DATE '2011-05-13', DATE '2011-05-19', DATE '2011-05-14', DATE '2011-05-20', 1033, 3100, 13480, 13481, 13481, 13481, 13480, 13480, 13480, 2455700, 55699, N'2011-05-18', 201120, 20, 3, N'2011-W20', N'2011-W20-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94370, DATE '2011-05-19', DATE '2011-05-20', 2011, 20112, 201105, 2011139, 2, 5, 139, 19, 5, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-15', DATE '2011-05-21', DATE '2011-05-16', DATE '2011-05-22', DATE '2011-05-17', DATE '2011-05-23', DATE '2011-05-18', DATE '2011-05-24', DATE '2011-05-19', DATE '2011-05-25', DATE '2011-05-13', DATE '2011-05-19', DATE '2011-05-14', DATE '2011-05-20', 1033, 3100, 13480, 13481, 13481, 13481, 13481, 13480, 13480, 2455701, 55700, N'2011-05-19', 201120, 20, 4, N'2011-W20', N'2011-W20-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94371, DATE '2011-05-20', DATE '2011-05-21', 2011, 20112, 201105, 2011140, 2, 5, 140, 20, 6, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-15', DATE '2011-05-21', DATE '2011-05-16', DATE '2011-05-22', DATE '2011-05-17', DATE '2011-05-23', DATE '2011-05-18', DATE '2011-05-24', DATE '2011-05-19', DATE '2011-05-25', DATE '2011-05-20', DATE '2011-05-26', DATE '2011-05-14', DATE '2011-05-20', 1033, 3100, 13480, 13481, 13481, 13481, 13481, 13481, 13480, 2455702, 55701, N'2011-05-20', 201120, 20, 5, N'2011-W20', N'2011-W20-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94372, DATE '2011-05-21', DATE '2011-05-22', 2011, 20112, 201105, 2011141, 2, 5, 141, 21, 7, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-15', DATE '2011-05-21', DATE '2011-05-16', DATE '2011-05-22', DATE '2011-05-17', DATE '2011-05-23', DATE '2011-05-18', DATE '2011-05-24', DATE '2011-05-19', DATE '2011-05-25', DATE '2011-05-20', DATE '2011-05-26', DATE '2011-05-21', DATE '2011-05-27', 1033, 3100, 13480, 13481, 13481, 13481, 13481, 13481, 13481, 2455703, 55702, N'2011-05-21', 201120, 20, 6, N'2011-W20', N'2011-W20-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94373, DATE '2011-05-22', DATE '2011-05-23', 2011, 20112, 201105, 2011142, 2, 5, 142, 22, 1, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-22', DATE '2011-05-28', DATE '2011-05-16', DATE '2011-05-22', DATE '2011-05-17', DATE '2011-05-23', DATE '2011-05-18', DATE '2011-05-24', DATE '2011-05-19', DATE '2011-05-25', DATE '2011-05-20', DATE '2011-05-26', DATE '2011-05-21', DATE '2011-05-27', 1033, 3100, 13481, 13481, 13481, 13481, 13481, 13481, 13481, 2455704, 55703, N'2011-05-22', 201120, 20, 7, N'2011-W20', N'2011-W20-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94374, DATE '2011-05-23', DATE '2011-05-24', 2011, 20112, 201105, 2011143, 2, 5, 143, 23, 2, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-22', DATE '2011-05-28', DATE '2011-05-23', DATE '2011-05-29', DATE '2011-05-17', DATE '2011-05-23', DATE '2011-05-18', DATE '2011-05-24', DATE '2011-05-19', DATE '2011-05-25', DATE '2011-05-20', DATE '2011-05-26', DATE '2011-05-21', DATE '2011-05-27', 1033, 3100, 13481, 13482, 13481, 13481, 13481, 13481, 13481, 2455705, 55704, N'2011-05-23', 201121, 21, 1, N'2011-W21', N'2011-W21-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94375, DATE '2011-05-24', DATE '2011-05-25', 2011, 20112, 201105, 2011144, 2, 5, 144, 24, 3, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-22', DATE '2011-05-28', DATE '2011-05-23', DATE '2011-05-29', DATE '2011-05-24', DATE '2011-05-30', DATE '2011-05-18', DATE '2011-05-24', DATE '2011-05-19', DATE '2011-05-25', DATE '2011-05-20', DATE '2011-05-26', DATE '2011-05-21', DATE '2011-05-27', 1033, 3100, 13481, 13482, 13482, 13481, 13481, 13481, 13481, 2455706, 55705, N'2011-05-24', 201121, 21, 2, N'2011-W21', N'2011-W21-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94376, DATE '2011-05-25', DATE '2011-05-26', 2011, 20112, 201105, 2011145, 2, 5, 145, 25, 4, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-22', DATE '2011-05-28', DATE '2011-05-23', DATE '2011-05-29', DATE '2011-05-24', DATE '2011-05-30', DATE '2011-05-25', DATE '2011-05-31', DATE '2011-05-19', DATE '2011-05-25', DATE '2011-05-20', DATE '2011-05-26', DATE '2011-05-21', DATE '2011-05-27', 1033, 3100, 13481, 13482, 13482, 13482, 13481, 13481, 13481, 2455707, 55706, N'2011-05-25', 201121, 21, 3, N'2011-W21', N'2011-W21-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94377, DATE '2011-05-26', DATE '2011-05-27', 2011, 20112, 201105, 2011146, 2, 5, 146, 26, 5, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-22', DATE '2011-05-28', DATE '2011-05-23', DATE '2011-05-29', DATE '2011-05-24', DATE '2011-05-30', DATE '2011-05-25', DATE '2011-05-31', DATE '2011-05-26', DATE '2011-06-01', DATE '2011-05-20', DATE '2011-05-26', DATE '2011-05-21', DATE '2011-05-27', 1033, 3100, 13481, 13482, 13482, 13482, 13482, 13481, 13481, 2455708, 55707, N'2011-05-26', 201121, 21, 4, N'2011-W21', N'2011-W21-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94378, DATE '2011-05-27', DATE '2011-05-28', 2011, 20112, 201105, 2011147, 2, 5, 147, 27, 6, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-22', DATE '2011-05-28', DATE '2011-05-23', DATE '2011-05-29', DATE '2011-05-24', DATE '2011-05-30', DATE '2011-05-25', DATE '2011-05-31', DATE '2011-05-26', DATE '2011-06-01', DATE '2011-05-27', DATE '2011-06-02', DATE '2011-05-21', DATE '2011-05-27', 1033, 3100, 13481, 13482, 13482, 13482, 13482, 13482, 13481, 2455709, 55708, N'2011-05-27', 201121, 21, 5, N'2011-W21', N'2011-W21-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94379, DATE '2011-05-28', DATE '2011-05-29', 2011, 20112, 201105, 2011148, 2, 5, 148, 28, 7, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-22', DATE '2011-05-28', DATE '2011-05-23', DATE '2011-05-29', DATE '2011-05-24', DATE '2011-05-30', DATE '2011-05-25', DATE '2011-05-31', DATE '2011-05-26', DATE '2011-06-01', DATE '2011-05-27', DATE '2011-06-02', DATE '2011-05-28', DATE '2011-06-03', 1033, 3100, 13481, 13482, 13482, 13482, 13482, 13482, 13482, 2455710, 55709, N'2011-05-28', 201121, 21, 6, N'2011-W21', N'2011-W21-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94380, DATE '2011-05-29', DATE '2011-05-30', 2011, 20112, 201105, 2011149, 2, 5, 149, 29, 1, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-29', DATE '2011-06-04', DATE '2011-05-23', DATE '2011-05-29', DATE '2011-05-24', DATE '2011-05-30', DATE '2011-05-25', DATE '2011-05-31', DATE '2011-05-26', DATE '2011-06-01', DATE '2011-05-27', DATE '2011-06-02', DATE '2011-05-28', DATE '2011-06-03', 1033, 3100, 13482, 13482, 13482, 13482, 13482, 13482, 13482, 2455711, 55710, N'2011-05-29', 201121, 21, 7, N'2011-W21', N'2011-W21-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94381, DATE '2011-05-30', DATE '2011-05-31', 2011, 20112, 201105, 2011150, 2, 5, 150, 30, 2, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-29', DATE '2011-06-04', DATE '2011-05-30', DATE '2011-06-05', DATE '2011-05-24', DATE '2011-05-30', DATE '2011-05-25', DATE '2011-05-31', DATE '2011-05-26', DATE '2011-06-01', DATE '2011-05-27', DATE '2011-06-02', DATE '2011-05-28', DATE '2011-06-03', 1033, 3100, 13482, 13483, 13482, 13482, 13482, 13482, 13482, 2455712, 55711, N'2011-05-30', 201122, 22, 1, N'2011-W22', N'2011-W22-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94382, DATE '2011-05-31', DATE '2011-06-01', 2011, 20112, 201105, 2011151, 2, 5, 151, 31, 3, N'2011', N'2011 Q2', N'2011 May', N'May', N'May', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-05-01', DATE '2011-05-31', DATE '2011-05-29', DATE '2011-06-04', DATE '2011-05-30', DATE '2011-06-05', DATE '2011-05-31', DATE '2011-06-06', DATE '2011-05-25', DATE '2011-05-31', DATE '2011-05-26', DATE '2011-06-01', DATE '2011-05-27', DATE '2011-06-02', DATE '2011-05-28', DATE '2011-06-03', 1033, 3100, 13482, 13483, 13483, 13482, 13482, 13482, 13482, 2455713, 55712, N'2011-05-31', 201122, 22, 2, N'2011-W22', N'2011-W22-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94383, DATE '2011-06-01', DATE '2011-06-02', 2011, 20112, 201106, 2011152, 2, 6, 152, 1, 4, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-05-29', DATE '2011-06-04', DATE '2011-05-30', DATE '2011-06-05', DATE '2011-05-31', DATE '2011-06-06', DATE '2011-06-01', DATE '2011-06-07', DATE '2011-05-26', DATE '2011-06-01', DATE '2011-05-27', DATE '2011-06-02', DATE '2011-05-28', DATE '2011-06-03', 1033, 3101, 13482, 13483, 13483, 13483, 13482, 13482, 13482, 2455714, 55713, N'2011-06-01', 201122, 22, 3, N'2011-W22', N'2011-W22-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94384, DATE '2011-06-02', DATE '2011-06-03', 2011, 20112, 201106, 2011153, 2, 6, 153, 2, 5, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-05-29', DATE '2011-06-04', DATE '2011-05-30', DATE '2011-06-05', DATE '2011-05-31', DATE '2011-06-06', DATE '2011-06-01', DATE '2011-06-07', DATE '2011-06-02', DATE '2011-06-08', DATE '2011-05-27', DATE '2011-06-02', DATE '2011-05-28', DATE '2011-06-03', 1033, 3101, 13482, 13483, 13483, 13483, 13483, 13482, 13482, 2455715, 55714, N'2011-06-02', 201122, 22, 4, N'2011-W22', N'2011-W22-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94385, DATE '2011-06-03', DATE '2011-06-04', 2011, 20112, 201106, 2011154, 2, 6, 154, 3, 6, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-05-29', DATE '2011-06-04', DATE '2011-05-30', DATE '2011-06-05', DATE '2011-05-31', DATE '2011-06-06', DATE '2011-06-01', DATE '2011-06-07', DATE '2011-06-02', DATE '2011-06-08', DATE '2011-06-03', DATE '2011-06-09', DATE '2011-05-28', DATE '2011-06-03', 1033, 3101, 13482, 13483, 13483, 13483, 13483, 13483, 13482, 2455716, 55715, N'2011-06-03', 201122, 22, 5, N'2011-W22', N'2011-W22-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94386, DATE '2011-06-04', DATE '2011-06-05', 2011, 20112, 201106, 2011155, 2, 6, 155, 4, 7, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-05-29', DATE '2011-06-04', DATE '2011-05-30', DATE '2011-06-05', DATE '2011-05-31', DATE '2011-06-06', DATE '2011-06-01', DATE '2011-06-07', DATE '2011-06-02', DATE '2011-06-08', DATE '2011-06-03', DATE '2011-06-09', DATE '2011-06-04', DATE '2011-06-10', 1033, 3101, 13482, 13483, 13483, 13483, 13483, 13483, 13483, 2455717, 55716, N'2011-06-04', 201122, 22, 6, N'2011-W22', N'2011-W22-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94387, DATE '2011-06-05', DATE '2011-06-06', 2011, 20112, 201106, 2011156, 2, 6, 156, 5, 1, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-05', DATE '2011-06-11', DATE '2011-05-30', DATE '2011-06-05', DATE '2011-05-31', DATE '2011-06-06', DATE '2011-06-01', DATE '2011-06-07', DATE '2011-06-02', DATE '2011-06-08', DATE '2011-06-03', DATE '2011-06-09', DATE '2011-06-04', DATE '2011-06-10', 1033, 3101, 13483, 13483, 13483, 13483, 13483, 13483, 13483, 2455718, 55717, N'2011-06-05', 201122, 22, 7, N'2011-W22', N'2011-W22-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94388, DATE '2011-06-06', DATE '2011-06-07', 2011, 20112, 201106, 2011157, 2, 6, 157, 6, 2, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-05', DATE '2011-06-11', DATE '2011-06-06', DATE '2011-06-12', DATE '2011-05-31', DATE '2011-06-06', DATE '2011-06-01', DATE '2011-06-07', DATE '2011-06-02', DATE '2011-06-08', DATE '2011-06-03', DATE '2011-06-09', DATE '2011-06-04', DATE '2011-06-10', 1033, 3101, 13483, 13484, 13483, 13483, 13483, 13483, 13483, 2455719, 55718, N'2011-06-06', 201123, 23, 1, N'2011-W23', N'2011-W23-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94389, DATE '2011-06-07', DATE '2011-06-08', 2011, 20112, 201106, 2011158, 2, 6, 158, 7, 3, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-05', DATE '2011-06-11', DATE '2011-06-06', DATE '2011-06-12', DATE '2011-06-07', DATE '2011-06-13', DATE '2011-06-01', DATE '2011-06-07', DATE '2011-06-02', DATE '2011-06-08', DATE '2011-06-03', DATE '2011-06-09', DATE '2011-06-04', DATE '2011-06-10', 1033, 3101, 13483, 13484, 13484, 13483, 13483, 13483, 13483, 2455720, 55719, N'2011-06-07', 201123, 23, 2, N'2011-W23', N'2011-W23-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94390, DATE '2011-06-08', DATE '2011-06-09', 2011, 20112, 201106, 2011159, 2, 6, 159, 8, 4, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-05', DATE '2011-06-11', DATE '2011-06-06', DATE '2011-06-12', DATE '2011-06-07', DATE '2011-06-13', DATE '2011-06-08', DATE '2011-06-14', DATE '2011-06-02', DATE '2011-06-08', DATE '2011-06-03', DATE '2011-06-09', DATE '2011-06-04', DATE '2011-06-10', 1033, 3101, 13483, 13484, 13484, 13484, 13483, 13483, 13483, 2455721, 55720, N'2011-06-08', 201123, 23, 3, N'2011-W23', N'2011-W23-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94391, DATE '2011-06-09', DATE '2011-06-10', 2011, 20112, 201106, 2011160, 2, 6, 160, 9, 5, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-05', DATE '2011-06-11', DATE '2011-06-06', DATE '2011-06-12', DATE '2011-06-07', DATE '2011-06-13', DATE '2011-06-08', DATE '2011-06-14', DATE '2011-06-09', DATE '2011-06-15', DATE '2011-06-03', DATE '2011-06-09', DATE '2011-06-04', DATE '2011-06-10', 1033, 3101, 13483, 13484, 13484, 13484, 13484, 13483, 13483, 2455722, 55721, N'2011-06-09', 201123, 23, 4, N'2011-W23', N'2011-W23-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94392, DATE '2011-06-10', DATE '2011-06-11', 2011, 20112, 201106, 2011161, 2, 6, 161, 10, 6, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-05', DATE '2011-06-11', DATE '2011-06-06', DATE '2011-06-12', DATE '2011-06-07', DATE '2011-06-13', DATE '2011-06-08', DATE '2011-06-14', DATE '2011-06-09', DATE '2011-06-15', DATE '2011-06-10', DATE '2011-06-16', DATE '2011-06-04', DATE '2011-06-10', 1033, 3101, 13483, 13484, 13484, 13484, 13484, 13484, 13483, 2455723, 55722, N'2011-06-10', 201123, 23, 5, N'2011-W23', N'2011-W23-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94393, DATE '2011-06-11', DATE '2011-06-12', 2011, 20112, 201106, 2011162, 2, 6, 162, 11, 7, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-05', DATE '2011-06-11', DATE '2011-06-06', DATE '2011-06-12', DATE '2011-06-07', DATE '2011-06-13', DATE '2011-06-08', DATE '2011-06-14', DATE '2011-06-09', DATE '2011-06-15', DATE '2011-06-10', DATE '2011-06-16', DATE '2011-06-11', DATE '2011-06-17', 1033, 3101, 13483, 13484, 13484, 13484, 13484, 13484, 13484, 2455724, 55723, N'2011-06-11', 201123, 23, 6, N'2011-W23', N'2011-W23-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94394, DATE '2011-06-12', DATE '2011-06-13', 2011, 20112, 201106, 2011163, 2, 6, 163, 12, 1, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-12', DATE '2011-06-18', DATE '2011-06-06', DATE '2011-06-12', DATE '2011-06-07', DATE '2011-06-13', DATE '2011-06-08', DATE '2011-06-14', DATE '2011-06-09', DATE '2011-06-15', DATE '2011-06-10', DATE '2011-06-16', DATE '2011-06-11', DATE '2011-06-17', 1033, 3101, 13484, 13484, 13484, 13484, 13484, 13484, 13484, 2455725, 55724, N'2011-06-12', 201123, 23, 7, N'2011-W23', N'2011-W23-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94395, DATE '2011-06-13', DATE '2011-06-14', 2011, 20112, 201106, 2011164, 2, 6, 164, 13, 2, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-12', DATE '2011-06-18', DATE '2011-06-13', DATE '2011-06-19', DATE '2011-06-07', DATE '2011-06-13', DATE '2011-06-08', DATE '2011-06-14', DATE '2011-06-09', DATE '2011-06-15', DATE '2011-06-10', DATE '2011-06-16', DATE '2011-06-11', DATE '2011-06-17', 1033, 3101, 13484, 13485, 13484, 13484, 13484, 13484, 13484, 2455726, 55725, N'2011-06-13', 201124, 24, 1, N'2011-W24', N'2011-W24-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94396, DATE '2011-06-14', DATE '2011-06-15', 2011, 20112, 201106, 2011165, 2, 6, 165, 14, 3, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-12', DATE '2011-06-18', DATE '2011-06-13', DATE '2011-06-19', DATE '2011-06-14', DATE '2011-06-20', DATE '2011-06-08', DATE '2011-06-14', DATE '2011-06-09', DATE '2011-06-15', DATE '2011-06-10', DATE '2011-06-16', DATE '2011-06-11', DATE '2011-06-17', 1033, 3101, 13484, 13485, 13485, 13484, 13484, 13484, 13484, 2455727, 55726, N'2011-06-14', 201124, 24, 2, N'2011-W24', N'2011-W24-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94397, DATE '2011-06-15', DATE '2011-06-16', 2011, 20112, 201106, 2011166, 2, 6, 166, 15, 4, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-12', DATE '2011-06-18', DATE '2011-06-13', DATE '2011-06-19', DATE '2011-06-14', DATE '2011-06-20', DATE '2011-06-15', DATE '2011-06-21', DATE '2011-06-09', DATE '2011-06-15', DATE '2011-06-10', DATE '2011-06-16', DATE '2011-06-11', DATE '2011-06-17', 1033, 3101, 13484, 13485, 13485, 13485, 13484, 13484, 13484, 2455728, 55727, N'2011-06-15', 201124, 24, 3, N'2011-W24', N'2011-W24-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94398, DATE '2011-06-16', DATE '2011-06-17', 2011, 20112, 201106, 2011167, 2, 6, 167, 16, 5, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-12', DATE '2011-06-18', DATE '2011-06-13', DATE '2011-06-19', DATE '2011-06-14', DATE '2011-06-20', DATE '2011-06-15', DATE '2011-06-21', DATE '2011-06-16', DATE '2011-06-22', DATE '2011-06-10', DATE '2011-06-16', DATE '2011-06-11', DATE '2011-06-17', 1033, 3101, 13484, 13485, 13485, 13485, 13485, 13484, 13484, 2455729, 55728, N'2011-06-16', 201124, 24, 4, N'2011-W24', N'2011-W24-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94399, DATE '2011-06-17', DATE '2011-06-18', 2011, 20112, 201106, 2011168, 2, 6, 168, 17, 6, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-12', DATE '2011-06-18', DATE '2011-06-13', DATE '2011-06-19', DATE '2011-06-14', DATE '2011-06-20', DATE '2011-06-15', DATE '2011-06-21', DATE '2011-06-16', DATE '2011-06-22', DATE '2011-06-17', DATE '2011-06-23', DATE '2011-06-11', DATE '2011-06-17', 1033, 3101, 13484, 13485, 13485, 13485, 13485, 13485, 13484, 2455730, 55729, N'2011-06-17', 201124, 24, 5, N'2011-W24', N'2011-W24-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94400, DATE '2011-06-18', DATE '2011-06-19', 2011, 20112, 201106, 2011169, 2, 6, 169, 18, 7, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-12', DATE '2011-06-18', DATE '2011-06-13', DATE '2011-06-19', DATE '2011-06-14', DATE '2011-06-20', DATE '2011-06-15', DATE '2011-06-21', DATE '2011-06-16', DATE '2011-06-22', DATE '2011-06-17', DATE '2011-06-23', DATE '2011-06-18', DATE '2011-06-24', 1033, 3101, 13484, 13485, 13485, 13485, 13485, 13485, 13485, 2455731, 55730, N'2011-06-18', 201124, 24, 6, N'2011-W24', N'2011-W24-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94401, DATE '2011-06-19', DATE '2011-06-20', 2011, 20112, 201106, 2011170, 2, 6, 170, 19, 1, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-19', DATE '2011-06-25', DATE '2011-06-13', DATE '2011-06-19', DATE '2011-06-14', DATE '2011-06-20', DATE '2011-06-15', DATE '2011-06-21', DATE '2011-06-16', DATE '2011-06-22', DATE '2011-06-17', DATE '2011-06-23', DATE '2011-06-18', DATE '2011-06-24', 1033, 3101, 13485, 13485, 13485, 13485, 13485, 13485, 13485, 2455732, 55731, N'2011-06-19', 201124, 24, 7, N'2011-W24', N'2011-W24-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94402, DATE '2011-06-20', DATE '2011-06-21', 2011, 20112, 201106, 2011171, 2, 6, 171, 20, 2, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-19', DATE '2011-06-25', DATE '2011-06-20', DATE '2011-06-26', DATE '2011-06-14', DATE '2011-06-20', DATE '2011-06-15', DATE '2011-06-21', DATE '2011-06-16', DATE '2011-06-22', DATE '2011-06-17', DATE '2011-06-23', DATE '2011-06-18', DATE '2011-06-24', 1033, 3101, 13485, 13486, 13485, 13485, 13485, 13485, 13485, 2455733, 55732, N'2011-06-20', 201125, 25, 1, N'2011-W25', N'2011-W25-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94403, DATE '2011-06-21', DATE '2011-06-22', 2011, 20112, 201106, 2011172, 2, 6, 172, 21, 3, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-19', DATE '2011-06-25', DATE '2011-06-20', DATE '2011-06-26', DATE '2011-06-21', DATE '2011-06-27', DATE '2011-06-15', DATE '2011-06-21', DATE '2011-06-16', DATE '2011-06-22', DATE '2011-06-17', DATE '2011-06-23', DATE '2011-06-18', DATE '2011-06-24', 1033, 3101, 13485, 13486, 13486, 13485, 13485, 13485, 13485, 2455734, 55733, N'2011-06-21', 201125, 25, 2, N'2011-W25', N'2011-W25-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94404, DATE '2011-06-22', DATE '2011-06-23', 2011, 20112, 201106, 2011173, 2, 6, 173, 22, 4, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-19', DATE '2011-06-25', DATE '2011-06-20', DATE '2011-06-26', DATE '2011-06-21', DATE '2011-06-27', DATE '2011-06-22', DATE '2011-06-28', DATE '2011-06-16', DATE '2011-06-22', DATE '2011-06-17', DATE '2011-06-23', DATE '2011-06-18', DATE '2011-06-24', 1033, 3101, 13485, 13486, 13486, 13486, 13485, 13485, 13485, 2455735, 55734, N'2011-06-22', 201125, 25, 3, N'2011-W25', N'2011-W25-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94405, DATE '2011-06-23', DATE '2011-06-24', 2011, 20112, 201106, 2011174, 2, 6, 174, 23, 5, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-19', DATE '2011-06-25', DATE '2011-06-20', DATE '2011-06-26', DATE '2011-06-21', DATE '2011-06-27', DATE '2011-06-22', DATE '2011-06-28', DATE '2011-06-23', DATE '2011-06-29', DATE '2011-06-17', DATE '2011-06-23', DATE '2011-06-18', DATE '2011-06-24', 1033, 3101, 13485, 13486, 13486, 13486, 13486, 13485, 13485, 2455736, 55735, N'2011-06-23', 201125, 25, 4, N'2011-W25', N'2011-W25-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94406, DATE '2011-06-24', DATE '2011-06-25', 2011, 20112, 201106, 2011175, 2, 6, 175, 24, 6, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-19', DATE '2011-06-25', DATE '2011-06-20', DATE '2011-06-26', DATE '2011-06-21', DATE '2011-06-27', DATE '2011-06-22', DATE '2011-06-28', DATE '2011-06-23', DATE '2011-06-29', DATE '2011-06-24', DATE '2011-06-30', DATE '2011-06-18', DATE '2011-06-24', 1033, 3101, 13485, 13486, 13486, 13486, 13486, 13486, 13485, 2455737, 55736, N'2011-06-24', 201125, 25, 5, N'2011-W25', N'2011-W25-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94407, DATE '2011-06-25', DATE '2011-06-26', 2011, 20112, 201106, 2011176, 2, 6, 176, 25, 7, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-19', DATE '2011-06-25', DATE '2011-06-20', DATE '2011-06-26', DATE '2011-06-21', DATE '2011-06-27', DATE '2011-06-22', DATE '2011-06-28', DATE '2011-06-23', DATE '2011-06-29', DATE '2011-06-24', DATE '2011-06-30', DATE '2011-06-25', DATE '2011-07-01', 1033, 3101, 13485, 13486, 13486, 13486, 13486, 13486, 13486, 2455738, 55737, N'2011-06-25', 201125, 25, 6, N'2011-W25', N'2011-W25-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94408, DATE '2011-06-26', DATE '2011-06-27', 2011, 20112, 201106, 2011177, 2, 6, 177, 26, 1, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-26', DATE '2011-07-02', DATE '2011-06-20', DATE '2011-06-26', DATE '2011-06-21', DATE '2011-06-27', DATE '2011-06-22', DATE '2011-06-28', DATE '2011-06-23', DATE '2011-06-29', DATE '2011-06-24', DATE '2011-06-30', DATE '2011-06-25', DATE '2011-07-01', 1033, 3101, 13486, 13486, 13486, 13486, 13486, 13486, 13486, 2455739, 55738, N'2011-06-26', 201125, 25, 7, N'2011-W25', N'2011-W25-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94409, DATE '2011-06-27', DATE '2011-06-28', 2011, 20112, 201106, 2011178, 2, 6, 178, 27, 2, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-26', DATE '2011-07-02', DATE '2011-06-27', DATE '2011-07-03', DATE '2011-06-21', DATE '2011-06-27', DATE '2011-06-22', DATE '2011-06-28', DATE '2011-06-23', DATE '2011-06-29', DATE '2011-06-24', DATE '2011-06-30', DATE '2011-06-25', DATE '2011-07-01', 1033, 3101, 13486, 13487, 13486, 13486, 13486, 13486, 13486, 2455740, 55739, N'2011-06-27', 201126, 26, 1, N'2011-W26', N'2011-W26-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94410, DATE '2011-06-28', DATE '2011-06-29', 2011, 20112, 201106, 2011179, 2, 6, 179, 28, 3, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-26', DATE '2011-07-02', DATE '2011-06-27', DATE '2011-07-03', DATE '2011-06-28', DATE '2011-07-04', DATE '2011-06-22', DATE '2011-06-28', DATE '2011-06-23', DATE '2011-06-29', DATE '2011-06-24', DATE '2011-06-30', DATE '2011-06-25', DATE '2011-07-01', 1033, 3101, 13486, 13487, 13487, 13486, 13486, 13486, 13486, 2455741, 55740, N'2011-06-28', 201126, 26, 2, N'2011-W26', N'2011-W26-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94411, DATE '2011-06-29', DATE '2011-06-30', 2011, 20112, 201106, 2011180, 2, 6, 180, 29, 4, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-26', DATE '2011-07-02', DATE '2011-06-27', DATE '2011-07-03', DATE '2011-06-28', DATE '2011-07-04', DATE '2011-06-29', DATE '2011-07-05', DATE '2011-06-23', DATE '2011-06-29', DATE '2011-06-24', DATE '2011-06-30', DATE '2011-06-25', DATE '2011-07-01', 1033, 3101, 13486, 13487, 13487, 13487, 13486, 13486, 13486, 2455742, 55741, N'2011-06-29', 201126, 26, 3, N'2011-W26', N'2011-W26-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94412, DATE '2011-06-30', DATE '2011-07-01', 2011, 20112, 201106, 2011181, 2, 6, 181, 30, 5, N'2011', N'2011 Q2', N'2011 Jun', N'Jun', N'June', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-04-01', DATE '2011-06-30', DATE '2011-06-01', DATE '2011-06-30', DATE '2011-06-26', DATE '2011-07-02', DATE '2011-06-27', DATE '2011-07-03', DATE '2011-06-28', DATE '2011-07-04', DATE '2011-06-29', DATE '2011-07-05', DATE '2011-06-30', DATE '2011-07-06', DATE '2011-06-24', DATE '2011-06-30', DATE '2011-06-25', DATE '2011-07-01', 1033, 3101, 13486, 13487, 13487, 13487, 13487, 13486, 13486, 2455743, 55742, N'2011-06-30', 201126, 26, 4, N'2011-W26', N'2011-W26-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94413, DATE '2011-07-01', DATE '2011-07-02', 2011, 20113, 201107, 2011182, 3, 7, 182, 1, 6, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-06-26', DATE '2011-07-02', DATE '2011-06-27', DATE '2011-07-03', DATE '2011-06-28', DATE '2011-07-04', DATE '2011-06-29', DATE '2011-07-05', DATE '2011-06-30', DATE '2011-07-06', DATE '2011-07-01', DATE '2011-07-07', DATE '2011-06-25', DATE '2011-07-01', 1034, 3102, 13486, 13487, 13487, 13487, 13487, 13487, 13486, 2455744, 55743, N'2011-07-01', 201126, 26, 5, N'2011-W26', N'2011-W26-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94414, DATE '2011-07-02', DATE '2011-07-03', 2011, 20113, 201107, 2011183, 3, 7, 183, 2, 7, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-06-26', DATE '2011-07-02', DATE '2011-06-27', DATE '2011-07-03', DATE '2011-06-28', DATE '2011-07-04', DATE '2011-06-29', DATE '2011-07-05', DATE '2011-06-30', DATE '2011-07-06', DATE '2011-07-01', DATE '2011-07-07', DATE '2011-07-02', DATE '2011-07-08', 1034, 3102, 13486, 13487, 13487, 13487, 13487, 13487, 13487, 2455745, 55744, N'2011-07-02', 201126, 26, 6, N'2011-W26', N'2011-W26-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94415, DATE '2011-07-03', DATE '2011-07-04', 2011, 20113, 201107, 2011184, 3, 7, 184, 3, 1, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-03', DATE '2011-07-09', DATE '2011-06-27', DATE '2011-07-03', DATE '2011-06-28', DATE '2011-07-04', DATE '2011-06-29', DATE '2011-07-05', DATE '2011-06-30', DATE '2011-07-06', DATE '2011-07-01', DATE '2011-07-07', DATE '2011-07-02', DATE '2011-07-08', 1034, 3102, 13487, 13487, 13487, 13487, 13487, 13487, 13487, 2455746, 55745, N'2011-07-03', 201126, 26, 7, N'2011-W26', N'2011-W26-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94416, DATE '2011-07-04', DATE '2011-07-05', 2011, 20113, 201107, 2011185, 3, 7, 185, 4, 2, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-03', DATE '2011-07-09', DATE '2011-07-04', DATE '2011-07-10', DATE '2011-06-28', DATE '2011-07-04', DATE '2011-06-29', DATE '2011-07-05', DATE '2011-06-30', DATE '2011-07-06', DATE '2011-07-01', DATE '2011-07-07', DATE '2011-07-02', DATE '2011-07-08', 1034, 3102, 13487, 13488, 13487, 13487, 13487, 13487, 13487, 2455747, 55746, N'2011-07-04', 201127, 27, 1, N'2011-W27', N'2011-W27-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94417, DATE '2011-07-05', DATE '2011-07-06', 2011, 20113, 201107, 2011186, 3, 7, 186, 5, 3, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-03', DATE '2011-07-09', DATE '2011-07-04', DATE '2011-07-10', DATE '2011-07-05', DATE '2011-07-11', DATE '2011-06-29', DATE '2011-07-05', DATE '2011-06-30', DATE '2011-07-06', DATE '2011-07-01', DATE '2011-07-07', DATE '2011-07-02', DATE '2011-07-08', 1034, 3102, 13487, 13488, 13488, 13487, 13487, 13487, 13487, 2455748, 55747, N'2011-07-05', 201127, 27, 2, N'2011-W27', N'2011-W27-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94418, DATE '2011-07-06', DATE '2011-07-07', 2011, 20113, 201107, 2011187, 3, 7, 187, 6, 4, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-03', DATE '2011-07-09', DATE '2011-07-04', DATE '2011-07-10', DATE '2011-07-05', DATE '2011-07-11', DATE '2011-07-06', DATE '2011-07-12', DATE '2011-06-30', DATE '2011-07-06', DATE '2011-07-01', DATE '2011-07-07', DATE '2011-07-02', DATE '2011-07-08', 1034, 3102, 13487, 13488, 13488, 13488, 13487, 13487, 13487, 2455749, 55748, N'2011-07-06', 201127, 27, 3, N'2011-W27', N'2011-W27-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94419, DATE '2011-07-07', DATE '2011-07-08', 2011, 20113, 201107, 2011188, 3, 7, 188, 7, 5, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-03', DATE '2011-07-09', DATE '2011-07-04', DATE '2011-07-10', DATE '2011-07-05', DATE '2011-07-11', DATE '2011-07-06', DATE '2011-07-12', DATE '2011-07-07', DATE '2011-07-13', DATE '2011-07-01', DATE '2011-07-07', DATE '2011-07-02', DATE '2011-07-08', 1034, 3102, 13487, 13488, 13488, 13488, 13488, 13487, 13487, 2455750, 55749, N'2011-07-07', 201127, 27, 4, N'2011-W27', N'2011-W27-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94420, DATE '2011-07-08', DATE '2011-07-09', 2011, 20113, 201107, 2011189, 3, 7, 189, 8, 6, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-03', DATE '2011-07-09', DATE '2011-07-04', DATE '2011-07-10', DATE '2011-07-05', DATE '2011-07-11', DATE '2011-07-06', DATE '2011-07-12', DATE '2011-07-07', DATE '2011-07-13', DATE '2011-07-08', DATE '2011-07-14', DATE '2011-07-02', DATE '2011-07-08', 1034, 3102, 13487, 13488, 13488, 13488, 13488, 13488, 13487, 2455751, 55750, N'2011-07-08', 201127, 27, 5, N'2011-W27', N'2011-W27-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94421, DATE '2011-07-09', DATE '2011-07-10', 2011, 20113, 201107, 2011190, 3, 7, 190, 9, 7, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-03', DATE '2011-07-09', DATE '2011-07-04', DATE '2011-07-10', DATE '2011-07-05', DATE '2011-07-11', DATE '2011-07-06', DATE '2011-07-12', DATE '2011-07-07', DATE '2011-07-13', DATE '2011-07-08', DATE '2011-07-14', DATE '2011-07-09', DATE '2011-07-15', 1034, 3102, 13487, 13488, 13488, 13488, 13488, 13488, 13488, 2455752, 55751, N'2011-07-09', 201127, 27, 6, N'2011-W27', N'2011-W27-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94422, DATE '2011-07-10', DATE '2011-07-11', 2011, 20113, 201107, 2011191, 3, 7, 191, 10, 1, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-10', DATE '2011-07-16', DATE '2011-07-04', DATE '2011-07-10', DATE '2011-07-05', DATE '2011-07-11', DATE '2011-07-06', DATE '2011-07-12', DATE '2011-07-07', DATE '2011-07-13', DATE '2011-07-08', DATE '2011-07-14', DATE '2011-07-09', DATE '2011-07-15', 1034, 3102, 13488, 13488, 13488, 13488, 13488, 13488, 13488, 2455753, 55752, N'2011-07-10', 201127, 27, 7, N'2011-W27', N'2011-W27-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94423, DATE '2011-07-11', DATE '2011-07-12', 2011, 20113, 201107, 2011192, 3, 7, 192, 11, 2, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-10', DATE '2011-07-16', DATE '2011-07-11', DATE '2011-07-17', DATE '2011-07-05', DATE '2011-07-11', DATE '2011-07-06', DATE '2011-07-12', DATE '2011-07-07', DATE '2011-07-13', DATE '2011-07-08', DATE '2011-07-14', DATE '2011-07-09', DATE '2011-07-15', 1034, 3102, 13488, 13489, 13488, 13488, 13488, 13488, 13488, 2455754, 55753, N'2011-07-11', 201128, 28, 1, N'2011-W28', N'2011-W28-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94424, DATE '2011-07-12', DATE '2011-07-13', 2011, 20113, 201107, 2011193, 3, 7, 193, 12, 3, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-10', DATE '2011-07-16', DATE '2011-07-11', DATE '2011-07-17', DATE '2011-07-12', DATE '2011-07-18', DATE '2011-07-06', DATE '2011-07-12', DATE '2011-07-07', DATE '2011-07-13', DATE '2011-07-08', DATE '2011-07-14', DATE '2011-07-09', DATE '2011-07-15', 1034, 3102, 13488, 13489, 13489, 13488, 13488, 13488, 13488, 2455755, 55754, N'2011-07-12', 201128, 28, 2, N'2011-W28', N'2011-W28-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94425, DATE '2011-07-13', DATE '2011-07-14', 2011, 20113, 201107, 2011194, 3, 7, 194, 13, 4, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-10', DATE '2011-07-16', DATE '2011-07-11', DATE '2011-07-17', DATE '2011-07-12', DATE '2011-07-18', DATE '2011-07-13', DATE '2011-07-19', DATE '2011-07-07', DATE '2011-07-13', DATE '2011-07-08', DATE '2011-07-14', DATE '2011-07-09', DATE '2011-07-15', 1034, 3102, 13488, 13489, 13489, 13489, 13488, 13488, 13488, 2455756, 55755, N'2011-07-13', 201128, 28, 3, N'2011-W28', N'2011-W28-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94426, DATE '2011-07-14', DATE '2011-07-15', 2011, 20113, 201107, 2011195, 3, 7, 195, 14, 5, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-10', DATE '2011-07-16', DATE '2011-07-11', DATE '2011-07-17', DATE '2011-07-12', DATE '2011-07-18', DATE '2011-07-13', DATE '2011-07-19', DATE '2011-07-14', DATE '2011-07-20', DATE '2011-07-08', DATE '2011-07-14', DATE '2011-07-09', DATE '2011-07-15', 1034, 3102, 13488, 13489, 13489, 13489, 13489, 13488, 13488, 2455757, 55756, N'2011-07-14', 201128, 28, 4, N'2011-W28', N'2011-W28-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94427, DATE '2011-07-15', DATE '2011-07-16', 2011, 20113, 201107, 2011196, 3, 7, 196, 15, 6, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-10', DATE '2011-07-16', DATE '2011-07-11', DATE '2011-07-17', DATE '2011-07-12', DATE '2011-07-18', DATE '2011-07-13', DATE '2011-07-19', DATE '2011-07-14', DATE '2011-07-20', DATE '2011-07-15', DATE '2011-07-21', DATE '2011-07-09', DATE '2011-07-15', 1034, 3102, 13488, 13489, 13489, 13489, 13489, 13489, 13488, 2455758, 55757, N'2011-07-15', 201128, 28, 5, N'2011-W28', N'2011-W28-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94428, DATE '2011-07-16', DATE '2011-07-17', 2011, 20113, 201107, 2011197, 3, 7, 197, 16, 7, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-10', DATE '2011-07-16', DATE '2011-07-11', DATE '2011-07-17', DATE '2011-07-12', DATE '2011-07-18', DATE '2011-07-13', DATE '2011-07-19', DATE '2011-07-14', DATE '2011-07-20', DATE '2011-07-15', DATE '2011-07-21', DATE '2011-07-16', DATE '2011-07-22', 1034, 3102, 13488, 13489, 13489, 13489, 13489, 13489, 13489, 2455759, 55758, N'2011-07-16', 201128, 28, 6, N'2011-W28', N'2011-W28-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94429, DATE '2011-07-17', DATE '2011-07-18', 2011, 20113, 201107, 2011198, 3, 7, 198, 17, 1, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-17', DATE '2011-07-23', DATE '2011-07-11', DATE '2011-07-17', DATE '2011-07-12', DATE '2011-07-18', DATE '2011-07-13', DATE '2011-07-19', DATE '2011-07-14', DATE '2011-07-20', DATE '2011-07-15', DATE '2011-07-21', DATE '2011-07-16', DATE '2011-07-22', 1034, 3102, 13489, 13489, 13489, 13489, 13489, 13489, 13489, 2455760, 55759, N'2011-07-17', 201128, 28, 7, N'2011-W28', N'2011-W28-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94430, DATE '2011-07-18', DATE '2011-07-19', 2011, 20113, 201107, 2011199, 3, 7, 199, 18, 2, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-17', DATE '2011-07-23', DATE '2011-07-18', DATE '2011-07-24', DATE '2011-07-12', DATE '2011-07-18', DATE '2011-07-13', DATE '2011-07-19', DATE '2011-07-14', DATE '2011-07-20', DATE '2011-07-15', DATE '2011-07-21', DATE '2011-07-16', DATE '2011-07-22', 1034, 3102, 13489, 13490, 13489, 13489, 13489, 13489, 13489, 2455761, 55760, N'2011-07-18', 201129, 29, 1, N'2011-W29', N'2011-W29-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94431, DATE '2011-07-19', DATE '2011-07-20', 2011, 20113, 201107, 2011200, 3, 7, 200, 19, 3, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-17', DATE '2011-07-23', DATE '2011-07-18', DATE '2011-07-24', DATE '2011-07-19', DATE '2011-07-25', DATE '2011-07-13', DATE '2011-07-19', DATE '2011-07-14', DATE '2011-07-20', DATE '2011-07-15', DATE '2011-07-21', DATE '2011-07-16', DATE '2011-07-22', 1034, 3102, 13489, 13490, 13490, 13489, 13489, 13489, 13489, 2455762, 55761, N'2011-07-19', 201129, 29, 2, N'2011-W29', N'2011-W29-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94432, DATE '2011-07-20', DATE '2011-07-21', 2011, 20113, 201107, 2011201, 3, 7, 201, 20, 4, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-17', DATE '2011-07-23', DATE '2011-07-18', DATE '2011-07-24', DATE '2011-07-19', DATE '2011-07-25', DATE '2011-07-20', DATE '2011-07-26', DATE '2011-07-14', DATE '2011-07-20', DATE '2011-07-15', DATE '2011-07-21', DATE '2011-07-16', DATE '2011-07-22', 1034, 3102, 13489, 13490, 13490, 13490, 13489, 13489, 13489, 2455763, 55762, N'2011-07-20', 201129, 29, 3, N'2011-W29', N'2011-W29-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94433, DATE '2011-07-21', DATE '2011-07-22', 2011, 20113, 201107, 2011202, 3, 7, 202, 21, 5, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-17', DATE '2011-07-23', DATE '2011-07-18', DATE '2011-07-24', DATE '2011-07-19', DATE '2011-07-25', DATE '2011-07-20', DATE '2011-07-26', DATE '2011-07-21', DATE '2011-07-27', DATE '2011-07-15', DATE '2011-07-21', DATE '2011-07-16', DATE '2011-07-22', 1034, 3102, 13489, 13490, 13490, 13490, 13490, 13489, 13489, 2455764, 55763, N'2011-07-21', 201129, 29, 4, N'2011-W29', N'2011-W29-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94434, DATE '2011-07-22', DATE '2011-07-23', 2011, 20113, 201107, 2011203, 3, 7, 203, 22, 6, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-17', DATE '2011-07-23', DATE '2011-07-18', DATE '2011-07-24', DATE '2011-07-19', DATE '2011-07-25', DATE '2011-07-20', DATE '2011-07-26', DATE '2011-07-21', DATE '2011-07-27', DATE '2011-07-22', DATE '2011-07-28', DATE '2011-07-16', DATE '2011-07-22', 1034, 3102, 13489, 13490, 13490, 13490, 13490, 13490, 13489, 2455765, 55764, N'2011-07-22', 201129, 29, 5, N'2011-W29', N'2011-W29-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94435, DATE '2011-07-23', DATE '2011-07-24', 2011, 20113, 201107, 2011204, 3, 7, 204, 23, 7, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-17', DATE '2011-07-23', DATE '2011-07-18', DATE '2011-07-24', DATE '2011-07-19', DATE '2011-07-25', DATE '2011-07-20', DATE '2011-07-26', DATE '2011-07-21', DATE '2011-07-27', DATE '2011-07-22', DATE '2011-07-28', DATE '2011-07-23', DATE '2011-07-29', 1034, 3102, 13489, 13490, 13490, 13490, 13490, 13490, 13490, 2455766, 55765, N'2011-07-23', 201129, 29, 6, N'2011-W29', N'2011-W29-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94436, DATE '2011-07-24', DATE '2011-07-25', 2011, 20113, 201107, 2011205, 3, 7, 205, 24, 1, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-24', DATE '2011-07-30', DATE '2011-07-18', DATE '2011-07-24', DATE '2011-07-19', DATE '2011-07-25', DATE '2011-07-20', DATE '2011-07-26', DATE '2011-07-21', DATE '2011-07-27', DATE '2011-07-22', DATE '2011-07-28', DATE '2011-07-23', DATE '2011-07-29', 1034, 3102, 13490, 13490, 13490, 13490, 13490, 13490, 13490, 2455767, 55766, N'2011-07-24', 201129, 29, 7, N'2011-W29', N'2011-W29-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94437, DATE '2011-07-25', DATE '2011-07-26', 2011, 20113, 201107, 2011206, 3, 7, 206, 25, 2, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-24', DATE '2011-07-30', DATE '2011-07-25', DATE '2011-07-31', DATE '2011-07-19', DATE '2011-07-25', DATE '2011-07-20', DATE '2011-07-26', DATE '2011-07-21', DATE '2011-07-27', DATE '2011-07-22', DATE '2011-07-28', DATE '2011-07-23', DATE '2011-07-29', 1034, 3102, 13490, 13491, 13490, 13490, 13490, 13490, 13490, 2455768, 55767, N'2011-07-25', 201130, 30, 1, N'2011-W30', N'2011-W30-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94438, DATE '2011-07-26', DATE '2011-07-27', 2011, 20113, 201107, 2011207, 3, 7, 207, 26, 3, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-24', DATE '2011-07-30', DATE '2011-07-25', DATE '2011-07-31', DATE '2011-07-26', DATE '2011-08-01', DATE '2011-07-20', DATE '2011-07-26', DATE '2011-07-21', DATE '2011-07-27', DATE '2011-07-22', DATE '2011-07-28', DATE '2011-07-23', DATE '2011-07-29', 1034, 3102, 13490, 13491, 13491, 13490, 13490, 13490, 13490, 2455769, 55768, N'2011-07-26', 201130, 30, 2, N'2011-W30', N'2011-W30-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94439, DATE '2011-07-27', DATE '2011-07-28', 2011, 20113, 201107, 2011208, 3, 7, 208, 27, 4, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Wed', N'Wednesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-24', DATE '2011-07-30', DATE '2011-07-25', DATE '2011-07-31', DATE '2011-07-26', DATE '2011-08-01', DATE '2011-07-27', DATE '2011-08-02', DATE '2011-07-21', DATE '2011-07-27', DATE '2011-07-22', DATE '2011-07-28', DATE '2011-07-23', DATE '2011-07-29', 1034, 3102, 13490, 13491, 13491, 13491, 13490, 13490, 13490, 2455770, 55769, N'2011-07-27', 201130, 30, 3, N'2011-W30', N'2011-W30-3');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94440, DATE '2011-07-28', DATE '2011-07-29', 2011, 20113, 201107, 2011209, 3, 7, 209, 28, 5, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Thu', N'Thursday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-24', DATE '2011-07-30', DATE '2011-07-25', DATE '2011-07-31', DATE '2011-07-26', DATE '2011-08-01', DATE '2011-07-27', DATE '2011-08-02', DATE '2011-07-28', DATE '2011-08-03', DATE '2011-07-22', DATE '2011-07-28', DATE '2011-07-23', DATE '2011-07-29', 1034, 3102, 13490, 13491, 13491, 13491, 13491, 13490, 13490, 2455771, 55770, N'2011-07-28', 201130, 30, 4, N'2011-W30', N'2011-W30-4');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94441, DATE '2011-07-29', DATE '2011-07-30', 2011, 20113, 201107, 2011210, 3, 7, 210, 29, 6, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Fri', N'Friday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-24', DATE '2011-07-30', DATE '2011-07-25', DATE '2011-07-31', DATE '2011-07-26', DATE '2011-08-01', DATE '2011-07-27', DATE '2011-08-02', DATE '2011-07-28', DATE '2011-08-03', DATE '2011-07-29', DATE '2011-08-04', DATE '2011-07-23', DATE '2011-07-29', 1034, 3102, 13490, 13491, 13491, 13491, 13491, 13491, 13490, 2455772, 55771, N'2011-07-29', 201130, 30, 5, N'2011-W30', N'2011-W30-5');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94442, DATE '2011-07-30', DATE '2011-07-31', 2011, 20113, 201107, 2011211, 3, 7, 211, 30, 7, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Sat', N'Saturday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-24', DATE '2011-07-30', DATE '2011-07-25', DATE '2011-07-31', DATE '2011-07-26', DATE '2011-08-01', DATE '2011-07-27', DATE '2011-08-02', DATE '2011-07-28', DATE '2011-08-03', DATE '2011-07-29', DATE '2011-08-04', DATE '2011-07-30', DATE '2011-08-05', 1034, 3102, 13490, 13491, 13491, 13491, 13491, 13491, 13491, 2455773, 55772, N'2011-07-30', 201130, 30, 6, N'2011-W30', N'2011-W30-6');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94443, DATE '2011-07-31', DATE '2011-08-01', 2011, 20113, 201107, 2011212, 3, 7, 212, 31, 1, N'2011', N'2011 Q3', N'2011 Jul', N'Jul', N'July', N'Sun', N'Sunday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-07-01', DATE '2011-07-31', DATE '2011-07-31', DATE '2011-08-06', DATE '2011-07-25', DATE '2011-07-31', DATE '2011-07-26', DATE '2011-08-01', DATE '2011-07-27', DATE '2011-08-02', DATE '2011-07-28', DATE '2011-08-03', DATE '2011-07-29', DATE '2011-08-04', DATE '2011-07-30', DATE '2011-08-05', 1034, 3102, 13491, 13491, 13491, 13491, 13491, 13491, 13491, 2455774, 55773, N'2011-07-31', 201130, 30, 7, N'2011-W30', N'2011-W30-7');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94444, DATE '2011-08-01', DATE '2011-08-02', 2011, 20113, 201108, 2011213, 3, 8, 213, 1, 2, N'2011', N'2011 Q3', N'2011 Aug', N'Aug', N'August', N'Mon', N'Monday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-08-01', DATE '2011-08-31', DATE '2011-07-31', DATE '2011-08-06', DATE '2011-08-01', DATE '2011-08-07', DATE '2011-07-26', DATE '2011-08-01', DATE '2011-07-27', DATE '2011-08-02', DATE '2011-07-28', DATE '2011-08-03', DATE '2011-07-29', DATE '2011-08-04', DATE '2011-07-30', DATE '2011-08-05', 1034, 3103, 13491, 13492, 13491, 13491, 13491, 13491, 13491, 2455775, 55774, N'2011-08-01', 201131, 31, 1, N'2011-W31', N'2011-W31-1');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStartingThuDate, EndOfWeekStartingThuDate, StartOfWeekStartingFriDate, EndOfWeekStartingFriDate, StartOfWeekStartingSatDate, EndOfWeekStartingSatDate, QuarterSeqNo, MonthSeqNo, WeekStartingSunSeq, WeekStartingMonSeq, WeekStartingTueSeq, WeekStartingWedSeq, WeekStartingThuSeq, WeekStartingFriSeq, WeekStartingSatSeq, JulianDate, ModifiedJulianDate, ISODate, ISOYearWeekNo, ISOWeekNo, ISODayOfWeek, ISOYearWeekName, ISOYearWeekDayOfWeekName) VALUES (94445, DATE '2011-08-02', DATE '2011-08-03', 2011, 20113, 201108, 2011214, 3, 8, 214, 2, 3, N'2011', N'2011 Q3', N'2011 Aug', N'Aug', N'August', N'Tue', N'Tuesday', DATE '2011-01-01', DATE '2011-12-31', DATE '2011-07-01', DATE '2011-09-30', DATE '2011-08-01', DATE '2011-08-31', DATE '2011-07-31', DATE '2011-08-06', DATE '2011-08-01', DATE '2011-08-07', DATE '2011-08-02', DATE '2011-08-08', DATE '2011-07-27', DATE '2011-08-02', DATE '2011-07-28', DATE '2011-08-03', DATE '2011-07-29', DATE '2011-08-04', DATE '2011-07-30', DATE '2011-08-05', 1034, 3103, 13491, 13492, 13492, 13491, 13491, 13491, 13491, 2455776, 55775, N'2011-08-02', 201131, 31, 2, N'2011-W31', N'2011-W31-2');
INSERT INTO DimDate (DateKey, DateValue, NextDayValue, YearValue, YearQuarter, YearMonth, YearDayOfYear, QuarterValue, MonthValue, DayOfYear, DayOfMonth, DayOfWeek, YearName, YearQuarterName, QuarterName, MonthName, MonthNameLong, WeekdayName, WeekdayNameLong, StartOfYearDate, EndOfYearDate, StartOfQuarterDate, EndOfQuarterDate, StartOfMonthDate, EndOfMonthDate, StartOfWeekStartingSunDate, EndOfWeekStartingSunDate, StartOfWeekStartingMonDate, EndOfWeekStartingMonDate, StartOfWeekStartingTueDate, EndOfWeekStartingTueDate, StartOfWeekStartingWedDate, EndOfWeekStartingWedDate, StartOfWeekStar